/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.IDecorationsProvider;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.internal.AbstractDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.AddRemoveFacetsDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ConflictingFacetsFilter;
import org.eclipse.wst.common.project.facet.ui.internal.ConstraintDisplayDialog;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel;
import org.eclipse.wst.common.project.facet.ui.internal.SavePresetDialog;
import org.osgi.framework.Bundle;

public final class FacetsSelectionPanel
extends Composite
implements ISelectionProvider {
    private static final String FACET_COLUMN = "facet";
    private static final String VERSION_COLUMN = "version";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String CW_FACET = "cw.facet";
    private static final String CW_VERSION = "cw.version";
    private static final String SASH1W1 = "sash.1.weight.1";
    private static final String SASH1W2 = "sash.1.weight.2";
    private static final String SASH2W1 = "sash.2.weight.1";
    private static final String SASH2W2 = "sash.2.weight.2";
    private final IDialogSettings settings;
    private final Composite topComposite;
    private final SashForm sform1;
    private final SashForm sform2;
    private final Label presetsLabel;
    private final Combo presetsCombo;
    private final Button savePresetButton;
    private final Button deletePresetButton;
    private final CheckboxTreeViewer tree;
    private final TreeColumn colFacet;
    private final TreeColumn colVersion;
    private final Menu popupMenu;
    private final MenuItem popupMenuConstraints;
    private final ComboBoxCellEditor ceditor;
    private final TableViewer problemsView;
    private final RuntimesPanel runtimesPanel;
    private final Button showHideRuntimesButton;
    private final IWizardContext context;
    private final ArrayList data;
    private final HashSet fixed;
    private final Set base;
    private final HashSet actions;
    private Object oldSelection;
    private IStatus problems;
    private final HashSet filters;
    private final ArrayList listeners;
    private final ArrayList selectionListeners;
    private ConflictingFacetsFilter conflictingFilter;
    private final AddRemoveFacetsDataModel model;
    static /* synthetic */ Class class$0;

    public FacetsSelectionPanel(Composite parent, int style, IWizardContext context, Set base, AddRemoveFacetsDataModel model) {
        super(parent, style);
        this.context = context;
        this.data = new ArrayList();
        this.model = model;
        this.fixed = new HashSet();
        this.base = base == null ? new HashSet() : base;
        this.actions = new HashSet();
        this.oldSelection = null;
        this.problems = Status.OK_STATUS;
        this.filters = new HashSet();
        this.listeners = new ArrayList();
        this.selectionListeners = new ArrayList();
        this.conflictingFilter = null;
        Iterator itr = ProjectFacetsManager.getProjectFacets().iterator();
        while (itr.hasNext()) {
            try {
                this.data.add(new TableRowData((IProjectFacet)itr.next()));
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        IDialogSettings root = FacetUiPlugin.getInstance().getDialogSettings();
        IDialogSettings temp = root.getSection(((Object)((Object)this)).getClass().getName());
        if (temp == null) {
            temp = root.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        if (temp.get(WIDTH) == null) {
            temp.put(WIDTH, 600);
        }
        if (temp.get(HEIGHT) == null) {
            temp.put(HEIGHT, 300);
        }
        if (temp.get(CW_FACET) == null) {
            temp.put(CW_FACET, 200);
        }
        if (temp.get(CW_VERSION) == null) {
            temp.put(CW_VERSION, 100);
        }
        if (temp.get(SASH1W1) == null) {
            temp.put(SASH1W1, 60);
        }
        if (temp.get(SASH1W2) == null) {
            temp.put(SASH1W2, 40);
        }
        if (temp.get(SASH2W1) == null) {
            temp.put(SASH2W1, 70);
        }
        if (temp.get(SASH2W2) == null) {
            temp.put(SASH2W2, 30);
        }
        this.settings = temp;
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData topgd = FacetsSelectionPanel.gdfill();
        topgd.heightHint = this.settings.getInt(HEIGHT);
        topgd.widthHint = this.settings.getInt(WIDTH);
        this.topComposite = new Composite((Composite)this, 0);
        this.topComposite.setLayout((Layout)new GridLayout(4, false));
        this.topComposite.setLayoutData((Object)topgd);
        this.topComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = FacetsSelectionPanel.this.topComposite.getSize();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.WIDTH, size.x);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.HEIGHT, size.y);
            }
        });
        this.presetsLabel = new Label(this.topComposite, 0);
        this.presetsLabel.setText(Resources.presetsLabel);
        this.presetsCombo = new Combo(this.topComposite, 8);
        this.presetsCombo.setLayoutData((Object)FacetsSelectionPanel.gdhfill());
        this.syncWithPresetsModel(this.presetsCombo);
        this.savePresetButton = new Button(this.topComposite, 8);
        this.savePresetButton.setText(Resources.saveButtonLabel);
        this.savePresetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleSavePreset();
            }
        });
        this.deletePresetButton = new Button(this.topComposite, 8);
        this.deletePresetButton.setText(Resources.deleteButtonLabel);
        this.deletePresetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleDeletePreset();
            }
        });
        int width = Math.max(FacetsSelectionPanel.getPreferredWidth((Control)this.savePresetButton), FacetsSelectionPanel.getPreferredWidth((Control)this.deletePresetButton)) + 15;
        this.savePresetButton.setLayoutData((Object)FacetsSelectionPanel.whint(new GridData(), width));
        this.deletePresetButton.setLayoutData((Object)FacetsSelectionPanel.whint(new GridData(), width));
        this.refreshPresetsCombo();
        this.sform1 = new SashForm(this.topComposite, 65792);
        this.sform1.setLayoutData((Object)FacetsSelectionPanel.hspan(FacetsSelectionPanel.gdfill(), 4));
        this.sform2 = new SashForm((Composite)this.sform1, 66048);
        this.sform2.setLayoutData((Object)FacetsSelectionPanel.hspan(FacetsSelectionPanel.gdfill(), 4));
        this.tree = new CheckboxTreeViewer((Composite)this.sform2, 2048);
        this.tree.getTree().setHeaderVisible(true);
        this.ceditor = new ComboBoxCellEditor((Composite)this.tree.getTree(), new String[0], 8);
        this.tree.setColumnProperties(new String[]{FACET_COLUMN, VERSION_COLUMN});
        this.tree.setCellModifier((ICellModifier)new CellModifier());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.ceditor;
        this.tree.setCellEditors(cellEditorArray);
        this.tree.setContentProvider((IContentProvider)new ContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tree.setSorter((ViewerSorter)new Sorter());
        this.colFacet = new TreeColumn(this.tree.getTree(), 0);
        this.colFacet.setText(Resources.facetColumnLabel);
        this.colFacet.setWidth(this.settings.getInt(CW_FACET));
        this.colFacet.setResizable(true);
        this.colFacet.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.CW_FACET, FacetsSelectionPanel.this.colFacet.getWidth());
            }
        });
        this.colVersion = new TreeColumn(this.tree.getTree(), 0);
        this.colVersion.setText(Resources.versionColumnLabel);
        this.colVersion.setWidth(this.settings.getInt(CW_VERSION));
        this.colVersion.setResizable(true);
        this.colVersion.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.CW_VERSION, FacetsSelectionPanel.this.colVersion.getWidth());
            }
        });
        this.popupMenu = new Menu((Decorations)this.getShell(), 8);
        this.popupMenuConstraints = new MenuItem(this.popupMenu, 8);
        this.popupMenuConstraints.setText(Resources.showConstraints);
        this.popupMenuConstraints.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleShowConstraints();
            }
        });
        this.tree.setInput(new Object());
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                FacetsSelectionPanel.this.selectionChanged(e);
            }
        });
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                FacetsSelectionPanel.this.checkStateChanged(e);
            }
        });
        this.tree.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.handleMouseDownEvent(event);
            }
        });
        this.problemsView = new TableViewer((Composite)this.sform2, 2048);
        this.problemsView.setContentProvider((IContentProvider)new ProblemsContentProvider());
        this.problemsView.setLabelProvider((IBaseLabelProvider)new ProblemsLabelProvider());
        this.problemsView.setInput(new Object());
        this.problemsView.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int[] weights = FacetsSelectionPanel.this.sform2.getWeights();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH2W1, weights[0]);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH2W2, weights[1]);
            }
        });
        int[] weights2 = new int[]{this.settings.getInt(SASH2W1), this.settings.getInt(SASH2W2)};
        this.sform2.setWeights(weights2);
        this.runtimesPanel = new RuntimesPanel((Composite)this.sform1, 0, this.model.getTargetedRuntimesDataModel());
        this.runtimesPanel.setLayoutData(FacetsSelectionPanel.hhint(FacetsSelectionPanel.gdhfill(), 80));
        this.model.getTargetedRuntimesDataModel().addRuntimeFilter(new ChangeTargetedRuntimesDataModel.IRuntimeFilter(){

            public boolean check(IRuntime runtime) {
                Iterator itr = FacetsSelectionPanel.this.getSelectedProjectFacets().iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                    if (runtime.supports(fv)) continue;
                    return false;
                }
                return true;
            }
        });
        this.addFilter(new IFilter(){

            public boolean check(IProjectFacetVersion fv) {
                ChangeTargetedRuntimesDataModel dm = FacetsSelectionPanel.this.getDataModel().getTargetedRuntimesDataModel();
                Iterator itr = dm.getTargetedRuntimes().iterator();
                while (itr.hasNext()) {
                    IRuntime r = (IRuntime)itr.next();
                    if (r.supports(fv)) continue;
                    return false;
                }
                return true;
            }
        });
        this.addProjectFacetsListener(new Listener(){

            public void handleEvent(Event event) {
                ChangeTargetedRuntimesDataModel rdm = FacetsSelectionPanel.this.getDataModel().getTargetedRuntimesDataModel();
                rdm.refreshTargetableRuntimes();
            }
        });
        this.model.getTargetedRuntimesDataModel().addListener("targetedRuntimesChanged", new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                FacetsSelectionPanel.this.refresh();
            }
        });
        this.runtimesPanel.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int[] weights = FacetsSelectionPanel.this.sform1.getWeights();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH1W1, weights[0]);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH1W2, weights[1]);
            }
        });
        int[] weights1 = new int[]{this.settings.getInt(SASH1W1), this.settings.getInt(SASH1W2)};
        this.sform1.setWeights(weights1);
        this.sform1.setMaximizedControl((Control)this.sform2);
        this.showHideRuntimesButton = new Button(this.topComposite, 8);
        this.showHideRuntimesButton.setText(Resources.showRuntimes);
        GridData gd = FacetsSelectionPanel.halign(FacetsSelectionPanel.hspan(new GridData(), 4), 3);
        gd = FacetsSelectionPanel.whint(gd, FacetsSelectionPanel.getPreferredWidth((Control)this.showHideRuntimesButton) + 15);
        this.showHideRuntimesButton.setLayoutData((Object)gd);
        this.showHideRuntimesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleShowHideRuntimes();
            }
        });
        this.updateValidationDisplay();
    }

    public AddRemoveFacetsDataModel getDataModel() {
        return this.model;
    }

    public boolean isSelectionValid() {
        return this.problems.getSeverity() != 4;
    }

    public Set getActions() {
        return this.actions;
    }

    public IFacetedProject.Action getAction(IFacetedProject.Action.Type type, IProjectFacetVersion f) {
        return FacetsSelectionPanel.getAction((Set)this.actions, type, f);
    }

    private static IFacetedProject.Action getAction(Set actions, IFacetedProject.Action.Type type, IProjectFacetVersion fv) {
        Iterator itr = actions.iterator();
        while (itr.hasNext()) {
            IFacetedProject.Action action = (IFacetedProject.Action)itr.next();
            if (action.getType() != type || action.getProjectFacetVersion() != fv) continue;
            return action;
        }
        return null;
    }

    private static IFacetedProject.Action getAction(Set actions, IFacetedProject.Action.Type type, IProjectFacet f) {
        Iterator itr = actions.iterator();
        while (itr.hasNext()) {
            IFacetedProject.Action action = (IFacetedProject.Action)itr.next();
            if (action.getType() != type || action.getProjectFacetVersion().getProjectFacet() != f) continue;
            return action;
        }
        return null;
    }

    private IFacetedProject.Action createAction(Set actions, IFacetedProject.Action.Type type, IProjectFacetVersion fv) {
        IFacetedProject.Action action = FacetsSelectionPanel.getAction(actions, type, fv);
        if (action == null) {
            Object config = null;
            if (fv.supports(this.base, type)) {
                try {
                    IProjectFacet f = fv.getProjectFacet();
                    action = FacetsSelectionPanel.getAction(actions, type, f);
                    if (action != null) {
                        IProjectFacetVersion current = action.getProjectFacetVersion();
                        if (fv.supports(this.base, type) && current.supports(this.base, type) && fv.getActionDefinition(this.base, type) == current.getActionDefinition(this.base, type)) {
                            config = action.getConfig();
                            IActionConfig c = null;
                            if (config instanceof IActionConfig) {
                                c = (IActionConfig)config;
                            } else if (config != null) {
                                IAdapterManager m = Platform.getAdapterManager();
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.IActionConfig");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                String t = clazz.getName();
                                c = (IActionConfig)m.loadAdapter(config, t);
                            }
                            if (c != null) {
                                c.setVersion(fv);
                            }
                        }
                    }
                    if (config == null) {
                        String pjname = this.context.getProjectName();
                        config = this.context.getConfig(fv, type, pjname);
                    }
                }
                catch (CoreException e) {
                    FacetUiPlugin.log((Exception)((Object)e));
                }
            }
            action = new IFacetedProject.Action(type, fv, config);
        }
        return action;
    }

    public void setDefaultFacetsForRuntime(IRuntime runtime) {
        Set<IProjectFacetVersion> defaultFacets;
        if (runtime != null) {
            try {
                defaultFacets = runtime.getDefaultFacets((Set)this.fixed);
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
                return;
            }
        } else {
            defaultFacets = new HashSet();
            Iterator itr = this.fixed.iterator();
            while (itr.hasNext()) {
                IProjectFacet f = (IProjectFacet)itr.next();
                defaultFacets.add(f.getDefaultVersion());
            }
        }
        IPreset presetToUse = null;
        Iterator itr = this.model.getPresets().iterator();
        while (itr.hasNext()) {
            IPreset preset = (IPreset)itr.next();
            if (!preset.getProjectFacets().equals(defaultFacets)) continue;
            presetToUse = preset;
            break;
        }
        if (presetToUse == null) {
            this.setSelectedProjectFacets(defaultFacets);
            this.model.setSelectedPreset(null);
        } else {
            this.selectPreset(presetToUse);
        }
    }

    public Set getSelectedProjectFacets() {
        HashSet<IProjectFacetVersion> set = new HashSet<IProjectFacetVersion>();
        int i = 0;
        int n = this.data.size();
        while (i < n) {
            TableRowData trd = (TableRowData)this.data.get(i);
            if (trd.isSelected()) {
                set.add(trd.getCurrentVersion());
            }
            ++i;
        }
        return set;
    }

    public void setSelectedProjectFacets(Set sel) {
        ArrayList<TableRowData> toCheck = new ArrayList<TableRowData>();
        ArrayList<TableRowData> needsCategoryRefresh = new ArrayList<TableRowData>();
        Iterator itr = sel.iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            IProjectFacet f = fv.getProjectFacet();
            TableRowData trd = this.findTableRowData(f, true);
            if (fv.getPluginId() == null) {
                trd.addUnknownVersion(fv);
            }
            trd.setSelected(true);
            trd.setCurrentVersion(fv);
            toCheck.add(trd);
            needsCategoryRefresh.add(trd);
        }
        itr = this.data.iterator();
        while (itr.hasNext()) {
            TableRowData trd = (TableRowData)itr.next();
            if (!trd.isSelected() || sel.contains(trd.getCurrentVersion())) continue;
            trd.setSelected(false);
            needsCategoryRefresh.add(trd);
        }
        this.refresh();
        this.tree.setCheckedElements(toCheck.toArray());
        itr = needsCategoryRefresh.iterator();
        while (itr.hasNext()) {
            this.refreshCategoryState((TableRowData)itr.next());
        }
        this.updateValidationDisplay();
    }

    public void selectPreset(IPreset preset) {
        if (preset != null) {
            if (!this.model.getPresets().contains(preset)) {
                IProjectFacetVersion problemFacet = null;
                Iterator itr = preset.getProjectFacets().iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                    if (!this.isFilteredOut(fv)) continue;
                    problemFacet = fv;
                    break;
                }
                String msg = Resources.bind(Resources.couldNotSelectPreset, preset.getLabel(), problemFacet.getProjectFacet().getLabel(), problemFacet.getVersionString());
                FacetUiPlugin.log(msg);
            } else {
                this.model.setSelectedPreset(preset);
            }
        }
    }

    public void setFixedProjectFacets(Set fixed) {
        this.fixed.clear();
        int i = 0;
        int n = this.data.size();
        while (i < n) {
            ((TableRowData)this.data.get(i)).setFixed(false);
            ++i;
        }
        Iterator itr = fixed.iterator();
        while (itr.hasNext()) {
            IProjectFacet f = (IProjectFacet)itr.next();
            TableRowData trd = this.findTableRowData(f, true);
            this.fixed.add(f);
            trd.setFixed(true);
            trd.setSelected(true);
            this.tree.setChecked((Object)trd, true);
        }
        if (this.conflictingFilter != null) {
            this.filters.remove(this.conflictingFilter);
        }
        this.conflictingFilter = new ConflictingFacetsFilter(fixed);
        this.filters.add(this.conflictingFilter);
        this.refresh();
        this.updateValidationDisplay();
    }

    public void addFilter(IFilter filter) {
        this.filters.add(filter);
        this.refresh();
    }

    public void removeFilter(IFilter filter) {
        this.filters.remove(filter);
        this.refresh();
    }

    public boolean setFocus() {
        return this.tree.getTree().setFocus();
    }

    public void addProjectFacetsListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeProjectFacetsListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyProjectFacetsListeners() {
        int i = 0;
        int n = this.listeners.size();
        while (i < n) {
            ((Listener)this.listeners.get(i)).handleEvent(null);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        IStructuredSelection ss = (IStructuredSelection)this.tree.getSelection();
        Object sel = ss.getFirstElement();
        if (sel instanceof TableRowData) {
            sel = ((TableRowData)sel).getProjectFacet();
        }
        if (sel == null) {
            return new StructuredSelection(new Object[0]);
        }
        return new StructuredSelection(sel);
    }

    public void setSelection(ISelection selection) {
        ISelection ts;
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object sel = ss.getFirstElement();
        if (sel == null) {
            ts = new StructuredSelection(new Object[0]);
        } else if (sel instanceof IProjectFacet) {
            TableRowData trd = this.findTableRowData((IProjectFacet)sel);
            ts = new StructuredSelection((Object)trd);
        } else {
            ts = selection;
        }
        this.tree.setSelection(ts);
    }

    public void notifySelectionChangedListeners() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        int i = 0;
        int n = this.selectionListeners.size();
        while (i < n) {
            ISelectionChangedListener listener = (ISelectionChangedListener)this.selectionListeners.get(i);
            listener.selectionChanged(event);
            ++i;
        }
    }

    private void selectionChanged(SelectionChangedEvent event) {
        Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selection != this.oldSelection) {
            this.oldSelection = selection;
            this.refreshVersionsDropDown();
            this.notifySelectionChangedListeners();
        }
    }

    private void checkStateChanged(CheckStateChangedEvent event) {
        Object el = event.getElement();
        boolean checked = event.getChecked();
        if (el instanceof TableRowData) {
            TableRowData trd = (TableRowData)el;
            if (trd.isFixed()) {
                if (!checked) {
                    this.tree.setChecked(el, true);
                    String msg = NLS.bind((String)Resources.couldNotDeselectFixedFacetMessage, (Object)trd.getProjectFacet().getLabel());
                    MessageBox msgbox = new MessageBox(this.getShell());
                    msgbox.setText(Resources.couldNotDeselectFixedFacetTitle);
                    msgbox.setMessage(msg);
                    msgbox.open();
                }
                return;
            }
            trd.setSelected(checked);
            this.refreshCategoryState(trd);
        } else {
            ContentProvider cp = (ContentProvider)this.tree.getContentProvider();
            Object[] children = cp.getChildren(el);
            int selected = 0;
            int i = 0;
            while (i < children.length) {
                TableRowData trd = (TableRowData)children[i];
                if (!trd.isFixed()) {
                    trd.setSelected(checked);
                    this.tree.setChecked((Object)trd, checked);
                }
                if (trd.isSelected()) {
                    ++selected;
                }
                ++i;
            }
            if (selected == 0 || selected == children.length) {
                this.tree.setGrayed(el, false);
            } else {
                this.tree.setGrayChecked(el, true);
            }
        }
        this.updateValidationDisplay();
        this.model.setSelectedPreset(null);
    }

    private void updateValidationDisplay() {
        IProjectFacetVersion f;
        Set sel = this.getSelectedProjectFacets();
        HashSet old = new HashSet(this.actions);
        this.actions.clear();
        Iterator itr = this.base.iterator();
        while (itr.hasNext()) {
            f = (IProjectFacetVersion)itr.next();
            if (sel.contains(f)) continue;
            this.actions.add(this.createAction(old, IFacetedProject.Action.Type.UNINSTALL, f));
        }
        itr = sel.iterator();
        while (itr.hasNext()) {
            f = (IProjectFacetVersion)itr.next();
            if (this.base.contains(f)) continue;
            this.actions.add(this.createAction(old, IFacetedProject.Action.Type.INSTALL, f));
        }
        HashSet<IFacetedProject.Action> toadd = new HashSet<IFacetedProject.Action>();
        HashSet<IFacetedProject.Action> toremove = new HashSet<IFacetedProject.Action>();
        Iterator itr1 = this.actions.iterator();
        while (itr1.hasNext()) {
            IFacetedProject.Action action1 = (IFacetedProject.Action)itr1.next();
            Iterator itr2 = this.actions.iterator();
            while (itr2.hasNext()) {
                IFacetedProject.Action action2 = (IFacetedProject.Action)itr2.next();
                if (action1.getType() != IFacetedProject.Action.Type.UNINSTALL || action2.getType() != IFacetedProject.Action.Type.INSTALL) continue;
                IProjectFacetVersion f1 = action1.getProjectFacetVersion();
                IProjectFacetVersion f2 = action2.getProjectFacetVersion();
                if (f1.getProjectFacet() != f2.getProjectFacet()) continue;
                toremove.add(action1);
                toremove.add(action2);
                toadd.add(this.createAction(old, IFacetedProject.Action.Type.VERSION_CHANGE, f2));
            }
        }
        this.actions.removeAll(toremove);
        this.actions.addAll(toadd);
        this.problems = this.calculateProblems();
        this.problemsView.refresh();
        if (this.problems.isOK()) {
            if (this.sform2.getMaximizedControl() == null) {
                this.sform2.setMaximizedControl((Control)this.tree.getTree());
            }
        } else if (this.sform2.getMaximizedControl() != null) {
            this.sform2.setMaximizedControl(null);
        }
        this.notifyProjectFacetsListeners();
    }

    private IStatus calculateProblems() {
        IStatus st = ProjectFacetsManager.check((Set)this.base, (Set)this.actions);
        Iterator itr = this.base.iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            IProjectFacet f = fv.getProjectFacet();
            String msg = null;
            if (f.getPluginId() == null) {
                msg = NLS.bind((String)Resources.facetNotFound, (Object)f.getId());
            } else if (fv.getPluginId() == null) {
                msg = NLS.bind((String)Resources.facetVersionNotFound, (Object)f.getId(), (Object)fv.getVersionString());
            }
            if (msg == null) continue;
            Status sub = new Status(2, "org.eclipse.wst.common.project.facet.ui", 0, msg, null);
            IStatus[] existing = st.getChildren();
            IStatus[] modified = new IStatus[existing.length + 1];
            System.arraycopy(existing, 0, modified, 0, existing.length);
            modified[existing.length] = sub;
            st = new MultiStatus("org.eclipse.wst.common.project.facet.ui", 0, modified, "", null);
        }
        return st;
    }

    private void refresh() {
        Object[] checked = this.tree.getCheckedElements();
        this.tree.refresh();
        this.tree.setCheckedElements(checked);
        this.refreshPresetsCombo();
        this.refreshVersionsDropDown();
    }

    public void syncWithPresetsModel(final Combo combo) {
        final ArrayList sortedPresets = new ArrayList();
        AbstractDataModel.IDataModelListener modelToViewContentsListener = new AbstractDataModel.IDataModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent() {
                List list = sortedPresets;
                synchronized (list) {
                    sortedPresets.clear();
                    sortedPresets.addAll(FacetsSelectionPanel.this.model.getPresets());
                    Collections.sort(sortedPresets, new Comparator(this){
                        final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object p1, Object p2) {
                            if (p1 == p2) {
                                return 0;
                            }
                            String label1 = ((IPreset)p1).getLabel();
                            String label2 = ((IPreset)p2).getLabel();
                            return label1.compareTo(label2);
                        }
                    });
                    IPreset selectedPreset = FacetsSelectionPanel.this.model.getSelectedPreset();
                    combo.removeAll();
                    combo.add(Resources.customPreset);
                    if (selectedPreset == null) {
                        combo.select(0);
                    }
                    Iterator itr = sortedPresets.iterator();
                    while (itr.hasNext()) {
                        IPreset preset = (IPreset)itr.next();
                        combo.add(preset.getLabel());
                        if (preset != selectedPreset) continue;
                        combo.select(combo.getItemCount() - 1);
                    }
                }
            }
        };
        this.model.addListener(AddRemoveFacetsDataModel.EVENT_SELECTABLE_PRESETS_CHANGED, modelToViewContentsListener);
        this.model.addListener(AddRemoveFacetsDataModel.EVENT_SELECTED_PRESET_CHANGED, new AbstractDataModel.IDataModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent() {
                List list = sortedPresets;
                synchronized (list) {
                    IPreset preset = FacetsSelectionPanel.this.model.getSelectedPreset();
                    int index = preset == null ? -1 : sortedPresets.indexOf(preset);
                    combo.select(index + 1);
                    FacetsSelectionPanel.this.handlePresetSelected();
                }
            }
        });
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                List list = sortedPresets;
                synchronized (list) {
                    int selection = combo.getSelectionIndex();
                    IPreset preset = selection == 0 ? null : (IPreset)sortedPresets.get(selection - 1);
                    FacetsSelectionPanel.this.model.setSelectedPreset(preset);
                }
            }
        });
        modelToViewContentsListener.handleEvent();
    }

    private void refreshPresetsCombo() {
        HashSet<IPreset> presets = new HashSet<IPreset>();
        Iterator itr1 = ProjectFacetsManager.getPresets().iterator();
        while (itr1.hasNext()) {
            IPreset preset = (IPreset)itr1.next();
            Set facets = preset.getProjectFacets();
            boolean applicable = true;
            Iterator itr2 = facets.iterator();
            while (itr2.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr2.next();
                IProjectFacet f = fv.getProjectFacet();
                TableRowData trd = this.findTableRowData(f);
                if (trd.getVersions().contains(fv)) continue;
                applicable = false;
                break;
            }
            itr2 = this.fixed.iterator();
            while (itr2.hasNext()) {
                IProjectFacet f = (IProjectFacet)itr2.next();
                boolean found = false;
                Iterator itr3 = f.getVersions().iterator();
                while (itr3.hasNext()) {
                    if (!facets.contains(itr3.next())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                applicable = false;
                break;
            }
            if (!applicable) continue;
            presets.add(preset);
        }
        this.model.setPresets(presets);
        this.refreshPresetsButtons();
    }

    private void refreshPresetsButtons() {
        IPreset preset = this.model.getSelectedPreset();
        if (preset == null) {
            this.savePresetButton.setEnabled(true);
            this.deletePresetButton.setEnabled(false);
        } else {
            this.savePresetButton.setEnabled(false);
            this.deletePresetButton.setEnabled(preset.isUserDefined());
        }
    }

    private void refreshCategoryState(TableRowData trd) {
        ICategory category = trd.getProjectFacet().getCategory();
        if (category != null) {
            int selected = 0;
            Iterator itr = category.getProjectFacets().iterator();
            while (itr.hasNext()) {
                TableRowData ctrd = this.findTableRowData((IProjectFacet)itr.next());
                if (!ctrd.isSelected()) continue;
                ++selected;
            }
            if (selected == 0) {
                this.tree.setChecked((Object)category, false);
                this.tree.setGrayed((Object)category, false);
            } else if (selected == category.getProjectFacets().size()) {
                this.tree.setChecked((Object)category, true);
                this.tree.setGrayed((Object)category, false);
            } else {
                this.tree.setGrayChecked((Object)category, true);
            }
        }
    }

    private void refreshVersionsDropDown() {
        TableRowData trd = this.getSelectedTableRowData();
        if (trd == null) {
            return;
        }
        List versions = trd.getVersions();
        String[] verstrs = new String[versions.size()];
        int i = 0;
        int n = versions.size();
        while (i < n) {
            IProjectFacetVersion fv = (IProjectFacetVersion)versions.get(i);
            verstrs[i] = fv.getVersionString();
            ++i;
        }
        this.ceditor.setItems(verstrs);
        i = 0;
        n = versions.size();
        while (i < n) {
            if (versions.get(i) == trd.getCurrentVersion()) {
                this.ceditor.setValue((Object)new Integer(i));
                break;
            }
            ++i;
        }
    }

    private TableRowData getSelectedTableRowData() {
        Object obj;
        IStructuredSelection ssel = (IStructuredSelection)this.tree.getSelection();
        if (ssel != null && !ssel.isEmpty() && (obj = ssel.getFirstElement()) instanceof TableRowData) {
            return (TableRowData)obj;
        }
        return null;
    }

    private boolean isFilteredOut(IProjectFacetVersion fv) {
        Iterator itr = this.filters.iterator();
        while (itr.hasNext()) {
            if (((IFilter)itr.next()).check(fv)) continue;
            return true;
        }
        return false;
    }

    private TableRowData findTableRowData(IProjectFacet f) {
        return this.findTableRowData(f, false);
    }

    private TableRowData findTableRowData(IProjectFacet f, boolean createIfNecessary) {
        int i = 0;
        int n = this.data.size();
        while (i < n) {
            TableRowData trd = (TableRowData)this.data.get(i);
            if (trd.getProjectFacet() == f) {
                return trd;
            }
            ++i;
        }
        if (createIfNecessary) {
            try {
                TableRowData trd = new TableRowData(f);
                this.data.add(trd);
                return trd;
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        throw new IllegalStateException();
    }

    private void handleMouseDownEvent(Event event) {
        ArrayList items = this.getAllTreeItems();
        TreeItem onItem = null;
        int i = 0;
        int n = items.size();
        while (i < n) {
            TreeItem item = (TreeItem)items.get(i);
            if (item.getBounds(0).contains(event.x, event.y)) {
                onItem = item;
                break;
            }
            if (item.getBounds(1).contains(event.x, event.y)) {
                this.tree.getTree().setSelection(new TreeItem[]{item});
                this.tree.editElement(item.getData(), 1);
                break;
            }
            ++i;
        }
        if (onItem != null && onItem.getData() instanceof TableRowData) {
            TableRowData trd = (TableRowData)onItem.getData();
            IProjectFacetVersion fv = trd.getCurrentVersion();
            IConstraint c = fv.getConstraint();
            if (c.getType() == IConstraint.Type.AND && c.getOperands().size() == 0) {
                this.popupMenuConstraints.setEnabled(false);
            } else {
                this.popupMenuConstraints.setEnabled(true);
            }
            this.tree.getTree().setMenu(this.popupMenu);
        } else {
            this.tree.getTree().setMenu(null);
        }
    }

    private void handleShowConstraints() {
        TreeItem[] items = this.tree.getTree().getSelection();
        if (items.length != 1) {
            throw new IllegalStateException();
        }
        TreeItem item = items[0];
        TableRowData trd = (TableRowData)item.getData();
        IProjectFacetVersion fv = trd.getCurrentVersion();
        Rectangle bounds = item.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = this.tree.getTree().toDisplay(location);
        ConstraintDisplayDialog dialog = new ConstraintDisplayDialog(this.getShell(), location, fv.getConstraint());
        dialog.open();
    }

    private void handlePresetSelected() {
        IPreset preset = this.model.getSelectedPreset();
        if (preset != null) {
            HashSet<TableRowData> selected = new HashSet<TableRowData>();
            Iterator itr = preset.getProjectFacets().iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                TableRowData trd = this.findTableRowData(fv.getProjectFacet());
                if (!trd.isSelected()) {
                    this.tree.setChecked((Object)trd, true);
                    trd.setSelected(true);
                    this.refreshCategoryState(trd);
                }
                if (trd.getCurrentVersion() != fv) {
                    trd.setCurrentVersion(fv);
                    this.tree.update((Object)trd, null);
                }
                selected.add(trd);
            }
            itr = this.data.iterator();
            while (itr.hasNext()) {
                TableRowData trd = (TableRowData)itr.next();
                if (selected.contains(trd)) continue;
                this.tree.setChecked((Object)trd, false);
                trd.setSelected(false);
                this.refreshCategoryState(trd);
            }
            this.updateValidationDisplay();
        }
        this.refreshPresetsButtons();
    }

    private void handleSavePreset() {
        Set facets = this.getSelectedProjectFacets();
        IPreset preset = SavePresetDialog.showDialog(this.getShell(), facets);
        if (preset != null) {
            this.refreshPresetsCombo();
            this.model.setSelectedPreset(preset);
        }
    }

    private void handleDeletePreset() {
        IPreset preset = this.model.getSelectedPreset();
        ProjectFacetsManager.deletePreset((IPreset)preset);
        this.refreshPresetsCombo();
    }

    private void handleShowHideRuntimes() {
        if (this.sform1.getMaximizedControl() == null) {
            this.sform1.setMaximizedControl((Control)this.sform2);
            this.showHideRuntimesButton.setText(Resources.showRuntimes);
        } else {
            this.sform1.setMaximizedControl(null);
            this.showHideRuntimesButton.setText(Resources.hideRuntimes);
        }
    }

    private ArrayList getAllTreeItems() {
        ArrayList result = new ArrayList();
        FacetsSelectionPanel.getAllTreeItems(this.tree.getTree().getItems(), result);
        return result;
    }

    private static void getAllTreeItems(TreeItem[] items, ArrayList result) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            result.add(item);
            FacetsSelectionPanel.getAllTreeItems(item.getItems(), result);
            ++i;
        }
    }

    private static final GridData gdfill() {
        return new GridData(4, 4, true, true);
    }

    private static final GridData gdhfill() {
        return new GridData(768);
    }

    private static final GridData whint(GridData gd, int width) {
        gd.widthHint = width;
        return gd;
    }

    private static final GridData hhint(GridData gd, int height) {
        gd.heightHint = height;
        return gd;
    }

    private static final GridData hspan(GridData gd, int span) {
        gd.horizontalSpan = span;
        return gd;
    }

    private static final GridData halign(GridData gd, int alignment) {
        gd.horizontalAlignment = alignment;
        return gd;
    }

    private static final int getPreferredWidth(Control control) {
        return control.computeSize((int)-1, (int)-1).x;
    }

    public static interface IFilter {
        public boolean check(IProjectFacetVersion var1);
    }

    private final class TableRowData {
        private IProjectFacet f;
        private List versions;
        private IProjectFacetVersion current;
        private boolean isSelected;
        private boolean isFixed;

        public TableRowData(IProjectFacet f) throws CoreException {
            this.f = f;
            this.versions = f.getSortedVersions(false);
            this.current = f.getDefaultVersion();
            this.isSelected = false;
            this.isFixed = false;
        }

        public IProjectFacet getProjectFacet() {
            return this.f;
        }

        public List getVersions() {
            ArrayList<IProjectFacetVersion> list = new ArrayList<IProjectFacetVersion>();
            Iterator itr = this.versions.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                if (FacetsSelectionPanel.this.isFilteredOut(fv)) continue;
                list.add(fv);
            }
            return list;
        }

        public void addUnknownVersion(IProjectFacetVersion fv) {
            try {
                Comparator c = this.f.getVersionComparator();
                boolean added = false;
                int i = 0;
                int n = this.versions.size();
                while (i < n) {
                    IProjectFacetVersion x = (IProjectFacetVersion)this.versions.get(i);
                    if (c.compare(x.getVersionString(), fv.getVersionString()) < 0) {
                        this.versions.add(i, fv);
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (!added) {
                    this.versions.add(fv);
                }
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }

        public IProjectFacetVersion getCurrentVersion() {
            if (FacetsSelectionPanel.this.isFilteredOut(this.current)) {
                this.current = (IProjectFacetVersion)this.getVersions().get(0);
            }
            return this.current;
        }

        public void setCurrentVersion(IProjectFacetVersion fv) {
            this.current = fv;
        }

        public boolean isSelected() {
            if (this.getVersions().isEmpty()) {
                this.isSelected = false;
            }
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public boolean isFixed() {
            return this.isFixed;
        }

        public void setFixed(boolean isFixed) {
            this.isFixed = isFixed;
        }

        public boolean isVisible() {
            return !this.getVersions().isEmpty();
        }

        public String toString() {
            return this.current.toString();
        }
    }

    private final class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object element) {
            ArrayList<Object> list = new ArrayList<Object>();
            Set categories = ProjectFacetsManager.getCategories();
            Iterator itr1 = categories.iterator();
            while (itr1.hasNext()) {
                boolean visible = false;
                ICategory cat = (ICategory)itr1.next();
                Iterator itr2 = cat.getProjectFacets().iterator();
                while (itr2.hasNext()) {
                    IProjectFacet f = (IProjectFacet)itr2.next();
                    if (!FacetsSelectionPanel.this.findTableRowData(f).isVisible()) continue;
                    visible = true;
                    break;
                }
                if (!visible) continue;
                list.add(cat);
            }
            int i = 0;
            while (i < FacetsSelectionPanel.this.data.size()) {
                TableRowData trd = (TableRowData)FacetsSelectionPanel.this.data.get(i);
                if (trd.getProjectFacet().getCategory() == null && trd.isVisible()) {
                    list.add(trd);
                }
                ++i;
            }
            return list.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ICategory) {
                ICategory category = (ICategory)parent;
                ArrayList<TableRowData> trds = new ArrayList<TableRowData>();
                Iterator itr = category.getProjectFacets().iterator();
                while (itr.hasNext()) {
                    TableRowData trd = FacetsSelectionPanel.this.findTableRowData((IProjectFacet)itr.next());
                    if (!trd.isVisible()) continue;
                    trds.add(trd);
                }
                return trds.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TableRowData) {
                IProjectFacet f = ((TableRowData)element).getProjectFacet();
                return f.getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ICategory && !((ICategory)element).getProjectFacets().isEmpty();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class LabelProvider
    implements ITableLabelProvider {
        private ImageRegistry imageRegistry = new ImageRegistry();
        static /* synthetic */ Class class$0;

        private LabelProvider() {
        }

        public String getColumnText(Object element, int column) {
            if (element instanceof ICategory) {
                if (column == 0) {
                    return ((ICategory)element).getLabel();
                }
                return "";
            }
            TableRowData trd = (TableRowData)element;
            switch (column) {
                case 0: {
                    return trd.getProjectFacet().getLabel();
                }
                case 1: {
                    String vstr = trd.getCurrentVersion().getVersionString();
                    return trd.getVersions().size() == 1 ? vstr : String.valueOf(vstr) + " ...";
                }
            }
            throw new IllegalStateException();
        }

        public Image getColumnImage(Object element, int column) {
            IAdaptable obj;
            String id;
            if (column != 0) {
                return null;
            }
            boolean isFixed = false;
            if (element instanceof TableRowData) {
                TableRowData trd = (TableRowData)element;
                IProjectFacet f = trd.getProjectFacet();
                isFixed = trd.isFixed;
                id = String.valueOf(isFixed ? "F:" : "f:") + f.getId();
                obj = f;
            } else {
                id = "c:" + ((ICategory)element).getId();
                obj = (IAdaptable)element;
            }
            Image image = this.imageRegistry.get(id);
            if (image == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.IDecorationsProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IDecorationsProvider decprov = (IDecorationsProvider)obj.getAdapter((Class)clazz);
                Object imgdesc = decprov.getIcon();
                if (isFixed) {
                    imgdesc = new FixedFacetImageDescriptor((ImageDescriptor)imgdesc);
                }
                this.imageRegistry.put(id, imgdesc);
                image = this.imageRegistry.get(id);
            }
            return image;
        }

        public void dispose() {
            this.imageRegistry.dispose();
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class FixedFacetImageDescriptor
    extends CompositeImageDescriptor {
        private static final String OVERLAY_IMG_LOCATION = "images/lock.gif";
        private static final ImageData OVERLAY = FacetUiPlugin.getImageDescriptor("images/lock.gif").getImageData();
        private final ImageData base;
        private final Point size;

        public FixedFacetImageDescriptor(ImageDescriptor base) {
            this.base = base.getImageData();
            this.size = new Point(this.base.width, this.base.height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            this.drawImage(OVERLAY, 0, height - FixedFacetImageDescriptor.OVERLAY.height);
        }

        protected Point getSize() {
            return this.size;
        }
    }

    private final class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public Object getValue(Object element, String property) {
            TableRowData trd = (TableRowData)element;
            if (property.equals(FacetsSelectionPanel.VERSION_COLUMN)) {
                List versions = trd.getVersions();
                int i = 0;
                int n = versions.size();
                while (i < n) {
                    if (versions.get(i) == trd.getCurrentVersion()) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return new IllegalStateException();
            }
            throw new IllegalStateException();
        }

        public boolean canModify(Object element, String property) {
            return property.equals(FacetsSelectionPanel.VERSION_COLUMN) && element instanceof TableRowData && ((TableRowData)element).getVersions().size() > 1;
        }

        public void modify(Object element, String property, Object value) {
            TreeItem item = (TreeItem)element;
            TableRowData trd = (TableRowData)item.getData();
            if (property.equals(FacetsSelectionPanel.VERSION_COLUMN)) {
                int index = (Integer)value;
                if (index != -1) {
                    IProjectFacetVersion fv = (IProjectFacetVersion)trd.getVersions().get(index);
                    if (trd.getCurrentVersion() != fv) {
                        trd.setCurrentVersion(fv);
                        FacetsSelectionPanel.this.tree.update((Object)trd, null);
                        if (trd.isSelected()) {
                            FacetsSelectionPanel.this.model.setSelectedPreset(null);
                        }
                        FacetsSelectionPanel.this.updateValidationDisplay();
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private static final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            return Sorter.getLabel(a).compareToIgnoreCase(Sorter.getLabel(b));
        }

        private static String getLabel(Object obj) {
            if (obj instanceof TableRowData) {
                return ((TableRowData)obj).getProjectFacet().getLabel();
            }
            return ((ICategory)obj).getLabel();
        }
    }

    private final class ProblemsContentProvider
    implements IStructuredContentProvider {
        private ProblemsContentProvider() {
        }

        public Object[] getElements(Object element) {
            return FacetsSelectionPanel.this.problems.getChildren();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class ProblemsLabelProvider
    implements ITableLabelProvider {
        private Image errorImage;
        private Image warningImage;

        public ProblemsLabelProvider() {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.project.facet.ui");
            URL url = bundle.getEntry("images/error.gif");
            this.errorImage = ImageDescriptor.createFromURL((URL)url).createImage();
            url = bundle.getEntry("images/warning.gif");
            this.warningImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }

        public String getColumnText(Object element, int column) {
            return ((IStatus)element).getMessage();
        }

        public Image getColumnImage(Object element, int column) {
            IStatus st = (IStatus)element;
            if (st.getSeverity() == 4) {
                return this.errorImage;
            }
            return this.warningImage;
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void dispose() {
            this.errorImage.dispose();
            this.warningImage.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class Resources
    extends NLS {
        public static String presetsLabel;
        public static String customPreset;
        public static String saveButtonLabel;
        public static String deleteButtonLabel;
        public static String savePresetDialogTitle;
        public static String savePresetDialogMessage;
        public static String facetColumnLabel;
        public static String versionColumnLabel;
        public static String showConstraints;
        public static String showRuntimes;
        public static String hideRuntimes;
        public static String couldNotSelectPreset;
        public static String couldNotDeselectFixedFacetTitle;
        public static String couldNotDeselectFixedFacetMessage;
        public static String facetNotFound;
        public static String facetVersionNotFound;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }

        public static String bind(String msg, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)msg, (Object[])new Object[]{arg1, arg2, arg3});
        }
    }
}

