/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.refactoring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.java.search.JavaSearchDocumentDelegate;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.encoding.CodedStreamCreator;

public class BasicRefactorSearchRequestor
extends SearchRequestor {
    IJavaElement fElement = null;
    private String fNewName = "";
    private HashMap fSearchDocPath2JavaEditMap = null;

    public BasicRefactorSearchRequestor(IJavaElement element, String newName) {
        this.fNewName = newName;
        this.fElement = element;
        this.fSearchDocPath2JavaEditMap = new HashMap();
    }

    public IJavaElement getElement() {
        return this.fElement;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void acceptSearchMatch(SearchMatch javaMatch) throws CoreException {
        String matchDocumentPath = javaMatch.getResource().getFullPath().toString();
        SearchDocument searchDoc = JSPSearchSupport.getInstance().getSearchDocument(matchDocumentPath);
        if (searchDoc != null && searchDoc instanceof JavaSearchDocumentDelegate) {
            String renameText = this.getRenameText((JavaSearchDocumentDelegate)searchDoc, javaMatch);
            this.addJavaEdit(searchDoc.getPath(), new ReplaceEdit(javaMatch.getOffset(), javaMatch.getLength(), renameText));
        }
    }

    protected String getRenameText(JavaSearchDocumentDelegate searchDoc, SearchMatch javaMatch) {
        return this.getNewName();
    }

    private void addJavaEdit(String searchDocPath, ReplaceEdit javaEdit) {
        Object o = this.fSearchDocPath2JavaEditMap.get(searchDocPath);
        if (o != null) {
            MultiTextEdit multi = (MultiTextEdit)o;
            multi.addChild((TextEdit)javaEdit);
        } else {
            MultiTextEdit multi = new MultiTextEdit();
            multi.addChild((TextEdit)javaEdit);
            this.fSearchDocPath2JavaEditMap.put(searchDocPath, multi);
        }
    }

    public Change[] getChanges() {
        JSPSearchSupport support = JSPSearchSupport.getInstance();
        ArrayList<Change> changes = new ArrayList<Change>();
        Iterator keys = this.fSearchDocPath2JavaEditMap.keySet().iterator();
        String searchDocPath = null;
        SearchDocument delegate = null;
        while (keys.hasNext()) {
            searchDocPath = (String)keys.next();
            MultiTextEdit javaEdit = (MultiTextEdit)this.fSearchDocPath2JavaEditMap.get(searchDocPath);
            delegate = support.getSearchDocument(searchDocPath);
            if (delegate == null || !(delegate instanceof JavaSearchDocumentDelegate)) continue;
            JavaSearchDocumentDelegate javaDelegate = (JavaSearchDocumentDelegate)delegate;
            changes.add(this.createChange(javaDelegate, javaDelegate.getJspTranslation().getJspEdit((TextEdit)javaEdit)));
        }
        return changes.toArray(new Change[changes.size()]);
    }

    private Change createChange(JavaSearchDocumentDelegate searchDoc, TextEdit edit) {
        IDocument doc = searchDoc.getJspTranslation().getJspDocument();
        String file = searchDoc.getFile().getName();
        String description = this.getDescription();
        try {
            String lineNumber = Integer.toString(doc.getLineOfOffset(edit.getOffset()) + 1);
            description = String.valueOf(description) + " " + NLS.bind((String)JSPUIMessages.BasicRefactorSearchRequestor_1, (Object[])new String[]{file, lineNumber});
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return new RenameChange(searchDoc.getFile(), doc, edit, description);
    }

    protected boolean isFullyQualified(String matchText) {
        if (this.getElement() instanceof IType) {
            String pkg = ((IType)this.getElement()).getPackageFragment().getElementName();
            return matchText.startsWith(pkg);
        }
        return false;
    }

    protected String getDescription() {
        return "";
    }

    private class SaveJspFileOp
    extends WorkspaceModifyOperation {
        private IDocument fJSPDoc = null;
        private IFile fJSPFile = null;

        public SaveJspFileOp(IFile jspFile, IDocument jspDoc) {
            this.fJSPDoc = jspDoc;
            this.fJSPFile = jspFile;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            CodedStreamCreator codedStreamCreator = new CodedStreamCreator();
            DocumentReader reader = new DocumentReader(this.fJSPDoc);
            codedStreamCreator.set(this.fJSPFile, (Reader)reader);
            ByteArrayOutputStream codedByteStream = null;
            ByteArrayInputStream codedStream = null;
            try {
                block12: {
                    try {
                        codedByteStream = codedStreamCreator.getCodedByteArrayOutputStream();
                        codedStream = new ByteArrayInputStream(codedByteStream.toByteArray());
                        if (this.fJSPFile.exists()) {
                            this.fJSPFile.setContents((InputStream)codedStream, true, true, null);
                            break block12;
                        }
                        this.fJSPFile.create((InputStream)codedStream, false, null);
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                    }
                }
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (codedByteStream != null) {
                        codedByteStream.close();
                    }
                    if (codedStream == null) throw throwable;
                    ((InputStream)codedStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {
                return;
            }
            if (codedByteStream != null) {
                codedByteStream.close();
            }
            if (codedStream == null) return;
            ((InputStream)codedStream).close();
        }
    }

    private class RenameChange
    extends DocumentChange {
        private TextEdit fEdit = null;
        private IFile fJSPFile = null;
        private IDocument fJSPDoc = null;
        private String fDescription = JSPUIMessages.BasicRefactorSearchRequestor_0;
        static /* synthetic */ Class class$0;

        public RenameChange(IFile jspFile, IDocument jspDoc, TextEdit edit, String description) {
            super(JSPUIMessages.BasicRefactorSearchRequestor_6, jspDoc);
            this.fEdit = edit;
            this.fJSPFile = jspFile;
            this.fJSPDoc = jspDoc;
            this.fDescription = description;
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
            return new RefactoringStatus();
        }

        public IDocument getPreviewDocument(IProgressMonitor pm) throws CoreException {
            Document copyDoc = new Document(this.fJSPDoc.get());
            try {
                this.fEdit.apply((IDocument)copyDoc);
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (BadLocationException badLocationException) {}
            return copyDoc;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            RenameChange undoChange = null;
            try {
                if (!this.isOpenInEditor(this.fJSPDoc)) {
                    undoChange = new RenameChange(this.fJSPFile, this.fJSPDoc, (TextEdit)this.fEdit.apply(this.fJSPDoc), this.fDescription);
                    this.saveFile(this.fJSPFile, this.fJSPDoc);
                } else {
                    undoChange = new RenameChange(this.fJSPFile, this.fJSPDoc, (TextEdit)this.fEdit.apply(this.fJSPDoc), this.fDescription);
                }
            }
            catch (MalformedTreeException e) {
                Logger.logException(e);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
            return undoChange;
        }

        private void saveFile(IFile jspFile, IDocument jspDoc) {
            SaveJspFileOp op = new SaveJspFileOp(jspFile, jspDoc);
            try {
                op.run(JSPSearchSupport.getInstance().getProgressMonitor());
            }
            catch (InvocationTargetException e) {
                Logger.logException(e);
            }
            catch (InterruptedException e) {
                Logger.logException(e);
            }
        }

        private boolean isOpenInEditor(IDocument jspDoc) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            IWorkbenchWindow w = null;
            int i = 0;
            while (i < windows.length) {
                w = windows[i];
                IWorkbenchPage page = w.getActivePage();
                if (page != null) {
                    IEditorReference[] references = page.getEditorReferences();
                    IEditorPart editor = null;
                    Object o = null;
                    IDocument doc = null;
                    int j = 0;
                    while (j < references.length) {
                        editor = references[j].getEditor(true);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((o = editor.getAdapter((Class)clazz)) != null && o instanceof ITextEditor && (doc = ((ITextEditor)o).getDocumentProvider().getDocument((Object)editor.getEditorInput())) != null && doc.equals(jspDoc)) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return false;
        }

        public String getName() {
            return this.fDescription;
        }

        public Object getModifiedElement() {
            return BasicRefactorSearchRequestor.this.getElement();
        }
    }
}

