/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emfworkbench.edit.AdapterFactoryDescriptor;

public class AdapterFactoryRegistry
extends RegistryReader {
    public static final String ADAPTER_FACTORY = "adapterFactory";
    public static final String PACKAGE_URI = "packageURI";
    public static final String CLASS_NAME = "className";
    public static final String VIEW = "view";
    public static final String ID = "id";
    private Map descriptorMap = null;
    private static AdapterFactoryRegistry instance;

    private AdapterFactoryRegistry() {
        super("org.eclipse.wst.common.emfworkbench.integration", ADAPTER_FACTORY);
    }

    public List getDescriptors(EPackage pkg, String viewID) {
        Collection all = this.getDescriptors(pkg);
        if (all == null) {
            return null;
        }
        Iterator iter = all.iterator();
        AdapterFactoryDescriptor desc = null;
        ArrayList<AdapterFactoryDescriptor> result = new ArrayList<AdapterFactoryDescriptor>(all.size());
        while (iter.hasNext()) {
            desc = (AdapterFactoryDescriptor)iter.next();
            if (!desc.appliesTo(viewID)) continue;
            result.add(desc);
        }
        return result;
    }

    public Collection getDescriptors(EPackage registeredPackage) {
        return (Collection)this.getDescriptorMap().get(registeredPackage.getNsURI());
    }

    private Map getDescriptorMap() {
        if (this.descriptorMap == null) {
            this.descriptorMap = new HashMap();
        }
        return this.descriptorMap;
    }

    public boolean readElement(IConfigurationElement element) {
        try {
            if (element.getName().equals(ADAPTER_FACTORY)) {
                AdapterFactoryDescriptor descriptor = new AdapterFactoryDescriptor(element);
                this.mapDescriptor(descriptor);
                return true;
            }
        }
        catch (RuntimeException re) {
            Logger.getLogger().logError((Throwable)re);
        }
        return false;
    }

    private void mapDescriptor(AdapterFactoryDescriptor descriptor) {
        String uri = descriptor.getPackageURI();
        TreeSet<AdapterFactoryDescriptor> descriptors = (TreeSet<AdapterFactoryDescriptor>)this.getDescriptorMap().get(uri);
        if (descriptors == null) {
            descriptors = new TreeSet<AdapterFactoryDescriptor>();
            this.getDescriptorMap().put(uri, descriptors);
        }
        descriptors.add(descriptor);
    }

    public static AdapterFactoryRegistry instance() {
        if (instance == null) {
            instance = new AdapterFactoryRegistry();
            instance.readRegistry();
        }
        return instance;
    }
}

