/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMWriter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class TreeContentHelper {
    public static final int HIDE_WHITE_SPACE_TEXT_NODES = 8;
    public static final int COMBINE_ADJACENT_TEXT_AND_ENTITY_REFERENCES = 16;
    public static final int HIDE_ELEMENT_CHILD_TEXT_NODES = 32;
    protected int style = 56;

    public boolean hasStyleFlag(int flag) {
        return (this.style & flag) != 0;
    }

    public Object[] getChildren(Object element) {
        Object[] result = null;
        if (element instanceof Node) {
            Node node = (Node)element;
            ArrayList<Node> list = new ArrayList<Node>();
            boolean textContentOnly = true;
            NamedNodeMap map = node.getAttributes();
            if (map != null) {
                int length = map.getLength();
                int i = 0;
                while (i < length) {
                    list.add(map.item(i));
                    textContentOnly = false;
                    ++i;
                }
            }
            Node prevIncludedNode = null;
            Node childNode = node.getFirstChild();
            while (childNode != null) {
                short childNodeType = childNode.getNodeType();
                boolean includeNode = true;
                if (includeNode && this.hasStyleFlag(8) && this.isIgnorableText(childNode)) {
                    includeNode = false;
                }
                if (includeNode && this.hasStyleFlag(16) && this.isTextOrEntityReferenceNode(childNode) && prevIncludedNode != null && this.isTextOrEntityReferenceNode(prevIncludedNode)) {
                    includeNode = false;
                }
                if (this.hasStyleFlag(32) && childNodeType != 3 && childNodeType != 5) {
                    textContentOnly = false;
                }
                if (includeNode) {
                    list.add(childNode);
                    prevIncludedNode = childNode;
                }
                childNode = childNode.getNextSibling();
            }
            result = this.hasStyleFlag(32) && textContentOnly ? new Object[]{} : list.toArray();
        }
        return result;
    }

    protected boolean isTextOrEntityReferenceNode(Node node) {
        return node.getNodeType() == 3 || node.getNodeType() == 5;
    }

    public boolean isIgnorableText(Node node) {
        boolean result = false;
        if (node.getNodeType() == 3) {
            String data = ((Text)node).getData();
            result = data == null || data.trim().length() == 0;
        }
        return result;
    }

    public boolean isCombinedTextNode(Node node) {
        boolean result = false;
        if (node.getNodeType() == 3) {
            Node nextNode = node.getNextSibling();
            if (nextNode != null && nextNode.getNodeType() == 5) {
                result = true;
            }
        } else if (node.getNodeType() == 5) {
            result = true;
        }
        return result;
    }

    public List getCombinedTextNodeList(Node theNode) {
        Vector<Node> list = new Vector<Node>();
        boolean prevIsEntity = false;
        Node node = theNode;
        while (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 5) {
                prevIsEntity = true;
                list.add(node);
            } else {
                if (nodeType != 3 || !prevIsEntity && node != theNode) break;
                prevIsEntity = false;
                list.add(node);
            }
            node = node.getNextSibling();
        }
        return list;
    }

    public String getElementTextValue(Element element) {
        List list = this._getElementTextContent(element);
        return list != null ? this.getValueForTextContent(list) : null;
    }

    public void setElementTextValue(Element element, String value) {
        this.setElementNodeValue(element, value);
    }

    private List _getElementTextContent(Element element) {
        Vector<Node> result = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 5) {
                if (result == null) {
                    result = new Vector<Node>();
                }
            } else {
                result = null;
                break;
            }
            result.add(node);
            node = node.getNextSibling();
        }
        return result;
    }

    public List getElementTextContent(Element element) {
        List result = null;
        if (!element.hasAttributes()) {
            result = this._getElementTextContent(element);
        }
        return result;
    }

    public String getNodeValue(Node node) {
        String result = null;
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                result = ((Attr)node).getValue();
                break;
            }
            case 4: 
            case 8: {
                result = ((CharacterData)node).getData();
                break;
            }
            case 10: {
                result = this.getDocumentTypeValue((DocumentType)node);
                break;
            }
            case 1: {
                result = this.getElementNodeValue((Element)node);
                break;
            }
            case 3: 
            case 5: {
                result = this.getTextNodeValue(node);
                break;
            }
            case 7: {
                result = ((ProcessingInstruction)node).getData();
            }
        }
        return result;
    }

    private boolean validateEdit(IStructuredModel model, Shell context) {
        if (model != null && model.getBaseLocation() != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(model.getBaseLocation()));
            if (!file.isAccessible()) {
                return true;
            }
            return ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)context).isOK();
        }
        return false;
    }

    public void setNodeValue(Node node, String value) {
        this.setNodeValue(node, value, null);
    }

    public void setNodeValue(Node node, String value, Shell context) {
        block10: {
            if (node instanceof IDOMNode && !this.validateEdit((IStructuredModel)((IDOMNode)node).getModel(), context)) {
                return;
            }
            short nodeType = node.getNodeType();
            try {
                switch (nodeType) {
                    case 2: {
                        ((Attr)node).setValue(value);
                        break;
                    }
                    case 4: 
                    case 8: {
                        ((CharacterData)node).setData(value);
                        break;
                    }
                    case 1: {
                        this.setElementNodeValue((Element)node, value);
                        break;
                    }
                    case 3: 
                    case 5: {
                        this.setTextNodeValue(node, value);
                        break;
                    }
                    case 7: {
                        ((ProcessingInstruction)node).setData(value);
                    }
                }
            }
            catch (DOMException dOMException) {
                Display d = this.getDisplay();
                if (d == null) break block10;
                d.beep();
            }
        }
    }

    private Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    protected String getDocumentTypeValue(DocumentType documentType) {
        return DOMWriter.getDocumentTypeData((DocumentType)documentType);
    }

    protected String getElementNodeValue(Element element) {
        String result = null;
        List list = this.getElementTextContent(element);
        if (list != null) {
            result = this.getValueForTextContent(list);
        }
        return result;
    }

    protected void setElementNodeValue(Element element, String value) {
        List list = this.getElementTextContent(element);
        if (list != null) {
            this.setValueForTextContent(list, value);
        } else {
            Document document = element.getOwnerDocument();
            Text text = document.createTextNode(value);
            element.appendChild(text);
        }
    }

    protected String getTextNodeValue(Node node) {
        String result = null;
        Vector<Node> list = null;
        if (this.isCombinedTextNode(node)) {
            list = this.getCombinedTextNodeList(node);
        } else {
            list = new Vector<Node>();
            list.add(node);
        }
        result = this.getValueForTextContent(list);
        return result;
    }

    protected void setTextNodeValue(Node node, String value) {
        Vector<Node> list = null;
        if (this.isCombinedTextNode(node)) {
            list = this.getCombinedTextNodeList(node);
        } else {
            list = new Vector<Node>();
            list.add(node);
        }
        this.setValueForTextContent(list, value);
    }

    public Text getEffectiveTextNodeForCombinedNodeList(List list) {
        Text result = null;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 3) continue;
            result = (Text)node;
            break;
        }
        return result;
    }

    protected String getValueForTextContent(List list) {
        String result = null;
        if (list.size() > 0) {
            IDOMNode first = (IDOMNode)list.get(0);
            IDOMNode last = (IDOMNode)list.get(list.size() - 1);
            IDOMModel model = first.getModel();
            int start = first.getStartOffset();
            int end = last.getEndOffset();
            try {
                result = model.getStructuredDocument().get(start, end - start);
            }
            catch (Exception exception) {}
        }
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    protected void setValueForTextContent(List list, String value) {
        if (list.size() > 0) {
            IDOMNode first = (IDOMNode)list.get(0);
            IDOMNode last = (IDOMNode)list.get(list.size() - 1);
            int start = first.getStartOffset();
            int end = last.getEndOffset();
            first.getModel().getStructuredDocument().replaceText((Object)this, start, end - start, value);
        }
    }

    public boolean isEditable(Node node) {
        short nodeType = node.getNodeType();
        boolean result = false;
        switch (nodeType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                result = true;
                break;
            }
            case 1: {
                result = this.getElementTextContent((Element)node) != null || node.getChildNodes().getLength() == 0;
            }
        }
        return result;
    }
}

