/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.core.common;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.wst.rdb.data.internal.core.DataCorePlugin;
import org.eclipse.wst.rdb.data.internal.core.common.IColumnDataAccessor;
import org.eclipse.wst.rdb.data.internal.core.common.data.DataDeserializer;
import org.eclipse.wst.rdb.data.internal.core.common.data.DataSerializer;
import org.eclipse.wst.rdb.data.internal.core.common.data.PreparedStatementWriter;
import org.eclipse.wst.rdb.data.internal.core.common.data.ResultSetReader;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class DefaultColumnDataAccessor
implements IColumnDataAccessor {
    protected Column sqlCol;
    protected int lobLimit = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");

    public DefaultColumnDataAccessor() {
        if (this.lobLimit <= 0) {
            this.lobLimit = -1;
        }
    }

    public void initialize(Column sqlCol) {
        this.sqlCol = sqlCol;
    }

    public String getSelectExpr() {
        String colName = this.sqlCol.getName();
        Connection conn = ((ICatalogObject)this.sqlCol.getTable()).getConnection();
        colName = DataCorePlugin.quoteIdentifier(conn, colName);
        return colName;
    }

    public Object read(ResultSet rs, int col, int type, boolean snippet) throws SQLException, IOException {
        return ResultSetReader.read(rs, col, snippet ? this.lobLimit : -1);
    }

    public boolean isSnippet(Object val, int type) {
        if (val == null) {
            return false;
        }
        if (type == 2004) {
            return ((byte[])val).length == this.lobLimit;
        }
        if (type == 2005) {
            return ((String)val).length() == this.lobLimit;
        }
        return false;
    }

    public String getValuesExpr(Object val) {
        return "?";
    }

    public String[] writeValuesExprArgs(PreparedStatement pst, int start, Object val, int type) throws SQLException, IOException {
        PreparedStatementWriter.write(pst, start, type, val);
        return new String[]{this.argString(this.getLabel(val, type), type)};
    }

    public String getSetAss(Object val) {
        return String.valueOf(this.getQuotedColumnName()) + "=?";
    }

    public String[] writeSetAssArgs(PreparedStatement pst, int start, Object val, int type) throws SQLException, IOException {
        PreparedStatementWriter.write(pst, start, type, val);
        return new String[]{this.argString(this.getLabel(val, type), type)};
    }

    public String getWhereCond(Object val) {
        String s = this.getQuotedColumnName();
        s = val == null ? String.valueOf(s) + " is null" : String.valueOf(s) + "=?";
        return s;
    }

    public String[] writeWhereCondArgs(PreparedStatement pst, int start, Object val, int type) throws SQLException, IOException {
        if (val != null) {
            PreparedStatementWriter.write(pst, start, type, val);
            return new String[]{this.argString(this.getLabel(val, type), type)};
        }
        return new String[0];
    }

    protected String getQuotedColumnName() {
        return DataCorePlugin.quoteIdentifier(this.sqlCol.getTable().getSchema().getDatabase(), this.sqlCol.getName());
    }

    protected String argString(String arg, int type) {
        String s = arg;
        if (s == null) {
            return "null";
        }
        if (s.length() > 20) {
            s = String.valueOf(s.substring(0, 20)) + "...";
        }
        if (DataSerializer.needsQuote(type)) {
            s = "'" + s + "'";
        }
        return s;
    }

    public String getLabel(Object val, int type) {
        return this.serialize(val, type);
    }

    public String serialize(Object val, int type) {
        return DataSerializer.serialize(val, type);
    }

    public Object deserialize(String val, int type) {
        return DataDeserializer.deserialize(val, type);
    }

    public boolean supportsInlineEdit() {
        return true;
    }
}

