/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class ClientWizardWidgetDefaultingCommand
extends AbstractDataModelOperation {
    private int clientGeneration_;
    private boolean developClient_;
    private boolean assembleClient_;
    private boolean deployClient_;
    private boolean installClient_;
    private boolean startClient_;
    private boolean testClient_;
    private boolean clientOnly_ = false;

    public ClientWizardWidgetDefaultingCommand() {
    }

    public ClientWizardWidgetDefaultingCommand(boolean clientOnly) {
        this.clientOnly_ = clientOnly;
    }

    public Boolean getTestService() {
        return new Boolean(this.getScenarioContext().getTestWebService());
    }

    public Boolean getMonitorService() {
        return new Boolean(this.getScenarioContext().getMonitorWebService());
    }

    public boolean getInstallClient() {
        return this.installClient_;
    }

    public boolean getRunTestClient() {
        return this.getScenarioContext().isLaunchSampleEnabled();
    }

    public int getClientGeneration() {
        return this.clientGeneration_;
    }

    public ResourceContext getResourceContext() {
        return WebServicePlugin.getInstance().getResourceContext();
    }

    protected ScenarioContext getScenarioContext() {
        return WebServicePlugin.getInstance().getScenarioContext();
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        String type = this.getScenarioContext().getClientWebServiceType();
        String runtime = WebServiceRuntimeExtensionUtils2.getAllRuntimesForClientSide()[0];
        String[] servers = WebServiceRuntimeExtensionUtils2.getAllClientServerFactoryIds();
        String server = null;
        if (servers != null && servers.length > 0) {
            server = servers[0];
        }
        TypeRuntimeServer result = new TypeRuntimeServer();
        result.setTypeId(type);
        result.setRuntimeId(runtime);
        result.setServerId(server);
        return result;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.defaultClientScale();
        return Status.OK_STATUS;
    }

    protected void defaultClientScale() {
        this.clientGeneration_ = this.getScenarioContext().getGenerateClient();
        if (this.clientOnly_ && this.clientGeneration_ == 6) {
            this.developClient_ = true;
            this.assembleClient_ = true;
            this.deployClient_ = true;
            this.clientGeneration_ = 3;
        } else {
            this.developClient_ = this.clientGeneration_ <= 5;
            this.assembleClient_ = this.clientGeneration_ <= 4;
            this.deployClient_ = this.clientGeneration_ <= 3;
        }
        this.installClient_ = this.clientGeneration_ <= 2;
        this.startClient_ = this.clientGeneration_ <= 1;
        this.testClient_ = this.clientGeneration_ <= 0;
    }

    public boolean getDevelopClient() {
        return this.developClient_;
    }

    public boolean getAssembleClient() {
        return this.assembleClient_;
    }

    public boolean getDeployClient() {
        return this.deployClient_;
    }

    public boolean getStartClient() {
        return this.startClient_;
    }

    public boolean getTestClient() {
        return this.testClient_;
    }
}

