/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;

public class ExtendedImportRegistry
extends RegistryReader {
    private static final String PLUGIN_ID = "org.eclipse.jst.j2ee";
    private static final String EXTENSION_ID = "ExtendedModuleImport";
    private static final String FACTORY_CLASS = "factoryClass";
    private static final String MODULE_TYPE = "moduleType";
    public static final String EJB_TYPE = "EJB";
    private List ejbConfigurationElements = null;
    private List ejbFactories = null;
    private static ExtendedImportRegistry instance = null;

    public static ExtendedImportRegistry getInstance() {
        instance = new ExtendedImportRegistry();
        return instance;
    }

    private ExtendedImportRegistry() {
        super(PLUGIN_ID, EXTENSION_ID);
        this.readRegistry();
    }

    public List getFactories(String type) {
        if (type.equals(EJB_TYPE)) {
            if (this.ejbFactories == null) {
                this.ejbFactories = new ArrayList();
                int i = 0;
                while (this.ejbConfigurationElements != null && i < this.ejbConfigurationElements.size()) {
                    try {
                        this.ejbFactories.add(((IConfigurationElement)this.ejbConfigurationElements.get(i)).createExecutableExtension(FACTORY_CLASS));
                    }
                    catch (CoreException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                    ++i;
                }
            }
            return this.ejbFactories;
        }
        return null;
    }

    public boolean readElement(IConfigurationElement element) {
        String moduleType = element.getAttribute(MODULE_TYPE);
        if (moduleType != null && moduleType.equals(EJB_TYPE)) {
            if (this.ejbConfigurationElements == null) {
                this.ejbConfigurationElements = new ArrayList();
            }
            this.ejbConfigurationElements.add(element);
            return true;
        }
        return false;
    }
}

