/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.layout.vnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IDependencyNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.layout.AbstractOnDemandContentProviderNav;

public class ServerExplorerVNodeContentProviderNav
extends AbstractOnDemandContentProviderNav {
    private static DatabaseDefinitionRegistry registry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    private static final String TABLE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.TABLE");
    private static final String SEQUENCE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.SEQUENCE");
    private static final String UDT = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.UDT");
    private static final String VIEW = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.VIEW");
    private static final String TRIGGER = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.TRIGGER");
    private static final String INDEX = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.INDEX");
    private static final String CONSTRAINT = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.CONSTRAINT");
    private static final String COLUMN = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.COLUMN");
    private static final String SCHEMA = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.SCHEMA");
    private static final String DEPENDENCY = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DEPENDENCY");
    private static final String STORED_PROCEDURE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.STORED_PROCEDURE");
    private static final String UDF = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.UDF");
    private static final String AUTHORIZATION_ID = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.AUTH_ID");
    private static final String ROLE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.ROLE");
    private static final String USER = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.USER");
    private static final String GROUP = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.GROUP");

    private DatabaseDefinition getDatabaseDefinition(Object parent) {
        if (parent instanceof Schema) {
            return registry.getDefinition(((Schema)parent).getDatabase());
        }
        if (parent instanceof Table) {
            return registry.getDefinition(((Table)parent).getSchema().getDatabase());
        }
        if (parent instanceof Database) {
            return registry.getDefinition((Database)parent);
        }
        return null;
    }

    private Collection getChildren(String groupID, List children) {
        ArrayList<EObject> list = new ArrayList<EObject>(children.size());
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            if (!groupID.equals(containmentService.getGroupId(child))) continue;
            list.add(child);
        }
        return list;
    }

    protected Object[] displaySchemaNodeChildren(Object parent) {
        Database database = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)database.getSchemas()));
    }

    protected Object[] displaySchemaChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(7);
        collection.add(nodeFactory.makeTableNode(TABLE, TABLE, parent));
        collection.add(nodeFactory.makeViewNode(VIEW, VIEW, parent));
        collection.add(nodeFactory.makeStoredProcedureNode(STORED_PROCEDURE, STORED_PROCEDURE, parent));
        collection.add(nodeFactory.makeUDFNode(UDF, UDF, parent));
        if (df.supportsSequence()) {
            collection.add(nodeFactory.makeSequenceNode(SEQUENCE, SEQUENCE, parent));
        }
        if (df.supportsUserDefinedType()) {
            collection.add(nodeFactory.makeUDTNode(UDT, UDT, parent));
        }
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayServerChildren(Object parent) {
        IConnectionNode node = (IConnectionNode)parent;
        return new Object[]{node.getConnectionInfo().getSharedDatabase()};
    }

    protected Object[] displayDatabaseNodeChildren(Object parent) {
        return EMPTY_ELEMENT_ARRAY;
    }

    protected Object[] displayTableNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getTables()));
    }

    protected Object[] displayUDFNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getUDFs()));
    }

    protected Object[] displayStoredProcedureNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getProcedures()));
    }

    protected Object[] displaySequenceNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getSequences()));
    }

    protected Object[] displayUDTNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getUserDefinedTypes()));
    }

    protected Object[] displayTriggerNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getTriggers()));
    }

    protected Object[] displayIndexNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getIndex()));
    }

    protected Object[] displayConstraintNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getConstraints()));
    }

    protected Object[] displayColumnNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getColumns()));
    }

    protected Object[] displayViewsNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getTables()));
    }

    protected Object[] displayTableChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(5);
        collection.add(nodeFactory.makeColumnNode(COLUMN, COLUMN, parent));
        if (df.supportsTriggers()) {
            collection.add(nodeFactory.makeTriggerNode(TRIGGER, TRIGGER, parent));
        }
        collection.add(nodeFactory.makeIndexNode(INDEX, INDEX, parent));
        collection.add(nodeFactory.makeConstraintNode(CONSTRAINT, CONSTRAINT, parent));
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayViewChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(4);
        collection.add(nodeFactory.makeColumnNode(COLUMN, COLUMN, parent));
        if (df.supportsViewTriggers()) {
            collection.add(nodeFactory.makeTriggerNode(TRIGGER, TRIGGER, parent));
        }
        if (df.supportsViewIndex()) {
            collection.add(nodeFactory.makeIndexNode(INDEX, INDEX, parent));
        }
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayDatabaseChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>();
        collection.add(nodeFactory.makeSchemaNode(SCHEMA, SCHEMA, parent));
        if (df.isAuthorizationIdentifierSupported()) {
            boolean isAuthorizationSupported;
            boolean bl = isAuthorizationSupported = !df.isUserSupported() && !df.isGroupSupported() && !df.isRoleSupported();
            if (isAuthorizationSupported) {
                collection.add(nodeFactory.makeAuthorizationIdNode(AUTHORIZATION_ID, AUTHORIZATION_ID, parent));
            }
            if (df.isUserSupported()) {
                collection.add(nodeFactory.makeUserNode(USER, USER, parent));
            }
            if (df.isRoleSupported()) {
                collection.add(nodeFactory.makeRoleNode(ROLE, ROLE, parent));
            }
            if (df.isGroupSupported()) {
                collection.add(nodeFactory.makeGroupNode(GROUP, GROUP, parent));
            }
        }
        return this.getArrays(parent, collection);
    }

    protected Object[] displayDependencyNodeChildren(Object parent) {
        SQLObject object = (SQLObject)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getDependencies()));
    }

    protected Object[] displayGroupNodeChildren(Object parent) {
        Database object = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getAuthorizationIds()));
    }

    protected Object[] displayRoleNodeChildren(Object parent) {
        Database object = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getAuthorizationIds()));
    }

    protected Object[] displayUserNodeChildren(Object parent) {
        Database object = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getAuthorizationIds()));
    }

    protected Object[] displayStoredProcedureChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayTriggerChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayUDFChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayColumnChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayIndexChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayConstraintChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }
}

