/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.rdb.internal.outputview.IXMLTab;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

public class DialogShowXMLField
extends Dialog {
    protected String xmlText;
    protected String dialogTitle;
    protected Button btnClose;
    protected Button btnSaveAs;
    private static final String XML_TABS_EXT_POINT = "org.eclipse.wst.rdb.outputview.xmlTabs";
    private static final String XML_TAB_ATTR_CLASS = "class";

    public DialogShowXMLField(Shell shell, String title, String text) {
        super(shell);
        this.xmlText = text;
        this.dialogTitle = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        return super.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 480;
        gridData.heightHint = 300;
        TabFolder tabFolder = new TabFolder(composite, 1024);
        tabFolder.setLayoutData((Object)gridData);
        this.addTabItemsFromExtensions(tabFolder);
        this.createSourceTabItem(tabFolder);
        return composite;
    }

    private void addTabItemsFromExtensions(TabFolder parent) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(XML_TABS_EXT_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement currentConfigElement = configElements[j];
                try {
                    IXMLTab myXMLTabs = (IXMLTab)currentConfigElement.createExecutableExtension(XML_TAB_ATTR_CLASS);
                    myXMLTabs.init(this.xmlText);
                    myXMLTabs.parse();
                    myXMLTabs.getXMLTab(parent);
                }
                catch (CoreException ex) {
                    OutputViewPlugin.getPlugin().writeLog(4, 0, "DialogShowXMLField:addTabItemsFromExtensions()", ex);
                }
                ++j;
            }
            ++i;
        }
    }

    private void createSourceTabItem(TabFolder parent) {
        Text sourceText = new Text((Composite)parent, 586);
        sourceText.setText(this.xmlText);
        TabItem item = new TabItem(parent, 0);
        item.setText(OutputViewPlugin.getString("XML_DIALOG_SOURCE"));
        item.setControl((Control)sourceText);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnSaveAs = this.createButton(parent, 0, OutputViewPlugin.getString("OV_MESSAGE_SAVE_AS"), false);
        this.btnClose = this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void okPressed() {
        this.saveOutput();
    }

    protected void displayDirectoryError(Shell aShell, String aFile) {
        Object[] obj = new Object[]{aFile};
        String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_DESC", obj);
        MessageBox box = new MessageBox(aShell, 33);
        box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_TITLE"));
        box.setMessage(message);
        box.open();
        this.saveOutput();
    }

    private void saveOutput() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.isDirectory()) {
                    this.displayDirectoryError(this.getShell(), fileName);
                    return;
                }
                if (file.exists()) {
                    Object[] obj = new Object[]{fileName};
                    String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_DESC", obj);
                    MessageBox box = new MessageBox(this.getShell(), 192);
                    box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_TITLE"));
                    box.setMessage(message);
                    if (box.open() != 64) {
                        return;
                    }
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write(this.xmlText);
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                MessageBox box = new MessageBox(this.getShell(), 1);
                box.setText(OutputViewPlugin.getString("OV_STATUS_ERROR"));
                box.setMessage(ex.getMessage());
                box.open();
            }
        }
    }
}

