/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPluginIcons;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class J2EEUtilityJarImportTypePageNew
extends DataModelWizardPage {
    protected static final String defBrowseButtonLabel = J2EEUIMessages.getResourceString("93");
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    protected IStructuredSelection currentResourceSelection;
    private Combo resourceNameCombo;
    private Button copyJarIntoEAR;
    private Button linkJarIntoEAR;
    private Button createLinkedProjects;
    private Button createProjects;
    protected Button browseButton;
    private Button overrideProjectRootCheckbox;
    protected Text projectRootLocationText;
    private Label moduleProjectLocationLabel;
    protected boolean synching;
    public static final String TITLE = J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_0");
    public static final String DESCRIPTION = J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_1");
    private Group projectRootComposite;

    public J2EEUtilityJarImportTypePageNew(IDataModel model, String pageName, String title, ImageDescriptor titleImage) {
        super(model, pageName, title, titleImage);
        this.setTitle("");
        this.setDescription("");
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor(J2EEUIPluginIcons.EAR_IMPORT_WIZARD_BANNER));
        this.setInfopopID("org.eclipse.jst.j2ee.ui.IMPORT_UTILITY_JAR_WIZARD_PAGE2");
    }

    public J2EEUtilityJarImportTypePageNew(IDataModel model, String pageName, IStructuredSelection selection) {
        super(model, pageName);
        this.currentResourceSelection = selection;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor(J2EEUIPluginIcons.EAR_IMPORT_WIZARD_BANNER));
    }

    public J2EEUtilityJarImportTypePageNew(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor(J2EEUIPluginIcons.EAR_IMPORT_WIZARD_BANNER));
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME", "J2EEUtilityJarListImportDataModel.PROJECT_ROOT"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createEARProjectGroup(composite);
        this.createUtilityJarImportTypes(composite);
        this.createProjectCreationOptions(composite);
        this.setupBasedOnInitialSelections();
        return composite;
    }

    protected void createUtilityJarImportTypes(Composite parent) {
        Group typesGroup = new Group(parent, 0);
        typesGroup.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_2"));
        GridLayout layout = new GridLayout(1, false);
        typesGroup.setLayout((Layout)layout);
        typesGroup.setLayoutData((Object)new GridData(768));
        this.createProjects = new Button((Composite)typesGroup, 16);
        this.createProjects.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_3"));
        this.synchHelper.synchRadio(this.createProjects, "J2EEUtilityJarListImportDataModel.CREATE_PROJECT", null);
        this.createLinkedProjects = new Button((Composite)typesGroup, 16);
        this.createLinkedProjects.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_4"));
        this.synchHelper.synchRadio(this.createLinkedProjects, "J2EEUtilityJarListImportDataModel.CREATE_LINKED_PROJECT", null);
        this.copyJarIntoEAR = new Button((Composite)typesGroup, 16);
        this.copyJarIntoEAR.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_5"));
        this.synchHelper.synchRadio(this.copyJarIntoEAR, "J2EEUtilityJarListImportDataModel.COPY", null);
        this.linkJarIntoEAR = new Button((Composite)typesGroup, 16);
        this.linkJarIntoEAR.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_6"));
        this.synchHelper.synchRadio(this.linkJarIntoEAR, "J2EEUtilityJarListImportDataModel.LINK_IMPORT", null);
    }

    protected void createProjectCreationOptions(Composite parent) {
        Group projectOptionsGroup = new Group(parent, 0);
        projectOptionsGroup.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_7"));
        GridLayout layout = new GridLayout(1, false);
        projectOptionsGroup.setLayout((Layout)layout);
        projectOptionsGroup.setLayoutData((Object)new GridData(768));
        this.overrideProjectRootCheckbox = new Button((Composite)projectOptionsGroup, 32);
        this.overrideProjectRootCheckbox.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_11"));
        this.createProjectRootComposite((Composite)projectOptionsGroup);
        this.synchHelper.synchCheckbox(this.overrideProjectRootCheckbox, "J2EEUtilityJarListImportDataModel.OVERRIDE_PROJECT_ROOT", new Control[0]);
    }

    protected void createEARProjectGroup(Composite parent) {
        Group earGroup = new Group(parent, 0);
        earGroup.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_8"));
        GridLayout layout = new GridLayout(2, false);
        earGroup.setLayout((Layout)layout);
        earGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label((Composite)earGroup, 0);
        projectLabel.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportTypePage_UI_9"));
        this.resourceNameCombo = new Combo((Composite)earGroup, 2052);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.resourceNameCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.resourceNameCombo, "J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME", null);
    }

    protected void createProjectRootComposite(Composite parent) {
        this.projectRootComposite = new Group(parent, 0);
        this.projectRootComposite.setText(J2EEUIMessages.getResourceString("53"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.projectRootComposite.setLayout((Layout)layout);
        this.projectRootComposite.setLayoutData((Object)new GridData(768));
        Label description = new Label((Composite)this.projectRootComposite, 0);
        description.setText(J2EEUIMessages.getResourceString("54"));
        GridData gd2 = new GridData(256);
        gd2.horizontalSpan = 3;
        description.setLayoutData((Object)gd2);
        this.moduleProjectLocationLabel = new Label((Composite)this.projectRootComposite, 0);
        this.moduleProjectLocationLabel.setText(J2EEUIMessages.getResourceString("55"));
        this.moduleProjectLocationLabel.setLayoutData((Object)new GridData(256));
        this.projectRootLocationText = new Text((Composite)this.projectRootComposite, 2048);
        GridData gd = new GridData(768);
        this.projectRootLocationText.setLayoutData((Object)gd);
        this.projectRootLocationText.setText(ResourcesPlugin.getWorkspace().getRoot().getFullPath().toOSString());
        this.projectRootLocationText.setEnabled(false);
        this.browseButton = new Button((Composite)this.projectRootComposite, 8);
        this.browseButton.setText(defBrowseButtonLabel);
        gd = new GridData(128);
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2EEUtilityJarImportTypePageNew.this.handleRootProjectBrowseButtonPressed();
            }
        });
        this.synchHelper.synchText(this.projectRootLocationText, "J2EEUtilityJarListImportDataModel.PROJECT_ROOT", new Control[]{this.moduleProjectLocationLabel, this.projectRootLocationText, this.browseButton});
    }

    protected void handleRootProjectBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.browseButton.getShell());
        dialog.setMessage(J2EEUIMessages.getResourceString("57"));
        String dirName = this.getBrowseStartLocation();
        if (!this.isNullOrEmpty(dirName) && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.projectRootLocationText.setText(selectedDirectory);
        }
    }

    protected String getBrowseStartLocation() {
        String text = this.projectRootLocationText.getText();
        return text;
    }

    protected boolean isNullOrEmpty(String aString) {
        return aString == null || aString.length() == 0;
    }

    protected void setupBasedOnInitialSelections() {
        IResource resource;
        if (this.currentResourceSelection == null || this.currentResourceSelection.isEmpty() || this.setupBasedOnRefObjectSelection()) {
            return;
        }
        ArrayList<IResource> selections = new ArrayList<IResource>();
        Iterator aenum = this.currentResourceSelection.iterator();
        while (aenum.hasNext()) {
            IResource currentResource = (IResource)aenum.next();
            if (!currentResource.isAccessible()) continue;
            selections.add(currentResource);
        }
        if (selections.isEmpty()) {
            return;
        }
        int selectedResourceCount = selections.size();
        if (selectedResourceCount == 1 && (resource = (IResource)selections.get(0)) instanceof IProject) {
            this.resourceNameCombo.setText(resource.getName().toString());
        }
    }

    protected boolean setupBasedOnRefObjectSelection() {
        if (this.currentResourceSelection.size() != 1) {
            return false;
        }
        Object o = this.currentResourceSelection.getFirstElement();
        if (!this.isMetaTypeSupported(o)) {
            return false;
        }
        EObject ref = (EObject)o;
        IProject resource = ProjectUtilities.getProject((EObject)ref);
        if (resource != null) {
            this.resourceNameCombo.setText(resource.getName().toString());
        }
        return true;
    }

    protected boolean isMetaTypeSupported(Object o) {
        return o instanceof EARFile || o instanceof Application;
    }

    protected void enableProjectOptions(boolean enabled) {
        this.overrideProjectRootCheckbox.setEnabled(enabled);
        if (this.overrideProjectRootCheckbox.getSelection() && enabled) {
            this.projectRootLocationText.setEnabled(true);
        } else {
            this.projectRootLocationText.setEnabled(false);
        }
    }

    public boolean isPageComplete() {
        return this.model.validateProperty("J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME").isOK();
    }
}

