/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.reporter;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.CompileReport;
import ch.epfl.scala.bsp4j.CompileTask;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TaskFinishParams;
import ch.epfl.scala.bsp4j.TaskId;
import ch.epfl.scala.bsp4j.TaskProgressParams;
import ch.epfl.scala.bsp4j.TaskStartParams;
import com.microsoft.java.bs.core.internal.reporter.ProgressReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;

public class CompileProgressReporter
extends ProgressReporter {
    private final Map<String, Set<BuildTargetIdentifier>> taskPathMap;
    private final Map<String, Long> startTimes;

    public CompileProgressReporter(BuildClient client, String originId, Map<String, Set<BuildTargetIdentifier>> taskPathMap) {
        super(client, originId);
        this.taskPathMap = taskPathMap;
        this.startTimes = new HashMap<String, Long>();
    }

    public void statusChanged(ProgressEvent event) {
        if (this.client != null) {
            String taskPath = this.getTaskPath(event.getDescriptor());
            TaskId taskId = this.getTaskId(taskPath);
            Set<BuildTargetIdentifier> targets = this.taskPathMap.get(taskPath);
            if (targets != null) {
                if (event instanceof StartEvent) {
                    this.startTimes.put(taskPath, event.getEventTime());
                    this.taskStarted(taskId, targets, event.getDisplayName());
                } else if (event instanceof FinishEvent) {
                    OperationResult result = ((FinishEvent)event).getResult();
                    StatusCode status = result instanceof FailureResult ? StatusCode.ERROR : StatusCode.OK;
                    Long compileStartTime = this.startTimes.get(taskPath);
                    Long compileTimeDuration = compileStartTime == null ? null : Long.valueOf(event.getEventTime() - compileStartTime);
                    boolean skipped = result instanceof TaskSkippedResult;
                    boolean upToDate = result instanceof TaskSuccessResult && ((TaskSuccessResult)result).isUpToDate();
                    this.taskFinished(taskId, targets, event.getDisplayName(), compileTimeDuration, status, skipped || upToDate);
                } else {
                    this.taskInProgress(taskId, targets, event.getDisplayName());
                }
            }
        }
    }

    private void taskStarted(TaskId taskId, Set<BuildTargetIdentifier> targets, String message) {
        long eventTime = System.currentTimeMillis();
        targets.forEach(btId -> {
            TaskStartParams startParam = new TaskStartParams(taskId);
            startParam.setEventTime(Long.valueOf(eventTime));
            startParam.setMessage(message);
            startParam.setDataKind("compile-task");
            startParam.setData((Object)new CompileTask(btId));
            this.client.onBuildTaskStart(startParam);
        });
    }

    private void taskInProgress(TaskId taskId, Set<BuildTargetIdentifier> targets, String message) {
        long eventTime = System.currentTimeMillis();
        targets.forEach(btId -> {
            TaskProgressParams progressParam = new TaskProgressParams(taskId);
            progressParam.setEventTime(Long.valueOf(eventTime));
            progressParam.setMessage(message);
            progressParam.setDataKind("compile-task");
            progressParam.setData((Object)new CompileTask(btId));
            this.client.onBuildTaskProgress(progressParam);
        });
    }

    private void taskFinished(TaskId taskId, Set<BuildTargetIdentifier> targets, String message, Long compileTimeDuration, StatusCode statusCode, boolean noOp) {
        long eventTime = System.currentTimeMillis();
        targets.forEach(btId -> {
            TaskFinishParams endParam = new TaskFinishParams(taskId, statusCode);
            endParam.setEventTime(Long.valueOf(eventTime));
            endParam.setMessage(message);
            endParam.setDataKind("compile-report");
            CompileReport compileReport = new CompileReport(btId, Integer.valueOf(0), Integer.valueOf(0));
            compileReport.setNoOp(Boolean.valueOf(noOp));
            compileReport.setOriginId(this.originId);
            compileReport.setTime(compileTimeDuration);
            endParam.setData((Object)compileReport);
            this.client.onBuildTaskFinish(endParam);
        });
    }
}

