/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;

public final class GradleVersion
implements Comparable<GradleVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\d+)(\\.\\d+)+)(-(\\p{Alpha}+)-(\\d+[a-z]?))?(-(SNAPSHOT|\\d{14}([-+]\\d{4})?))?");
    private static final int STAGE_MILESTONE = 0;
    private final String version;
    private final Long snapshot;
    private final String versionPart;
    private final Stage stage;
    private static final GradleVersion CURRENT;
    public static final String RESOURCE_NAME = "/org/eclipse/buildship/core/internal/gradle/buildship-runtime.properties";

    public static GradleVersion current() {
        return CURRENT;
    }

    public static GradleVersion version(String version) throws IllegalArgumentException {
        return new GradleVersion(version);
    }

    private GradleVersion(String version) {
        this.version = version;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Gradle version string (examples: '1.0', '1.0-rc-1')", version));
        }
        this.versionPart = matcher.group(1);
        if (matcher.group(4) != null) {
            int stageNumber = matcher.group(5).equals("milestone") ? 0 : (matcher.group(5).equals("preview") ? 2 : (matcher.group(5).equals("rc") ? 3 : 1));
            String stageString = matcher.group(6);
            this.stage = new Stage(stageNumber, stageString);
        } else {
            this.stage = null;
        }
        if ("snapshot".equals(matcher.group(5))) {
            this.snapshot = 0L;
        } else if (matcher.group(8) == null) {
            this.snapshot = null;
        } else if ("SNAPSHOT".equals(matcher.group(8))) {
            this.snapshot = 0L;
        } else {
            try {
                if (matcher.group(9) != null) {
                    this.snapshot = new SimpleDateFormat("yyyyMMddHHmmssZ").parse(matcher.group(8)).getTime();
                } else {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                    format.setTimeZone(TimeZone.getTimeZone("UTC"));
                    this.snapshot = format.parse(matcher.group(8)).getTime();
                }
            }
            catch (ParseException e) {
                throw new GradlePluginsRuntimeException(e);
            }
        }
    }

    public String toString() {
        return "Gradle " + this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    public GradleVersion getBaseVersion() {
        if (this.stage == null && this.snapshot == null) {
            return this;
        }
        return GradleVersion.version(this.versionPart);
    }

    @Override
    public int compareTo(GradleVersion gradleVersion) {
        int diff;
        String[] majorVersionParts = this.versionPart.split("\\.");
        String[] otherMajorVersionParts = gradleVersion.versionPart.split("\\.");
        for (int i = 0; i < majorVersionParts.length && i < otherMajorVersionParts.length; ++i) {
            int otherPart;
            int part = Integer.parseInt(majorVersionParts[i]);
            if (part > (otherPart = Integer.parseInt(otherMajorVersionParts[i]))) {
                return 1;
            }
            if (otherPart <= part) continue;
            return -1;
        }
        if (majorVersionParts.length > otherMajorVersionParts.length) {
            return 1;
        }
        if (majorVersionParts.length < otherMajorVersionParts.length) {
            return -1;
        }
        if (this.stage != null && gradleVersion.stage != null && (diff = this.stage.compareTo(gradleVersion.stage)) != 0) {
            return diff;
        }
        if (this.stage == null && gradleVersion.stage != null) {
            return 1;
        }
        if (this.stage != null && gradleVersion.stage == null) {
            return -1;
        }
        if (this.snapshot != null && gradleVersion.snapshot != null) {
            return this.snapshot.compareTo(gradleVersion.snapshot);
        }
        if (this.snapshot == null && gradleVersion.snapshot != null) {
            return 1;
        }
        if (this.snapshot != null && gradleVersion.snapshot == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GradleVersion other = (GradleVersion)o;
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean isValid() {
        return this.versionPart != null;
    }

    public boolean supportsCompositeBuilds() {
        return this.getBaseVersion().compareTo(GradleVersion.version("3.3")) >= 0;
    }

    public boolean supportsDashDashScan() {
        return this.getBaseVersion().compareTo(GradleVersion.version("3.5")) >= 0;
    }

    public boolean supportsSyncTasksInEclipsePluginConfig() {
        return this.getBaseVersion().compareTo(GradleVersion.version("5.4")) >= 0;
    }

    public boolean supportsSendingReservedProjects() {
        return this.getBaseVersion().compareTo(GradleVersion.version("5.5")) >= 0;
    }

    public boolean supportsTestAttributes() {
        return this.getBaseVersion().compareTo(GradleVersion.version("5.6")) >= 0;
    }

    public boolean supportsClosedProjectDependencySubstitution() {
        return this.getBaseVersion().compareTo(GradleVersion.version("5.6")) >= 0;
    }

    public boolean supportsTestDebugging() {
        return this.getBaseVersion().compareTo(GradleVersion.version("5.6")) >= 0;
    }

    public boolean supportsTaskExecutionInIncudedBuild() {
        return this.getBaseVersion().compareTo(GradleVersion.version("6.8")) >= 0;
    }

    static {
        URL resource = GradleVersion.class.getResource(RESOURCE_NAME);
        if (resource == null) {
            throw new GradlePluginsRuntimeException(String.format("Resource '%s' not found.", RESOURCE_NAME));
        }
        InputStream inputStream = null;
        try {
            URLConnection connection = resource.openConnection();
            connection.setUseCaches(false);
            inputStream = connection.getInputStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            String version = properties.get("ToolingApiVersion").toString();
            CURRENT = new GradleVersion(version);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(String.format("Could not load version details from resource '%s'.", resource), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new GradlePluginsRuntimeException(e);
                }
            }
        }
    }

    static final class Stage
    implements Comparable<Stage> {
        final int stage;
        final int number;
        final Character patchNo;

        Stage(int stage, String number) {
            this.stage = stage;
            Matcher m = Pattern.compile("(\\d+)([a-z])?").matcher(number);
            try {
                m.matches();
                this.number = Integer.parseInt(m.group(1));
            }
            catch (Exception e) {
                throw new GradlePluginsRuntimeException("Invalid stage small number: " + number, e);
            }
            this.patchNo = m.groupCount() == 2 && m.group(2) != null ? Character.valueOf(m.group(2).charAt(0)) : Character.valueOf('_');
        }

        @Override
        public int compareTo(Stage other) {
            if (this.stage > other.stage) {
                return 1;
            }
            if (this.stage < other.stage) {
                return -1;
            }
            if (this.number > other.number) {
                return 1;
            }
            if (this.number < other.number) {
                return -1;
            }
            if (this.patchNo.charValue() > other.patchNo.charValue()) {
                return 1;
            }
            if (this.patchNo.charValue() < other.patchNo.charValue()) {
                return -1;
            }
            return 0;
        }
    }
}

