/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalUtils;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionGuessMethodArgumentsMode;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemLabelDetails;

public class CompletionProposalDescriptionProvider {
    private static final String RETURN_TYPE_SEPARATOR = " : ";
    private static final String PACKAGE_NAME_SEPARATOR = " - ";
    private static final String VAR_TYPE_SEPARATOR = " : ";
    private static final String OBJECT = "java.lang.Object";
    private CompletionContext fContext;
    private ICompilationUnit fUnit;
    private Map<String, Integer> fCollapsedTypes;

    public CompletionProposalDescriptionProvider(ICompilationUnit unit, CompletionContext context, Map<String, Integer> collapsedTypes) {
        this.fContext = context;
        this.fUnit = unit;
        this.fCollapsedTypes = collapsedTypes;
    }

    public CompletionProposalDescriptionProvider(ICompilationUnit unit, CompletionContext context) {
        this.fContext = context;
        this.fUnit = unit;
    }

    public CompletionProposalDescriptionProvider(CompletionContext context) {
        this.fContext = context;
    }

    public static StringBuilder createMethodProposalDescription(CompletionProposal proposal) {
        int kind = proposal.getKind();
        StringBuilder description = new StringBuilder();
        switch (kind) {
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 26: {
                description.append(proposal.getName());
                description.append('(');
                CompletionProposalDescriptionProvider.appendUnboundedParameterList(description, proposal);
                description.append(')');
                if (proposal.isConstructor()) break;
                description.append(" : ");
                CompletionProposalDescriptionProvider.appendReturnType(description, proposal);
            }
        }
        return description;
    }

    private static StringBuilder appendReturnType(StringBuilder description, CompletionProposal proposal) {
        char[] returnType = CompletionProposalDescriptionProvider.createTypeDisplayName(SignatureUtil.getUpperBound((char[])Signature.getReturnType((char[])SignatureUtil.fix83600((char[])proposal.getSignature()))));
        description.append(returnType);
        return description;
    }

    public StringBuilder createParameterList(CompletionProposal proposal) {
        int kind = proposal.getKind();
        switch (kind) {
            case 6: 
            case 26: {
                return CompletionProposalDescriptionProvider.appendUnboundedParameterList(new StringBuilder(), proposal);
            }
            case 9: 
            case 16: {
                return this.appendTypeParameterList(new StringBuilder(), proposal);
            }
            case 1: 
            case 27: {
                return CompletionProposalDescriptionProvider.appendUnboundedParameterList(new StringBuilder(), proposal);
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    private static StringBuilder appendUnboundedParameterList(StringBuilder buffer, CompletionProposal methodProposal) {
        char[][] parameterNames;
        char[] signature = SignatureUtil.fix83600((char[])methodProposal.getSignature());
        try {
            parameterNames = methodProposal.findParameterNames(null);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            parameterNames = CompletionEngine.createDefaultParameterNames((int)Signature.getParameterCount((char[])signature));
            methodProposal.setParameterNames(parameterNames);
        }
        char[][] parameterTypes = Signature.getParameterTypes((char[])signature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = CompletionProposalDescriptionProvider.createTypeDisplayName(SignatureUtil.getLowerBound((char[])parameterTypes[i]));
            ++i;
        }
        if (Flags.isVarargs((int)methodProposal.getFlags())) {
            int index = parameterTypes.length - 1;
            parameterTypes[index] = CompletionProposalDescriptionProvider.convertToVararg(parameterTypes[index]);
        }
        return CompletionProposalDescriptionProvider.appendParameterSignature(buffer, parameterTypes, parameterNames);
    }

    private StringBuilder appendTypeParameterList(StringBuilder buffer, CompletionProposal typeProposal) {
        char[] signature = SignatureUtil.fix83600((char[])typeProposal.getSignature());
        char[][] typeParameters = Signature.getTypeArguments((char[])signature);
        int i = 0;
        while (i < typeParameters.length) {
            char[] param = typeParameters[i];
            typeParameters[i] = Signature.toCharArray((char[])param);
            ++i;
        }
        return CompletionProposalDescriptionProvider.appendParameterSignature(buffer, typeParameters, null);
    }

    private static char[] convertToVararg(char[] typeName) {
        if (typeName == null) {
            return typeName;
        }
        int len = typeName.length;
        if (len < 2) {
            return typeName;
        }
        if (typeName[len - 1] != ']') {
            return typeName;
        }
        if (typeName[len - 2] != '[') {
            return typeName;
        }
        char[] vararg = new char[len + 1];
        System.arraycopy(typeName, 0, vararg, 0, len - 2);
        vararg[len - 2] = 46;
        vararg[len - 1] = 46;
        vararg[len] = 46;
        return vararg;
    }

    private static char[] createTypeDisplayName(char[] typeSignature) throws IllegalArgumentException {
        char[] displayName = Signature.getSimpleName((char[])Signature.toCharArray((char[])typeSignature));
        boolean useShortGenerics = false;
        if (useShortGenerics) {
            int pos;
            StringBuilder buf = new StringBuilder();
            buf.append(displayName);
            do {
                if ((pos = buf.indexOf("? extends ")) >= 0) {
                    buf.replace(pos, pos + 10, "+");
                    continue;
                }
                pos = buf.indexOf("? super ");
                if (pos < 0) continue;
                buf.replace(pos, pos + 8, "-");
            } while (pos >= 0);
            return buf.toString().toCharArray();
        }
        return displayName;
    }

    private static final StringBuilder appendParameterSignature(StringBuilder buffer, char[][] parameterTypes, char[][] parameterNames) {
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterTypes[i]);
                if (parameterNames != null && parameterNames[i] != null) {
                    buffer.append(' ');
                    buffer.append(parameterNames[i]);
                }
                ++i;
            }
        }
        return buffer;
    }

    private void createMethodProposalLabel(CompletionProposal methodProposal, CompletionItem item) {
        StringBuilder description = CompletionProposalDescriptionProvider.createMethodProposalDescription(methodProposal);
        String proposalName = String.valueOf(methodProposal.getName());
        boolean skipDetail = false;
        if (this.isCompletionItemLabelDetailsSupport()) {
            if (this.fCollapsedTypes != null && this.fCollapsedTypes.getOrDefault(proposalName, 0) > 1 && methodProposal.getKind() != 26) {
                this.setLabelDetails(item, proposalName, "(...)", this.fCollapsedTypes.get(proposalName).toString() + " overloads");
                skipDetail = true;
            } else {
                StringBuilder methodParams = new StringBuilder();
                methodParams.append('(');
                CompletionProposalDescriptionProvider.appendUnboundedParameterList(methodParams, methodProposal);
                methodParams.append(')');
                if (methodProposal.getKind() != 26) {
                    StringBuilder returnType = new StringBuilder();
                    CompletionProposalDescriptionProvider.appendReturnType(returnType, methodProposal);
                    this.setLabelDetails(item, proposalName, methodParams.toString(), returnType.toString());
                } else {
                    this.setLabelDetails(item, proposalName, methodParams.toString(), null);
                }
            }
        } else if (this.fCollapsedTypes != null && this.fCollapsedTypes.getOrDefault(proposalName, 0) > 1 && methodProposal.getKind() != 26) {
            item.setLabel(proposalName + "(...)");
            item.setDetail(this.fCollapsedTypes.get(proposalName).toString() + " overloads");
            skipDetail = true;
        } else {
            item.setLabel(description.toString());
        }
        item.setInsertText(String.valueOf(methodProposal.getName()));
        StringBuilder typeInfo = new StringBuilder();
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        Object qualifier = null;
        if (methodProposal.getRequiredProposals() != null && ((String)(qualifier = Signature.getQualifier((String)declaringType))).length() > 0) {
            typeInfo.append((String)qualifier);
            typeInfo.append('.');
            qualifier = (String)qualifier + ".";
        }
        declaringType = Signature.getSimpleName((String)declaringType);
        typeInfo.append(declaringType);
        if (!skipDetail) {
            StringBuilder detail = new StringBuilder();
            if (typeInfo.length() > 0) {
                detail.append((CharSequence)typeInfo);
                detail.append('.');
            }
            detail.append((CharSequence)description);
            item.setDetail(detail.toString());
        }
        if (this.fUnit != null && methodProposal.isConstructor() && typeInfo.length() > 0 && item.getData() != null && methodProposal.getRequiredProposals() != null && methodProposal.getRequiredProposals().length > 0) {
            CompletionProposal requiredProposal = methodProposal.getRequiredProposals()[0];
            try {
                IDocument document = JsonRpcHelpers.toDocument(this.fUnit.getBuffer());
                String prefix = document.get(requiredProposal.getReplaceStart(), requiredProposal.getReplaceEnd() - requiredProposal.getReplaceStart());
                if (prefix != null && prefix.indexOf(".") > -1) {
                    description.insert(0, (String)qualifier);
                    item.setFilterText(description.toString());
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        } else {
            char[] chainName = methodProposal.getName();
            int index = CharOperation.lastIndexOf((char)'.', (char[])chainName);
            if (index > -1) {
                item.setFilterText(String.valueOf(CharOperation.subarray((char[])chainName, (int)(index + 1), (int)chainName.length)));
            }
        }
    }

    private void createJavadocMethodProposalLabel(CompletionProposal methodProposal, CompletionItem item) {
        item.setLabel(String.valueOf(methodProposal.getCompletion()));
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        item.setDetail(declaringType);
        if (this.isCompletionItemLabelDetailsSupport() && methodProposal.getKind() != 26) {
            StringBuilder returnType = new StringBuilder();
            CompletionProposalDescriptionProvider.appendReturnType(returnType, methodProposal);
            this.setLabelDetails(item, null, null, returnType.toString());
        }
    }

    private void createOverrideMethodProposalLabel(CompletionProposal methodProposal, CompletionItem item) {
        String name = new String(methodProposal.getName());
        item.setInsertText(name);
        StringBuilder parameters = new StringBuilder();
        parameters.append('(');
        CompletionProposalDescriptionProvider.appendUnboundedParameterList(parameters, methodProposal);
        parameters.append(')');
        char[] returnType = CompletionProposalDescriptionProvider.createTypeDisplayName(SignatureUtil.getUpperBound((char[])Signature.getReturnType((char[])SignatureUtil.fix83600((char[])methodProposal.getSignature()))));
        if (this.isCompletionItemLabelDetailsSupport()) {
            this.setLabelDetails(item, String.valueOf(methodProposal.getName()), parameters.toString(), String.valueOf(returnType));
        } else {
            StringBuilder nameBuffer = new StringBuilder();
            nameBuffer.append(name);
            nameBuffer.append((CharSequence)parameters);
            nameBuffer.append(" : ");
            nameBuffer.append(returnType);
            item.setLabel(nameBuffer.toString());
        }
        item.setFilterText(name);
        StringBuilder typeBuffer = new StringBuilder();
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        typeBuffer.append(String.format("Override method in '%s'", declaringType));
        item.setDetail(typeBuffer.toString());
    }

    private String extractDeclaringTypeFQN(CompletionProposal methodProposal) {
        char[] declaringTypeSignature = methodProposal.getDeclarationSignature();
        if (declaringTypeSignature == null) {
            return OBJECT;
        }
        return SignatureUtil.stripSignatureToFQN((String)String.valueOf(declaringTypeSignature));
    }

    private void createTypeProposalLabel(CompletionProposal typeProposal, CompletionItem item) {
        char[] signature = this.fContext != null && this.fContext.isInJavadoc() ? (typeProposal.getArrayDimensions() > 0 ? Signature.createArraySignature((char[])Signature.getTypeErasure((char[])typeProposal.getSignature()), (int)typeProposal.getArrayDimensions()) : Signature.getTypeErasure((char[])typeProposal.getSignature())) : (typeProposal.getArrayDimensions() > 0 ? Signature.createArraySignature((char[])typeProposal.getSignature(), (int)typeProposal.getArrayDimensions()) : typeProposal.getSignature());
        char[] fullName = Signature.toCharArray((char[])signature);
        this.createTypeProposalLabel(fullName, item);
    }

    private void createJavadocTypeProposalLabel(CompletionProposal typeProposal, CompletionItem item) {
        char[] fullName = Signature.toCharArray((char[])typeProposal.getSignature());
        this.createJavadocTypeProposalLabel(fullName, item);
    }

    private void createJavadocSimpleProposalLabel(CompletionProposal proposal, CompletionItem item) {
        item.setLabel(this.createSimpleLabel(proposal).toString());
    }

    void createTypeProposalLabel(char[] fullName, CompletionItem item) {
        String packageName;
        int qIndex = this.findSimpleNameStart(fullName);
        String name = new String(fullName, qIndex, fullName.length - qIndex);
        item.setFilterText(name);
        item.setInsertText(name);
        item.setDetail(new String(fullName));
        String string = packageName = qIndex > 0 ? new String(fullName, 0, qIndex - 1) : null;
        if (this.isCompletionItemLabelDetailsSupport()) {
            this.setLabelDetails(item, name, null, packageName);
        } else {
            StringBuilder nameBuffer = new StringBuilder();
            nameBuffer.append(name);
            if (packageName != null) {
                nameBuffer.append(PACKAGE_NAME_SEPARATOR);
                nameBuffer.append(packageName);
            }
            item.setLabel(nameBuffer.toString());
        }
    }

    private void createJavadocTypeProposalLabel(char[] fullName, CompletionItem item) {
        String packageName;
        int qIndex = this.findSimpleNameStart(fullName);
        StringBuilder nameBuffer = new StringBuilder();
        String name = new String(fullName, qIndex, fullName.length - qIndex);
        nameBuffer.append("{@link ");
        nameBuffer.append(name);
        nameBuffer.append('}');
        item.setLabel(nameBuffer.toString());
        item.setFilterText(name);
        String string = packageName = qIndex > 0 ? new String(fullName, 0, qIndex - 1) : null;
        if (packageName != null) {
            item.setDetail(packageName);
        }
    }

    private int findSimpleNameStart(char[] array) {
        int lastDot = 0;
        int i = 0;
        int len = array.length;
        while (i < len) {
            char ch = array[i];
            if (ch == '<') {
                return lastDot;
            }
            if (ch == '.') {
                lastDot = i + 1;
            }
            ++i;
        }
        return lastDot;
    }

    private void createSimpleLabelWithType(CompletionProposal proposal, CompletionItem item) {
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        String name = String.valueOf(proposal.getCompletion());
        item.setInsertText(name);
        if (this.isCompletionItemLabelDetailsSupport()) {
            this.setLabelDetails(item, name, null, String.valueOf(typeName));
        } else {
            StringBuilder nameBuffer = new StringBuilder();
            nameBuffer.append(name);
            if (typeName.length > 0) {
                nameBuffer.append(" : ");
                nameBuffer.append(typeName);
            }
            item.setLabel(nameBuffer.toString());
        }
    }

    private boolean isThisPrefix(char[] string) {
        if (string == null || string.length < 5) {
            return false;
        }
        return string[0] == 't' && string[1] == 'h' && string[2] == 'i' && string[3] == 's' && string[4] == '.';
    }

    private void createLabelWithTypeAndDeclaration(CompletionProposal proposal, CompletionItem item) {
        char[] name = proposal.getCompletion();
        if (!this.isThisPrefix(name)) {
            name = proposal.getName();
        }
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        item.setInsertText(buf.toString());
        if (typeName.length > 0) {
            buf.append(" : ");
            buf.append(typeName);
        }
        if (this.isCompletionItemLabelDetailsSupport()) {
            this.setLabelDetails(item, String.valueOf(name), null, String.valueOf(typeName));
        } else {
            item.setLabel(buf.toString());
        }
        char[] declaration = proposal.getDeclarationSignature();
        StringBuilder detailBuf = new StringBuilder();
        if (declaration != null && (declaration = Signature.getSignatureSimpleName((char[])declaration)).length > 0) {
            String declaringType;
            String qualifier;
            if (proposal.getRequiredProposals() != null && (qualifier = Signature.getQualifier((String)(declaringType = this.extractDeclaringTypeFQN(proposal)))).length() > 0) {
                detailBuf.append(qualifier);
                detailBuf.append('.');
            }
            detailBuf.append(declaration);
        }
        if (detailBuf.length() > 0) {
            detailBuf.append('.');
        }
        detailBuf.append((CharSequence)buf);
        item.setDetail(detailBuf.toString());
    }

    private void createPackageProposalLabel(CompletionProposal proposal, CompletionItem item) {
        Assert.isTrue((proposal.getKind() == 8 || proposal.getKind() == 29 || proposal.getKind() == 28 ? 1 : 0) != 0);
        item.setLabel(String.valueOf(proposal.getDeclarationSignature()));
        StringBuilder detail = new StringBuilder();
        detail.append(proposal.getKind() == 8 ? "(package) " : "(module) ");
        detail.append(String.valueOf(proposal.getDeclarationSignature()));
        item.setDetail(detail.toString());
        if (this.isCompletionItemLabelDetailsSupport()) {
            this.setLabelDetails(item, null, null, proposal.getKind() == 8 ? "(package)" : "(module)");
        }
    }

    StringBuilder createSimpleLabel(CompletionProposal proposal) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(proposal.getCompletion()));
        return buf;
    }

    private void createAnonymousTypeLabel(CompletionProposal proposal, CompletionItem item) {
        char[] signatureQualifier;
        char[] declaringTypeSignature = proposal.getDeclarationSignature();
        declaringTypeSignature = Signature.getTypeErasure((char[])declaringTypeSignature);
        String name = new String(Signature.getSignatureSimpleName((char[])declaringTypeSignature));
        item.setInsertText(name);
        StringBuilder methodParams = new StringBuilder();
        methodParams.append('(');
        CompletionProposalDescriptionProvider.appendUnboundedParameterList(methodParams, proposal);
        methodParams.append(')');
        if (this.isCompletionItemLabelDetailsSupport()) {
            StringBuilder returnType = new StringBuilder();
            CompletionProposalDescriptionProvider.appendReturnType(returnType, proposal);
            this.setLabelDetails(item, name, methodParams.toString(), "Anonymous Inner Type");
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(name);
            buf.append((CharSequence)methodParams);
            buf.append("  ");
            buf.append("Anonymous Inner Type");
            item.setLabel(buf.toString());
        }
        if (proposal.getRequiredProposals() != null && (signatureQualifier = Signature.getSignatureQualifier((char[])declaringTypeSignature)).length > 0) {
            item.setDetail(String.valueOf(signatureQualifier) + "." + name);
        }
    }

    private void createLabelWithLambdaExpression(CompletionProposal proposal, CompletionItem item) {
        StringBuilder label = new StringBuilder();
        label.append('(');
        CompletionProposalDescriptionProvider.appendUnboundedParameterList(label, proposal);
        label.append(')');
        label.append(" ->");
        char[] returnType = CompletionProposalDescriptionProvider.createTypeDisplayName(SignatureUtil.getUpperBound((char[])Signature.getReturnType((char[])SignatureUtil.fix83600((char[])proposal.getSignature()))));
        if (this.isCompletionItemLabelDetailsSupport()) {
            this.setLabelDetails(item, label.toString(), null, String.valueOf(returnType));
        } else {
            label.append(" : ");
            label.append(returnType);
            item.setLabel(label.toString());
        }
    }

    public void updateDescription(CompletionProposal proposal, CompletionItem item) {
        CompletionProposal requiredTypeProposal;
        if ((JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getGuessMethodArgumentsMode() == CompletionGuessMethodArgumentsMode.OFF || JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isCollapseCompletionItemsEnabled()) && (requiredTypeProposal = CompletionProposalUtils.getRequiredTypeProposal(proposal)) != null) {
            proposal = requiredTypeProposal;
        }
        switch (proposal.getKind()) {
            case 6: 
            case 11: 
            case 12: 
            case 24: 
            case 26: {
                if (this.fContext != null && this.fContext.isInJavadoc()) {
                    this.createJavadocMethodProposalLabel(proposal, item);
                    break;
                }
                this.createMethodProposalLabel(proposal, item);
                break;
            }
            case 7: {
                this.createOverrideMethodProposalLabel(proposal, item);
                break;
            }
            case 1: 
            case 27: {
                this.createAnonymousTypeLabel(proposal, item);
                break;
            }
            case 9: {
                this.createTypeProposalLabel(proposal, item);
                break;
            }
            case 16: {
                this.createJavadocTypeProposalLabel(proposal, item);
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.createJavadocSimpleProposalLabel(proposal, item);
                break;
            }
            case 15: {
                this.createJavadocMethodProposalLabel(proposal, item);
                break;
            }
            case 8: 
            case 28: 
            case 29: {
                this.createPackageProposalLabel(proposal, item);
                break;
            }
            case 2: 
            case 13: 
            case 25: {
                this.createLabelWithTypeAndDeclaration(proposal, item);
                break;
            }
            case 5: 
            case 10: {
                this.createSimpleLabelWithType(proposal, item);
                break;
            }
            case 3: 
            case 4: {
                item.setLabel(this.createSimpleLabel(proposal).toString());
                break;
            }
            case 30: {
                this.createLabelWithLambdaExpression(proposal, item);
                break;
            }
            default: {
                JavaLanguageServerPlugin.logInfo(new String(proposal.getName()) + " is of type " + this.getProposal(proposal));
                Assert.isTrue((boolean)false);
            }
        }
    }

    private String getProposal(CompletionProposal proposal) {
        try {
            Field[] fieldArray = CompletionProposal.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (Integer.TYPE.equals(field.getType()) && Integer.valueOf(proposal.getKind()).equals(field.get(null))) {
                    return field.getName();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    private void setLabelDetails(CompletionItem item, String label, String detail, String description) {
        CompletionItemLabelDetails itemLabelDetails = new CompletionItemLabelDetails();
        if (label != null) {
            item.setLabel(label);
        }
        if (detail != null) {
            itemLabelDetails.setDetail(detail);
        }
        if (description != null) {
            itemLabelDetails.setDescription(description);
        }
        item.setLabelDetails(itemLabelDetails);
    }

    private boolean isCompletionItemLabelDetailsSupport() {
        return JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionItemLabelDetailsSupport();
    }
}

