/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.net.httpserver.Event;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;
import sun.net.httpserver.StreamClosedException;
import sun.net.httpserver.WriteFinishedEvent;

class ChunkedOutputStream
extends FilterOutputStream {
    private boolean closed = false;
    static final int CHUNK_SIZE = 4096;
    static final int OFFSET = 6;
    private int pos = 6;
    private int count = 0;
    private byte[] buf = new byte[4104];
    ExchangeImpl t;

    ChunkedOutputStream(ExchangeImpl exchangeImpl, OutputStream outputStream) {
        super(outputStream);
        this.t = exchangeImpl;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        this.buf[this.pos++] = (byte)n;
        ++this.count;
        if (this.count == 4096) {
            this.writeChunk();
        }
        assert (this.count < 4096);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        int n3 = 4096 - this.count;
        if (n2 > n3) {
            System.arraycopy(byArray, n, this.buf, this.pos, n3);
            this.count = 4096;
            this.writeChunk();
            n2 -= n3;
            n += n3;
            while (n2 >= 4096) {
                System.arraycopy(byArray, n, this.buf, 6, 4096);
                n2 -= 4096;
                n += 4096;
                this.count = 4096;
                this.writeChunk();
            }
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buf, this.pos, n2);
            this.count += n2;
            this.pos += n2;
        }
        if (this.count == 4096) {
            this.writeChunk();
        }
    }

    private void writeChunk() throws IOException {
        int n;
        char[] cArray = Integer.toHexString(this.count).toCharArray();
        int n2 = cArray.length;
        int n3 = 4 - n2;
        for (n = 0; n < n2; ++n) {
            this.buf[n3 + n] = (byte)cArray[n];
        }
        this.buf[n3 + n++] = 13;
        this.buf[n3 + n++] = 10;
        this.buf[n3 + n++ + this.count] = 13;
        this.buf[n3 + n++ + this.count] = 10;
        this.out.write(this.buf, n3, n + this.count);
        this.count = 0;
        this.pos = 6;
    }

    @Override
    public void close() throws IOException {
        Object object;
        if (this.closed) {
            return;
        }
        this.flush();
        try {
            this.writeChunk();
            this.out.flush();
            object = this.t.getOriginalInputStream();
            if (!((LeftOverInputStream)object).isClosed()) {
                ((LeftOverInputStream)object).close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.closed = true;
        }
        object = new WriteFinishedEvent(this.t);
        this.t.getHttpContext().getServerImpl().addEvent((Event)object);
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        if (this.count > 0) {
            this.writeChunk();
        }
        this.out.flush();
    }
}

