/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox;

import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.Framework;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.PassageLicenseCoverage;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.code.NoDataOfType;
import org.eclipse.passage.lic.equinox.EquinoxFrameworkAware;
import org.eclipse.passage.lic.equinox.SuppliedFrameworkAware;
import org.eclipse.passage.lic.internal.base.access.Access;
import org.eclipse.passage.lic.internal.base.access.Libraries;
import org.eclipse.passage.lic.internal.base.access.SumOfCertificates;
import org.eclipse.passage.lic.internal.equinox.access.RegisteredLibraries;

public final class EquinoxPassageLicenseCoverage
implements PassageLicenseCoverage {
    private final EquinoxFrameworkAware<?> delegate;

    public EquinoxPassageLicenseCoverage() {
        this(new SuppliedFrameworkAware());
    }

    public EquinoxPassageLicenseCoverage(EquinoxFrameworkAware<?> delegate) {
        this.delegate = delegate;
    }

    public ServiceInvocationResult<ExaminationCertificate> assess() {
        return this.both(this.owner(), this.libraries());
    }

    private ServiceInvocationResult<ExaminationCertificate> both(ServiceInvocationResult<ExaminationCertificate> owner, Optional<ServiceInvocationResult<ExaminationCertificate>> libraries) {
        if (!libraries.isPresent()) {
            return owner;
        }
        return new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfCertificates()).apply(owner, libraries.get());
    }

    private Optional<ServiceInvocationResult<ExaminationCertificate>> libraries() {
        Optional<LicensedProduct> product = this.delegate.withFramework(Framework::product);
        if (!product.isPresent()) {
            return this.noOwningProduct();
        }
        return new Libraries((Supplier)new RegisteredLibraries(), product::get).assess();
    }

    private ServiceInvocationResult<ExaminationCertificate> owner() {
        return this.delegate.withFrameworkService(framework -> new Access(framework).assess());
    }

    private Optional<ServiceInvocationResult<ExaminationCertificate>> noOwningProduct() {
        return Optional.of(new BaseServiceInvocationResult(new Trouble((TroubleCode)new NoDataOfType(), "License Product definition is absent")));
    }
}

