/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponentVersion;

public final class RuntimeComponent
implements IRuntimeComponent {
    private RuntimeComponentVersion rcv = null;
    private IRuntime runtime = null;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, String> propertiesReadOnly = Collections.unmodifiableMap(this.properties);

    RuntimeComponent() {
    }

    @Override
    public IRuntimeComponentType getRuntimeComponentType() {
        return this.rcv.getRuntimeComponentType();
    }

    @Override
    public IRuntimeComponentVersion getRuntimeComponentVersion() {
        return this.rcv;
    }

    void setRuntimeComponentVersion(IRuntimeComponentVersion rcv) {
        this.rcv = (RuntimeComponentVersion)rcv;
    }

    @Override
    public IRuntime getRuntime() {
        return this.runtime;
    }

    void setRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        if (this.runtime != null) {
            throw new IllegalStateException(Resources.runtimeAlreadySet);
        }
        this.runtime = runtime;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.propertiesReadOnly;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Object getAdapter(Class type) {
        IAdapterManager manager = Platform.getAdapterManager();
        Object res = manager.loadAdapter((Object)this, type.getName());
        if (res == null) {
            IAdapterFactory factory = null;
            try {
                factory = this.rcv.getAdapterFactory(type);
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
            }
            if (factory != null) {
                res = factory.getAdapter((Object)this, type);
            }
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuntimeComponent) {
            RuntimeComponent rc = (RuntimeComponent)obj;
            return this.rcv == rc.rcv && this.properties.equals(rc.properties);
        }
        return false;
    }

    public int hashCode() {
        return this.rcv.hashCode();
    }

    public String toString() {
        return this.rcv.toString();
    }

    private static final class Resources
    extends NLS {
        public static String runtimeAlreadySet;

        static {
            Resources.initializeMessages((String)RuntimeComponent.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

