/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Runnables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.build.ResolvedResourceDescription;
import org.eclipse.xtext.builder.standalone.ClusteringConfig;
import org.eclipse.xtext.builder.standalone.IIssueHandler;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.StandaloneBuilderFileCallback;
import org.eclipse.xtext.builder.standalone.StandaloneBuilderState;
import org.eclipse.xtext.builder.standalone.compiler.CompilerConfiguration;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.builder.standalone.incremental.BinaryFileHashing;
import org.eclipse.xtext.builder.standalone.incremental.ClasspathInfos;
import org.eclipse.xtext.builder.standalone.incremental.CoarseGrainedEntryHash;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProviderExtension;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.TailWriter;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.FileProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class StandaloneBuilder {
    private static final Logger LOG = Logger.getLogger(StandaloneBuilder.class);
    private Map<String, LanguageAccess> languages;
    private String baseDir;
    private Iterable<String> sourceDirs;
    private Iterable<String> javaSourceDirs;
    private Iterable<String> classPathEntries;
    private File tempDir = null;
    private String encoding;
    private String classPathLookUpFilter;
    private boolean failOnValidationError = true;
    private boolean debugLog;
    private boolean writeStorageResources;
    private ClusteringConfig clusteringConfig = null;
    @Inject
    private IndexedJvmTypeAccess jvmTypeAccess;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private AbstractFileSystemAccess commonFileAccess;
    @Inject
    protected IIssueHandler issueHandler;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IJavaCompiler compiler;
    @Inject
    private ClasspathInfos classpathInfos;
    @Inject
    private CompilerPhases compilerPhases;
    private StandaloneBuilderState builderState;
    private final Map<LanguageAccess, JavaIoFileSystemAccess> configuredFsas = new HashMap<LanguageAccess, JavaIoFileSystemAccess>();
    private boolean incremental = false;
    private String classpathConfigurationLocation;
    private String classpathKey;
    private String classOutputDirectory;

    public StandaloneBuilder() {
        try {
            this.tempDir = Files.createTempDirectory("StandaloneBuilder", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setIncrementalBuild(boolean enable) {
        this.incremental = enable;
    }

    public void setClasspathConfigurationLocation(String location, String key, String outputDirectory) {
        this.classpathConfigurationLocation = location;
        if (location != null) {
            this.classpathKey = Objects.requireNonNull(key);
            this.classOutputDirectory = Objects.requireNonNull(outputDirectory);
        }
    }

    public void setTempDir(String pathAsString) {
        if (pathAsString != null) {
            this.tempDir = new File(pathAsString);
        }
    }

    public boolean launch() {
        Stopwatch rootStopwatch = Stopwatch.createStarted();
        File stubsDirectory = this.stubsDirectory();
        this.ensureBaseDir();
        this.handleEncoding();
        LOG.info((Object)"Collecting source models.");
        Iterable<String> rootsToTravers = this.rootsToTraverse();
        List<URI> sourceResourceURIs = this.collectResources(this.sourceDirs);
        try {
            File stateFile = this.readOrCreateBuilderState(stubsDirectory);
            HashSet<URI> changedSourceFiles = new HashSet<URI>();
            LinkedHashMap<URI, IResourceDescription.Delta> allDeltas = new LinkedHashMap<URI, IResourceDescription.Delta>();
            this.aggregateDeltas(this.builderState.sourceChanges(sourceResourceURIs, changedSourceFiles), allDeltas);
            HashSet<URI> changedLibraryFiles = new HashSet<URI>();
            List<URI> libraryResourceURIs = Collections.emptyList();
            if (this.builderState.updateLibraryHash(this.hashClasspath(rootsToTravers))) {
                libraryResourceURIs = this.collectResources(rootsToTravers);
                this.aggregateDeltas(this.builderState.libraryChanges(libraryResourceURIs, changedLibraryFiles), allDeltas);
            } else {
                libraryResourceURIs = new ArrayList<URI>(this.builderState.libraryFiles.keySet());
            }
            this.forceDebugLog("Collected source models. Took: " + rootStopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms.");
            if (this.classpathConfigurationLocation != null) {
                this.writeClassPathConfiguration(rootsToTravers, stubsDirectory != null);
            }
            XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
            this.configureWorkspace((ResourceSet)resourceSet);
            Iterable allClassPathEntries = Iterables.concat(this.sourceDirs, this.classPathEntries);
            if (stubsDirectory != null) {
                LOG.info((Object)"Installing type provider.");
                this.installTypeProvider(allClassPathEntries, resourceSet, null);
            }
            IResourceClusteringPolicy strategy = this.getClusteringPolicy();
            this.aggregateDeltas(this.indexResources(resourceSet, changedSourceFiles, changedLibraryFiles, strategy), allDeltas);
            String stubsClasses = this.generateStubs(stubsDirectory, changedSourceFiles, allDeltas);
            if (stubsClasses != null) {
                LOG.info((Object)"Installing type provider for stubs.");
                this.installTypeProvider((Iterable<String>)FluentIterable.from((Iterable)allClassPathEntries).append((Object[])new String[]{stubsClasses}), resourceSet, this.jvmTypeAccess);
            }
            ResourceDescriptionsData index = this.builderState.index;
            boolean hasValidationErrors = false;
            LOG.info((Object)"Validate and generate.");
            while (!changedSourceFiles.isEmpty() || !allDeltas.isEmpty()) {
                this.installSourceLevelURIs((ResourceSet)resourceSet, changedSourceFiles);
                Iterator sourceResourceIterator = changedSourceFiles.iterator();
                while (sourceResourceIterator.hasNext()) {
                    ArrayList<Resource> resources = new ArrayList<Resource>();
                    int clusterIndex = 0;
                    boolean canContinue = true;
                    while (sourceResourceIterator.hasNext() && canContinue) {
                        URI uri = (URI)sourceResourceIterator.next();
                        Resource resource = resourceSet.getResource(uri, true);
                        resources.add(resource);
                        resource.getContents();
                        EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                        IResourceDescription.Manager manager = this.resourceDescriptionManager(resource);
                        IResourceDescription oldDescription = index.getResourceDescription(uri);
                        SerializableResourceDescription newDescription = SerializableResourceDescription.createCopy((IResourceDescription)manager.getResourceDescription(resource));
                        index.addDescription(uri, (IResourceDescription)newDescription);
                        this.aggregateDelta(manager.createDelta(oldDescription, (IResourceDescription)newDescription), allDeltas);
                        boolean bl = hasValidationErrors = this.validate(resource) || hasValidationErrors;
                        if (strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex)) continue;
                        canContinue = false;
                    }
                    if (this.failOnValidationError && hasValidationErrors) {
                        if (this.incremental) {
                            this.builderState.processIssues(this.issueHandler);
                        }
                        return false;
                    }
                    this.generate(resources);
                    if (canContinue) continue;
                    this.clearResourceSet((ResourceSet)resourceSet);
                }
                if (!allDeltas.isEmpty()) {
                    sourceResourceURIs.removeAll(changedSourceFiles);
                    changedSourceFiles.clear();
                    for (URI candidate : sourceResourceURIs) {
                        IResourceDescription description = index.getResourceDescription(candidate);
                        if (!this.resourceDescriptionManager(candidate).isAffected(allDeltas.values(), description, (IResourceDescriptions)index)) continue;
                        changedSourceFiles.add(candidate);
                    }
                    allDeltas.clear();
                    continue;
                }
                changedSourceFiles.clear();
            }
            boolean bl = this.commitBuilderState(stateFile, hasValidationErrors);
            return bl;
        }
        finally {
            this.builderState = null;
            this.configuredFsas.clear();
            LOG.info((Object)("Build took " + rootStopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms."));
        }
    }

    protected void configureWorkspace(ResourceSet resourceSet) {
        ProjectConfigAdapter result = ProjectConfigAdapter.findInEmfObject((Notifier)resourceSet);
        if (result != null) {
            return;
        }
        FileProjectConfig projectConfig = new FileProjectConfig(new File(this.baseDir), this.baseDir);
        for (String sourceDir : this.sourceDirs) {
            projectConfig.addSourceFolder(sourceDir);
        }
        ProjectConfigAdapter.install((ResourceSet)resourceSet, (IProjectConfig)projectConfig);
    }

    private void writeClassPathConfiguration(Iterable<String> modelRoots, boolean classpath) {
        try {
            Throwable throwable;
            File file = new File(this.classpathConfigurationLocation);
            final Properties properties = new Properties();
            if (file.exists()) {
                Throwable throwable2 = null;
                throwable = null;
                try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            String prefix = this.classpathKey + ".";
            properties.entrySet().removeIf(existing -> {
                String key = String.valueOf(existing.getKey());
                return key.startsWith(prefix);
            });
            this.intoProperties(modelRoots, prefix + "model.", properties, true);
            this.intoProperties(this.sourceDirs, prefix + "src.", properties, false);
            if (classpath) {
                this.intoProperties(List.of(this.classOutputDirectory), prefix + "bin.", properties, false);
                this.intoProperties(this.classPathEntries, prefix + "cp.", properties, true);
            }
            throwable = null;
            Object var7_11 = null;
            try (TailWriter writer = new TailWriter((Writer)new FileWriter(file, StandardCharsets.UTF_8), 1);){
                new Properties(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Set<Map.Entry<Object, Object>> entrySet() {
                        TreeSet<Map.Entry<Object, Object>> result = new TreeSet<Map.Entry<Object, Object>>(Comparator.comparing(e -> String.valueOf(e.getKey())));
                        result.addAll(properties.entrySet());
                        return result;
                    }
                }.store((Writer)writer, null);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to write class-path configuration", (Throwable)e);
        }
    }

    private void intoProperties(Iterable<String> values, String prefix, Properties target, boolean hash) {
        int i = 0;
        for (String value : values) {
            String key = prefix + i;
            target.put(key, new File(value).getAbsolutePath());
            if (hash) {
                Path path = new Path(value);
                target.put(key + ".hash", this.classpathInfos.hashClassesOrJar((IPath)path).asString());
            }
            ++i;
        }
        target.put(prefix + "count", String.valueOf(i));
    }

    private String generateStubs(File stubsDirectory, Set<URI> changedSourceFiles, Map<URI, IResourceDescription.Delta> allDeltas) {
        if (stubsDirectory == null) {
            return null;
        }
        this.generateStubs(changedSourceFiles, stubsDirectory);
        CompilerConfiguration configuration = this.compiler.getConfiguration();
        if (this.incremental) {
            configuration.enableIncrementalCompilation(this.createTempDir("state"), event -> this.aggregateDeltas(event, allDeltas));
        }
        String stubsClasses = this.compileStubs(stubsDirectory);
        if (this.incremental) {
            configuration.disableIncrementalCompilation();
        }
        return stubsClasses;
    }

    private File readOrCreateBuilderState(File stubsDirectory) {
        File stateFile;
        if (this.incremental) {
            stateFile = new File(this.createTempDir("state"), "xtext.state");
            this.builderState = StandaloneBuilderState.from(stateFile);
            this.builderState.processOutputDirectories(this.outputDirectories());
            if (stubsDirectory != null) {
                this.builderState.processStubDirectory(stubsDirectory.getAbsolutePath());
            }
        } else {
            stateFile = null;
            this.builderState = new StandaloneBuilderState();
        }
        return stateFile;
    }

    private Iterable<String> rootsToTraverse() {
        ArrayList rootsToTravers = this.classPathEntries;
        if (this.classPathLookUpFilter != null) {
            LOG.info((Object)"Class path look up filter is active.");
            Pattern cpLookUpFilter = Pattern.compile(this.classPathLookUpFilter);
            rootsToTravers = Lists.newArrayList((Iterable)Iterables.filter(this.classPathEntries, root -> cpLookUpFilter.matcher((CharSequence)root).matches()));
            LOG.info((Object)("Investigating " + Iterables.size((Iterable)rootsToTravers) + " of " + Iterables.size(this.classPathEntries) + " class path entries."));
        }
        return rootsToTravers;
    }

    private void handleEncoding() {
        if (this.encoding != null) {
            this.forceDebugLog("Setting encoding.");
            this.fileEncodingSetup(this.languages.values(), this.encoding);
        }
    }

    private void ensureBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("user.dir");
            LOG.warn((Object)("Property baseDir not set. Using '" + this.baseDir + "'"));
        }
    }

    private File stubsDirectory() {
        File stubsDirectory;
        boolean needsJava = IterableExtensions.exists(this.languages.values(), LanguageAccess::isLinksAgainstJava);
        if (needsJava) {
            this.forceDebugLog("Using common types.");
            stubsDirectory = this.createTempDir("stubs");
        } else {
            stubsDirectory = null;
        }
        return stubsDirectory;
    }

    private void installSourceLevelURIs(ResourceSet resourceSet, Collection<URI> changes) {
        HashSet<URI> effectiveSourceLevelUris = new HashSet<URI>();
        for (URI uri : changes) {
            if (!this.isSource(uri)) continue;
            effectiveSourceLevelUris.add(uri);
            Resource resource = resourceSet.getResource(uri, false);
            if (resource == null || !this.isLoadedFromStorage(resource)) continue;
            resourceSet.getResources().remove((Object)resource);
            resource.unload();
        }
        SourceLevelURIsAdapter.setSourceLevelUris((ResourceSet)resourceSet, effectiveSourceLevelUris);
    }

    private boolean isLoadedFromStorage(Resource resource) {
        return resource instanceof StorageAwareResource && ((StorageAwareResource)resource).isLoadedFromStorage();
    }

    private boolean isSource(URI uri) {
        IResourceServiceProvider provider = this.languageAccess(uri).getResourceServiceProvider();
        return provider instanceof IResourceServiceProviderExtension && ((IResourceServiceProviderExtension)provider).isSource(uri);
    }

    private Set<String> outputDirectories() {
        HashSet<String> outputFolders = new HashSet<String>();
        for (LanguageAccess language : this.languages.values()) {
            Map outputConfigs = this.getFileSystemAccess(language).getOutputConfigurations();
            for (OutputConfiguration outputConfig : outputConfigs.values()) {
                outputFolders.addAll(outputConfig.getOutputDirectories());
            }
        }
        return outputFolders;
    }

    private void aggregateDeltas(IResourceDescription.Event event, Map<URI, IResourceDescription.Delta> allDeltas) {
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            this.aggregateDelta(delta, allDeltas);
        }
    }

    private void aggregateDelta(IResourceDescription.Delta delta, Map<URI, IResourceDescription.Delta> allDeltas) {
        URI uri = delta.getUri();
        allDeltas.merge(uri, delta, (prev, current) -> this.resourceDescriptionManager(uri).createDelta(prev.getOld(), current.getNew()));
    }

    private HashCode hashClasspath(Iterable<String> classpathEntries) {
        NameBasedFilter nameFilter = this.dslFileNamePattern();
        ArrayList<Future> hashCodes = new ArrayList<Future>();
        for (String classpathEntry : classpathEntries) {
            Path path = new Path(classpathEntry);
            if ("jar".equalsIgnoreCase(path.getFileExtension())) {
                hashCodes.add(ForkJoinPool.commonPool().submit(() -> this.lambda$5((IPath)path)));
                continue;
            }
            hashCodes.add(ForkJoinPool.commonPool().submit(() -> this.lambda$6((IPath)path, nameFilter)));
        }
        Hasher hasher = BinaryFileHashing.hashFunction().newHasher();
        for (ForkJoinTask forkJoinTask : hashCodes) {
            try {
                hasher.putBytes((byte[])forkJoinTask.get(30L, TimeUnit.SECONDS));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                hasher.putBoolean(false);
            }
        }
        return hasher.hash();
    }

    private byte[] hashDslFiles(IPath path, NameBasedFilter nameFilter) {
        Hasher hasher = BinaryFileHashing.hashFunction().newHasher();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream hasherAsStream = Funnels.asOutputStream((PrimitiveSink)hasher);){
                com.google.common.io.Files.fileTraverser().breadthFirst((Object)path.toFile()).forEach(file -> {
                    if (file.isFile() && nameFilter.matches(URI.createFileURI((String)file.getAbsolutePath()))) {
                        try {
                            Throwable throwable = null;
                            Object var5_7 = null;
                            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream((File)file), 16384);){
                                ByteStreams.copy((InputStream)in, (OutputStream)hasherAsStream);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            hasher.putBoolean(false);
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hasher.hash().asBytes();
    }

    private boolean commitBuilderState(File stateFile, boolean hasValidationErrors) {
        if (this.incremental) {
            this.builderState.to(stateFile);
            return this.builderState.processIssues(this.issueHandler) && !hasValidationErrors;
        }
        return !hasValidationErrors;
    }

    protected IResourceDescription.Event indexResources(XtextResourceSet resourceSet, Collection<URI> sourceResourceURIs, Collection<URI> libraryResourceURIs, IResourceClusteringPolicy strategy) {
        this.compilerPhases.setIndexing((Notifier)resourceSet, true);
        try {
            ArrayList<IResourceDescription.Delta> deltas = new ArrayList<IResourceDescription.Delta>();
            this.indexResources(resourceSet, strategy, sourceResourceURIs, false, deltas);
            this.indexResources(resourceSet, strategy, libraryResourceURIs, true, deltas);
            this.installIndex(resourceSet, this.builderState.index);
            ResourceDescriptionChangeEvent resourceDescriptionChangeEvent = new ResourceDescriptionChangeEvent(deltas);
            return resourceDescriptionChangeEvent;
        }
        finally {
            this.compilerPhases.setIndexing((Notifier)resourceSet, false);
        }
    }

    private void indexResources(XtextResourceSet resourceSet, IResourceClusteringPolicy strategy, Collection<URI> resourceUris, boolean library, List<IResourceDescription.Delta> deltas) {
        Iterator<URI> resourceUriIterator = resourceUris.iterator();
        while (resourceUriIterator.hasNext()) {
            int clusterIndex = 0;
            boolean canContinue = true;
            while (resourceUriIterator.hasNext() && canContinue) {
                URI uri = resourceUriIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                IResourceDescription oldDescription = this.builderState.index.getResourceDescription(uri);
                IResourceDescription.Manager resourceDescriptionManager = this.resourceDescriptionManager(resource);
                IResourceDescription description = resourceDescriptionManager.getResourceDescription(resource);
                IndexResolvedResourceDescription newDescription = new IndexResolvedResourceDescription(description, library);
                this.builderState.index.addDescription(uri, (IResourceDescription)newDescription);
                deltas.add(resourceDescriptionManager.createDelta(oldDescription, (IResourceDescription)newDescription));
                if (strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex)) continue;
                canContinue = false;
            }
            if (canContinue) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
    }

    protected IResourceClusteringPolicy getClusteringPolicy() {
        DisabledClusteringPolicy strategy = null;
        if (this.clusteringConfig != null) {
            LOG.info((Object)"Clustering configured.");
            DynamicResourceClusteringPolicy dynamicResourceClusteringPolicy = new DynamicResourceClusteringPolicy();
            dynamicResourceClusteringPolicy.setMinimumFreeMemory(this.clusteringConfig.getMinimumFreeMemory() * 1024L * 1024L);
            dynamicResourceClusteringPolicy.setMinimumClusterSize(this.clusteringConfig.getMinimumClusterSize());
            dynamicResourceClusteringPolicy.setMinimumPercentFreeMemory(this.clusteringConfig.getMinimumPercentFreeMemory());
            strategy = dynamicResourceClusteringPolicy;
        } else {
            strategy = new DisabledClusteringPolicy();
        }
        return strategy;
    }

    private IResourceDescription.Manager resourceDescriptionManager(Resource resource) {
        if (resource instanceof XtextResource) {
            return ((XtextResource)resource).getResourceServiceProvider().getResourceDescriptionManager();
        }
        return this.resourceDescriptionManager(resource.getURI());
    }

    private IResourceDescription.Manager resourceDescriptionManager(URI uri) {
        return this.languageAccess(uri).getResourceDescriptionManager();
    }

    public void fileEncodingSetup(Collection<LanguageAccess> languages, String encoding) {
        for (LanguageAccess language : languages) {
            IEncodingProvider provider = language.getEncodingProvider();
            if (provider instanceof IEncodingProvider.Runtime) {
                ((IEncodingProvider.Runtime)provider).setDefaultEncoding(encoding);
                continue;
            }
            this.forceDebugLog("Couldn't set encoding '" + encoding + "' for provider '" + String.valueOf(provider) + "'. Only subclasses of IEncodingProvider.Runtime are supported.");
        }
    }

    protected void installIndex(XtextResourceSet resourceSet, ResourceDescriptionsData index) {
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
    }

    protected String compileStubs(File stubsDir) {
        File stubsClasses = this.createTempDir("stub-classes");
        this.compiler.setClassPath(this.classPathEntries);
        LOG.info((Object)("Compiling stubs located in " + stubsDir.getAbsolutePath()));
        ArrayList nonUniqueSources = Lists.newArrayList((Object[])new String[]{stubsDir.getAbsolutePath()});
        if (this.javaSourceDirs != null) {
            Iterables.addAll((Collection)nonUniqueSources, this.javaSourceDirs);
        } else {
            Iterables.addAll((Collection)nonUniqueSources, this.sourceDirs);
        }
        Set<String> sourcesToCompile = this.uniqueEntries(nonUniqueSources);
        for (String outputDir : this.outputDirectories()) {
            sourcesToCompile.remove(new File(outputDir).getAbsolutePath());
        }
        this.forceDebugLog("Compiler source roots: " + Joiner.on((String)",").join(sourcesToCompile));
        IJavaCompiler.CompilationResult result = this.compiler.compile(sourcesToCompile, stubsClasses);
        if (result != null) {
            switch (result) {
                case SKIPPED: {
                    LOG.info((Object)"Nothing to compile. Stubs compilation was skipped.");
                    break;
                }
                case FAILED: {
                    this.forceDebugLog("Stubs compilation finished with errors.");
                    break;
                }
                case SUCCEEDED: {
                    this.forceDebugLog("Stubs compilation successfully finished.");
                    break;
                }
            }
        }
        return stubsClasses.getAbsolutePath();
    }

    protected Set<String> uniqueEntries(Iterable<String> pathes) {
        return (Set)FluentIterable.from(pathes).transform(path -> new File((String)path).getAbsolutePath()).copyInto(new LinkedHashSet());
    }

    protected void generateStubs(Set<URI> sourceResourceURIs, File stubsDir) {
        LOG.info((Object)("Generating stubs into " + stubsDir.getAbsolutePath() + " for " + sourceResourceURIs.size() + " resources"));
        if (this.encoding != null) {
            this.encodingProvider.setDefaultEncoding(this.encoding);
        }
        this.commonFileAccess.setOutputPath("DEFAULT_OUTPUT", stubsDir.getAbsolutePath());
        Iterable resourceURIs = Iterables.filter(sourceResourceURIs, uri -> this.languageAccess((URI)uri).isLinksAgainstJava());
        JavaIoFileSystemAccess casted = (JavaIoFileSystemAccess)this.commonFileAccess;
        for (URI resourceURI : resourceURIs) {
            Runnable r = this.incremental ? this.withCallback(casted, new StandaloneBuilderFileCallback(resourceURI, this.builderState.stubFiles, this.builderState.inputToStubFiles, this.builderState.stubToInputFile)) : Runnables.doNothing();
            this.languageAccess(resourceURI).getStubGenerator().doGenerateStubs((IFileSystemAccess)this.commonFileAccess, this.builderState.index.getResourceDescription(resourceURI));
            r.run();
        }
    }

    private Runnable withCallback(JavaIoFileSystemAccess casted, StandaloneBuilderFileCallback callback) {
        Runnable reset = casted.withCallBack((JavaIoFileSystemAccess.IFileCallback)callback);
        Runnable r = () -> {
            reset.run();
            callback.done();
        };
        return r;
    }

    protected boolean validate(Resource resource) {
        LOG.info((Object)("Validating: '" + resource.getURI().lastSegment() + "'"));
        IIssueHandler issueHandler = this.incremental ? issues -> {
            this.builderState.setIssues(resource.getURI(), issues);
            for (Issue issue : issues) {
                if (issue.getSeverity() != Severity.ERROR) continue;
                return false;
            }
            return true;
        } : this.issueHandler;
        IResourceValidator resourceValidator = this.languageAccess(resource.getURI()).getResourceValidator();
        List validationResult = resourceValidator.validate(resource, CheckMode.ALL, null);
        return !issueHandler.handleIssue(validationResult);
    }

    protected void generate(List<Resource> sourceResources) {
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(CancelIndicator.NullImpl);
        for (Resource resource : sourceResources) {
            StorageAwareResource casted;
            IResourceStorageFacade resourceStorageFacade;
            URI uri = resource.getURI();
            LOG.info((Object)("Starting generator for input: '" + uri.lastSegment() + "'"));
            this.registerCurrentSource(uri);
            LanguageAccess access = this.languageAccess(uri);
            JavaIoFileSystemAccess fileSystemAccess = this.getFileSystemAccess(access);
            Runnable r = this.incremental ? this.withCallback(fileSystemAccess, new StandaloneBuilderFileCallback(uri, this.builderState.outputFiles, this.builderState.inputToOutputFiles, this.builderState.outputToInputFile)) : Runnables.doNothing();
            if (this.isWriteStorageResources() && resource instanceof StorageAwareResource && (resourceStorageFacade = (casted = (StorageAwareResource)resource).getResourceStorageFacade()) != null) {
                resourceStorageFacade.saveResource(casted, (IFileSystemAccessExtension3)fileSystemAccess);
            }
            access.getGenerator().generate(resource, (IFileSystemAccess2)fileSystemAccess, (IGeneratorContext)context);
            r.run();
        }
    }

    protected void registerCurrentSource(URI uri) {
        JavaIoFileSystemAccess fsa = this.getFileSystemAccess(this.languageAccess(uri));
        Iterable folders = Iterables.transform(this.sourceDirs, it -> UriUtil.createFolderURI((File)new File((String)it)));
        URI absoluteSource = (URI)IterableExtensions.findFirst((Iterable)folders, it -> UriUtil.isPrefixOf((URI)it, (URI)uri));
        if (absoluteSource == null) {
            throw new IllegalStateException("Resource " + String.valueOf(uri) + " is not contained in any of the known source folders " + String.valueOf(this.sourceDirs) + ".");
        }
        URI projectBaseURI = UriUtil.createFolderURI((File)new File(this.baseDir));
        fsa.setCurrentSource(null);
        for (OutputConfiguration output : fsa.getOutputConfigurations().values()) {
            for (String sourceFolder : output.getSourceFolders()) {
                URI sourceFolderURI = URI.createURI((String)(sourceFolder + "/"));
                if (sourceFolderURI.isRelative()) {
                    sourceFolderURI = sourceFolderURI.resolve(projectBaseURI);
                }
                if (!absoluteSource.equals(sourceFolderURI)) continue;
                fsa.setCurrentSource(sourceFolder);
            }
        }
    }

    private JavaIoFileSystemAccess getFileSystemAccess(LanguageAccess language) {
        return this.configuredFsas.computeIfAbsent(language, l -> this.configureFileSystemAccess(l.createFileSystemAccess(new File(this.baseDir)), (LanguageAccess)l));
    }

    protected JavaIoFileSystemAccess configureFileSystemAccess(JavaIoFileSystemAccess fsa, LanguageAccess language) {
        return fsa;
    }

    private LanguageAccess languageAccess(URI uri) {
        return this.languages.get(uri.fileExtension());
    }

    protected File createTempDir(String subDir) {
        try {
            File file = new File(this.tempDir, subDir);
            if (!file.mkdirs() && !file.exists()) {
                throw new IOException("Failed to create directory '" + file.getAbsolutePath() + "'");
            }
            return file;
        }
        catch (Throwable e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected void installTypeProvider(Iterable<String> classPathRoots, XtextResourceSet resSet, IndexedJvmTypeAccess typeAccess) {
        URLClassLoader classLoader = this.createURLClassLoader(classPathRoots);
        new ClasspathTypeProvider((ClassLoader)classLoader, (ResourceSet)resSet, typeAccess, null);
        resSet.setClasspathURIContext((Object)classLoader);
    }

    private URLClassLoader createURLClassLoader(Iterable<String> classPathEntries) {
        URL[] classPathUrls = (URL[])FluentIterable.from(classPathEntries).transform(str -> {
            try {
                return new File((String)str).toURI().toURL();
            }
            catch (Throwable e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }).toArray(URL.class);
        return new URLClassLoader(classPathUrls);
    }

    protected List<URI> collectResources(Iterable<String> roots) {
        NameBasedFilter nameBasedFilter = this.dslFileNamePattern();
        ArrayList<URI> resources = new ArrayList<URI>();
        Multimap modelsFound = new PathTraverser().resolvePathes(IterableExtensions.toList(roots), input -> {
            boolean matches = nameBasedFilter.matches(input);
            if (matches) {
                this.forceDebugLog("Adding file '" + String.valueOf(input) + "'");
                resources.add((URI)input);
            }
            return matches;
        });
        modelsFound.asMap().forEach((uri, resource) -> {
            File file = new File((String)uri);
            if (resource != null && !file.isDirectory() && file.getName().endsWith(".jar")) {
                this.registerBundle(file);
            }
        });
        return resources;
    }

    private NameBasedFilter dslFileNamePattern() {
        String extensions = Joiner.on((String)"|").join(this.languages.keySet());
        NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setRegularExpression(".*\\.(?:(" + extensions + "))$");
        return nameBasedFilter;
    }

    protected void registerBundle(File file) {
        block25: {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return;
                }
                String name = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (name == null || name.isBlank()) break block25;
                int indexOf = name.indexOf(";");
                if (indexOf > 0) {
                    name = name.substring(0, indexOf);
                }
                if (EcorePlugin.getPlatformResourceMap().containsKey(name)) {
                    return;
                }
                try {
                    String path = "archive:" + String.valueOf(file.toURI()) + "!/";
                    URI uri = URI.createURI((String)path);
                    EcorePlugin.getPlatformResourceMap().put(name, uri);
                }
                catch (ZipException e) {
                    this.forceDebugLog("Could not open Jar file " + file.getAbsolutePath() + ".");
                }
                catch (Exception e) {
                    LOG.error((Object)file.getAbsolutePath(), (Throwable)e);
                }
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)jarFile, (Throwable)e);
                }
            }
        }
    }

    public IJavaCompiler getCompiler() {
        return this.compiler;
    }

    public void clearResourceSet(ResourceSet resourceSet) {
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            for (Resource resource : resourceSet.getResources()) {
                resource.eSetDeliver(false);
            }
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }

    protected void forceDebugLog(String logMessage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)logMessage);
        } else if (this.debugLog) {
            LOG.info((Object)logMessage);
        }
    }

    public Map<String, LanguageAccess> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Map<String, LanguageAccess> languages) {
        this.languages = languages;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public Iterable<String> getSourceDirs() {
        return this.sourceDirs;
    }

    public void setSourceDirs(Iterable<String> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    public Iterable<String> getJavaSourceDirs() {
        return this.javaSourceDirs;
    }

    public void setJavaSourceDirs(Iterable<String> javaSourceDirs) {
        this.javaSourceDirs = javaSourceDirs;
    }

    public Iterable<String> getClassPathEntries() {
        return this.classPathEntries;
    }

    public void setClassPathEntries(Iterable<String> classPathEntries) {
        this.classPathEntries = classPathEntries;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getClassPathLookUpFilter() {
        return this.classPathLookUpFilter;
    }

    public void setClassPathLookUpFilter(String classPathLookUpFilter) {
        this.classPathLookUpFilter = classPathLookUpFilter;
    }

    public boolean isFailOnValidationError() {
        return this.failOnValidationError;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.failOnValidationError = failOnValidationError;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    public boolean isWriteStorageResources() {
        return this.writeStorageResources;
    }

    public void setWriteStorageResources(boolean writeStorageResources) {
        this.writeStorageResources = writeStorageResources;
    }

    public ClusteringConfig getClusteringConfig() {
        return this.clusteringConfig;
    }

    public void setClusteringConfig(ClusteringConfig clusteringConfig) {
        this.clusteringConfig = clusteringConfig;
    }

    private /* synthetic */ byte[] lambda$5(IPath iPath) throws Exception {
        CoarseGrainedEntryHash archiveEntryHash = (CoarseGrainedEntryHash)this.classpathInfos.hashClassesOrJar(iPath);
        return archiveEntryHash.asBytes();
    }

    private /* synthetic */ byte[] lambda$6(IPath iPath, NameBasedFilter nameBasedFilter) throws Exception {
        return this.hashDslFiles(iPath, nameBasedFilter);
    }

    static class IndexResolvedResourceDescription
    extends ResolvedResourceDescription {
        private final boolean libraryResource;

        public IndexResolvedResourceDescription(IResourceDescription copyMe, boolean libraryResource) {
            super(copyMe);
            this.libraryResource = libraryResource;
        }

        public Iterable<QualifiedName> getImportedNames() {
            if (this.libraryResource) {
                return Collections.emptyList();
            }
            return super.getImportedNames();
        }

        public Iterable<IReferenceDescription> getReferenceDescriptions() {
            if (this.libraryResource) {
                return Collections.emptyList();
            }
            return super.getReferenceDescriptions();
        }
    }
}

