/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.ui.internal.refactoring.RefactoringMessages;

public abstract class FilterChange
extends Change {
    static final int DELETE = 1;
    static final int ADD = 2;
    IApiFilterStore store = null;
    IApiProblemFilter filter = null;
    int kind = 0;

    public FilterChange(IApiFilterStore store, IApiProblemFilter filter, int kind) {
        this.store = store;
        this.filter = filter;
        this.kind = kind;
    }

    protected abstract Change performDelete();

    protected abstract Change performAdd();

    public Change perform(IProgressMonitor pm) throws CoreException {
        switch (this.kind) {
            case 1: {
                return this.performDelete();
            }
            case 2: {
                return this.performAdd();
            }
        }
        return null;
    }

    protected String getAddName() {
        return NLS.bind((String)RefactoringMessages.FilterChange_add_filter, (Object)this.filter.toString());
    }

    protected String getDeleteName() {
        IApiProblem problem = this.filter.getUnderlyingProblem();
        return NLS.bind((String)RefactoringMessages.FilterChange_remove_used_filter, (Object)problem.getMessage());
    }

    public String getName() {
        switch (this.kind) {
            case 2: {
                return this.getAddName();
            }
            case 1: {
                return this.getDeleteName();
            }
        }
        return null;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Object getModifiedElement() {
        return this.filter;
    }
}

