/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.ri.model.dynamic;

import java.util.Locale;
import org.eclipse.rap.e4.apache.jxpath.DynamicPropertyHandler;
import org.eclipse.rap.e4.apache.jxpath.JXPathBeanInfo;
import org.eclipse.rap.e4.apache.jxpath.JXPathIntrospector;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointerFactory;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.NullPointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.dynamic.DynamicPointer;
import org.eclipse.rap.e4.apache.jxpath.util.ValueUtils;

public class DynamicPointerFactory
implements NodePointerFactory {
    public static final int DYNAMIC_POINTER_FACTORY_ORDER = 800;

    @Override
    public int getOrder() {
        return 800;
    }

    @Override
    public NodePointer createNodePointer(QName name, Object bean, Locale locale) {
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean.getClass());
        if (bi.isDynamic()) {
            DynamicPropertyHandler handler = ValueUtils.getDynamicPropertyHandler(bi.getDynamicPropertyHandlerClass());
            return new DynamicPointer(name, bean, handler, locale);
        }
        return null;
    }

    @Override
    public NodePointer createNodePointer(NodePointer parent, QName name, Object bean) {
        if (bean == null) {
            return new NullPointer(parent, name);
        }
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean.getClass());
        if (bi.isDynamic()) {
            DynamicPropertyHandler handler = ValueUtils.getDynamicPropertyHandler(bi.getDynamicPropertyHandlerClass());
            return new DynamicPointer(parent, name, bean, handler);
        }
        return null;
    }
}

