/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rap.examples.IExampleContribution;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.ButtonExamplePage;
import org.eclipse.rap.examples.pages.CanvasExamplePage;
import org.eclipse.rap.examples.pages.DialogExamplePage;
import org.eclipse.rap.examples.pages.FillLayoutExample;
import org.eclipse.rap.examples.pages.GridLayoutExample;
import org.eclipse.rap.examples.pages.InternationalizationExamplePage;
import org.eclipse.rap.examples.pages.ListExample;
import org.eclipse.rap.examples.pages.MarkupExample;
import org.eclipse.rap.examples.pages.MarkupLabelExample;
import org.eclipse.rap.examples.pages.RowLayoutExample;
import org.eclipse.rap.examples.pages.RowTemplateExample;
import org.eclipse.rap.examples.pages.TableViewerExample;
import org.eclipse.rap.examples.pages.TextInputExamplePage;
import org.eclipse.rap.examples.pages.TreeViewerExample;
import org.eclipse.rap.examples.pages.ValidationExamplePage;

class Contributions {
    private final List<IExampleContribution> contributions = new ArrayList<IExampleContribution>();

    Contributions() {
        this.collectContributions();
    }

    List<IExampleContribution> getContibutions() {
        return Collections.unmodifiableList(this.contributions);
    }

    private void collectContributions() {
        this.addContribution("button", "Buttons", ButtonExamplePage.class);
        this.addContribution("rich-label", "Markup Support", MarkupLabelExample.class);
        this.addContribution("input", "Input Widgets", TextInputExamplePage.class);
        this.addContribution("dialog", "Dialogs", DialogExamplePage.class);
        this.addContribution("drag-and-drop", "Drag & Drop", ListExample.class);
        this.addContribution("treeviewer", "TreeViewer", TreeViewerExample.class);
        this.addContribution("tableviewer", "TableViewer", TableViewerExample.class);
        this.addContribution("canvas", "Canvas", CanvasExamplePage.class);
        this.addContribution("row-layout", "Row Layout", RowLayoutExample.class);
        this.addContribution("fill-layout", "Fill Layout", FillLayoutExample.class);
        this.addContribution("grid-layout", "Grid Layout", GridLayoutExample.class);
        this.addContribution("table-markup", "Table with Markup", MarkupExample.class);
        this.addContribution("table-template", "Table with RowTemplate", RowTemplateExample.class);
        this.addContribution("nls", "Internationalization", InternationalizationExamplePage.class);
        this.addContribution("validation", "Input Validation", ValidationExamplePage.class);
    }

    private void addContribution(final String id, final String title, final Class<? extends IExamplePage> clazz) {
        IExampleContribution contribution = new IExampleContribution(){

            public String getId() {
                return id;
            }

            public String getTitle() {
                return title;
            }

            public IExamplePage createPage() {
                try {
                    return (IExamplePage)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to instatiate class " + clazz.getName(), exception);
                }
            }
        };
        this.contributions.add(contribution);
    }
}

