/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.addons.internal.canvas;

import java.io.Serializable;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;

public class GCOperationDispatcher
implements Serializable {
    public static final String PROPERTY_FOREGROUND = "foreground";
    public static final String PROPERTY_LINE_WIDTH = "lineWidth";
    public static final String PROPERTY_PATH = "path";
    private final GC gc;
    private final JsonArray drawings;

    public GCOperationDispatcher(GC gc, String drawings) {
        this.gc = gc;
        this.drawings = JsonArray.readFrom((String)drawings);
    }

    public void dispatch() {
        this.doDispatch();
    }

    private void doDispatch() {
        int lineWidth = this.gc.getLineWidth();
        Color foreground = this.gc.getForeground();
        int alpha = this.gc.getAlpha();
        this.dispatchOperations();
        this.restoreLastSettings(lineWidth, foreground, alpha);
    }

    private void dispatchOperations() {
        int i = 0;
        while (i < this.drawings.size()) {
            JsonArray operation = this.drawings.get(i).asArray();
            this.dispatchOperation(operation);
            ++i;
        }
    }

    private void restoreLastSettings(int lineWidth, Color foreground, int alpha) {
        this.gc.setLineWidth(lineWidth);
        this.gc.setForeground(foreground);
        this.gc.setAlpha(alpha);
    }

    private void dispatchOperation(JsonArray operation) {
        String operationType = operation.get(0).asString();
        JsonArray parameters = operation.get(1).asArray();
        if (PROPERTY_LINE_WIDTH.equals(operationType)) {
            this.dispatchLineWidth(parameters);
        } else if (PROPERTY_FOREGROUND.equals(operationType)) {
            this.dispatchSetForeground(parameters);
        } else if (PROPERTY_PATH.equals(operationType)) {
            this.dispatchDrawPath(parameters);
        }
    }

    private void dispatchLineWidth(JsonArray parameters) {
        int width = parameters.get(0).asInt();
        this.gc.setLineWidth(width);
    }

    private void dispatchSetForeground(JsonArray parameters) {
        int r = parameters.get(0).asInt();
        int g = parameters.get(1).asInt();
        int b = parameters.get(2).asInt();
        int a = parameters.get(3).asInt();
        this.gc.setForeground(new Color(this.gc.getDevice(), new RGB(r, g, b)));
        this.gc.setAlpha(a);
    }

    private void dispatchDrawPath(JsonArray parameters) {
        if (!parameters.isEmpty()) {
            Path path = new Path(this.gc.getDevice());
            GCOperationDispatcher.createWayPoints(parameters, path);
            this.gc.drawPath(path);
        }
    }

    private static void createWayPoints(JsonArray parameters, Path path) {
        path.moveTo(GCOperationDispatcher.getFloatAtIndex(parameters, 0), GCOperationDispatcher.getFloatAtIndex(parameters, 1));
        int i = 2;
        while (i < parameters.size() - 4) {
            path.quadTo(GCOperationDispatcher.getFloatAtIndex(parameters, i), GCOperationDispatcher.getFloatAtIndex(parameters, i + 1), GCOperationDispatcher.getFloatAtIndex(parameters, i + 2), GCOperationDispatcher.getFloatAtIndex(parameters, i + 3));
            i += 4;
        }
    }

    private static float getFloatAtIndex(JsonArray parameters, int index) {
        return Double.valueOf(parameters.get(index).asDouble()).floatValue();
    }
}

