/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;

class AcceleratorBinding
implements Listener {
    private final MenuItem menuItem;
    private int accelerator;

    AcceleratorBinding(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    @Override
    public void handleEvent(Event event) {
        if (this.isRelevantEvent(event) && this.menuItem.isEnabled()) {
            this.menuItem.handleAcceleratorActivation();
            event.type = 0;
        }
    }

    int getAccelerator() {
        return this.accelerator;
    }

    void setAccelerator(int accelerator) {
        if (accelerator != this.accelerator) {
            int oldAccelerator = this.accelerator;
            this.accelerator = accelerator;
            if ((this.menuItem.style & 2) == 0) {
                this.updateDisplayActiveKeys(oldAccelerator, accelerator);
                this.updateDisplayFilter(oldAccelerator, accelerator);
            }
        }
    }

    void release() {
        this.setAccelerator(0);
    }

    private boolean isRelevantEvent(Event event) {
        boolean result = false;
        if (event.type == 1 && (this.accelerator & SWT.MODIFIER_MASK) == event.stateMask) {
            int key = this.accelerator & 0x100FFFF;
            if (event.character == '\u0000') {
                result = event.keyCode == key;
            } else if (key <= 65535) {
                result = Character.toUpperCase(event.character) == Character.toUpperCase((char)key);
            }
        }
        return result;
    }

    private void updateDisplayFilter(int oldAccelerator, int newAccelerator) {
        if (oldAccelerator == 0 && newAccelerator != 0) {
            this.menuItem.display.addFilter(1, this);
        } else if (oldAccelerator != 0 && newAccelerator == 0) {
            this.menuItem.display.removeFilter(1, this);
        }
    }

    private void updateDisplayActiveKeys(int oldAccelerator, int newAccelerator) {
        this.updateDisplayActiveKeys("org.eclipse.rap.rwt.activeKeys", oldAccelerator, newAccelerator);
        this.updateDisplayActiveKeys("org.eclipse.rap.rwt.cancelKeys", oldAccelerator, newAccelerator);
    }

    private void updateDisplayActiveKeys(String keysType, int oldAccelerator, int newAccelerator) {
        String[] oldActiveKeys = (String[])this.menuItem.display.getData(keysType);
        if (oldActiveKeys == null) {
            oldActiveKeys = new String[]{};
        }
        ArrayList<String> activeKeys = new ArrayList<String>(Arrays.asList(oldActiveKeys));
        if (oldAccelerator != 0) {
            activeKeys.remove(AcceleratorBinding.acceleratorAsString(oldAccelerator));
        }
        if (newAccelerator != 0) {
            activeKeys.add(AcceleratorBinding.acceleratorAsString(newAccelerator));
        }
        this.menuItem.display.setData(keysType, activeKeys.toArray(new String[0]));
    }

    private static String acceleratorAsString(int accelerator) {
        String result = "";
        if ((accelerator & 0x10000) != 0) {
            result = String.valueOf(result) + "ALT+";
        }
        if ((accelerator & 0x40000) != 0) {
            result = String.valueOf(result) + "CTRL+";
        }
        if ((accelerator & 0x20000) != 0) {
            result = String.valueOf(result) + "SHIFT+";
        }
        result = String.valueOf(result) + AcceleratorBinding.keyToString(accelerator & 0x100FFFF);
        return result;
    }

    private static String keyToString(int key) {
        return switch (key) {
            case 0x100000A -> "F1";
            case 0x100000B -> "F2";
            case 0x100000C -> "F3";
            case 0x100000D -> "F4";
            case 0x100000E -> "F5";
            case 0x100000F -> "F6";
            case 0x1000010 -> "F7";
            case 0x1000011 -> "F8";
            case 0x1000012 -> "F9";
            case 0x1000013 -> "F10";
            case 0x1000014 -> "F11";
            case 0x1000015 -> "F12";
            case 0x1000009 -> "INSERT";
            case 127 -> "DEL";
            case 0x1000007 -> "HOME";
            case 0x1000008 -> "END";
            case 0x1000001 -> "ARROW_UP";
            case 0x1000002 -> "ARROW_DOWN";
            case 0x1000003 -> "ARROW_LEFT";
            case 0x1000004 -> "ARROW_RIGHT";
            case 0x1000005 -> "PAGE_UP";
            case 0x1000006 -> "PAGE_DOWN";
            case 16777299 -> "NUM_LOCK";
            case 16777300 -> "SCROLL_LOCK";
            case 0x1000055 -> "PAUSE";
            case 16777303 -> "PRINT_SCREEN";
            case 16777298 -> "CAPS_LOCK";
            default -> Character.toString(Character.toUpperCase((char)key));
        };
    }
}

