/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.graphics.ColorUtil;

public class ResourceFactory {
    private final SharedInstanceBuffer<Integer, Color> colors = new SharedInstanceBuffer();
    private final SharedInstanceBuffer<FontData, Font> fonts = new SharedInstanceBuffer();
    private final SharedInstanceBuffer<Integer, Cursor> cursors = new SharedInstanceBuffer();
    private SharedInstanceBuffer.InstanceCreator<Integer, Color> colorCreator = new SharedInstanceBuffer.InstanceCreator<Integer, Color>(){

        @Override
        public Color createInstance(Integer value) {
            return ResourceFactory.createColorInstance(value);
        }
    };
    private SharedInstanceBuffer.InstanceCreator<Integer, Cursor> cursorCreator = new SharedInstanceBuffer.InstanceCreator<Integer, Cursor>(){

        @Override
        public Cursor createInstance(Integer style) {
            return ResourceFactory.createCursorInstance(style);
        }
    };
    private SharedInstanceBuffer.InstanceCreator<FontData, Font> fontCreator = new SharedInstanceBuffer.InstanceCreator<FontData, Font>(){

        @Override
        public Font createInstance(FontData fontData) {
            return ResourceFactory.createFontInstance(fontData);
        }
    };

    public Color getColor(int red, int green, int blue) {
        return this.getColor(red, green, blue, 255);
    }

    public Color getColor(int red, int green, int blue, int alpha) {
        int colorNr = ColorUtil.computeColorNr(red, green, blue, alpha);
        return this.colors.get(colorNr, this.colorCreator);
    }

    public Font getFont(FontData fontData) {
        return this.fonts.get(fontData, this.fontCreator);
    }

    public Cursor getCursor(int style) {
        return this.cursors.get(style, this.cursorCreator);
    }

    private static Color createColorInstance(int colorNr) {
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Object[] paramValues = new Object[]{colorNr};
        return ClassUtil.newInstance(Color.class, paramTypes, paramValues);
    }

    private static Font createFontInstance(FontData fontData) {
        Class[] paramTypes = new Class[]{FontData.class};
        Object[] paramValues = new Object[]{fontData};
        return ClassUtil.newInstance(Font.class, paramTypes, paramValues);
    }

    private static Cursor createCursorInstance(int style) {
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Object[] paramValues = new Object[]{style};
        return ClassUtil.newInstance(Cursor.class, paramTypes, paramValues);
    }
}

