/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.StartupParameters;
import org.eclipse.rap.rwt.internal.remote.ConnectionImpl;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;

public class StartupParametersImpl
implements StartupParameters {
    private Map<String, List<String>> parameters;

    public StartupParametersImpl() {
        ConnectionImpl connection = (ConnectionImpl)RWT.getUISession().getConnection();
        RemoteObject remoteObject = connection.createServiceObject("rwt.client.StartupParameters");
        remoteObject.setHandler(new StartupParametersOperationHandler());
        this.parameters = Collections.emptyMap();
    }

    @Override
    public Collection<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    @Override
    public String getParameter(String name) {
        ParamCheck.notNullOrEmpty(name, "name");
        List<String> values = this.parameters.get(name);
        return values == null ? null : values.get(0);
    }

    @Override
    public List<String> getParameterValues(String name) {
        ParamCheck.notNullOrEmpty(name, "name");
        List<String> values = this.parameters.get(name);
        return values == null ? null : Collections.unmodifiableList(values);
    }

    final class StartupParametersOperationHandler
    extends AbstractOperationHandler {
        StartupParametersOperationHandler() {
        }

        @Override
        public void handleSet(JsonObject properties) {
            JsonValue params = properties.get("parameters");
            if (params != null) {
                StartupParametersImpl.this.parameters = new HashMap<String, List<String>>();
                for (JsonObject.Member member : params.asObject()) {
                    ArrayList<String> stringValues = new ArrayList<String>();
                    for (JsonValue value : member.getValue().asArray()) {
                        stringValues.add(value.asString());
                    }
                    StartupParametersImpl.this.parameters.put(member.getName(), stringValues);
                }
            }
        }
    }
}

