/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.functions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.rap.e4.apache.jxpath.ExpressionContext;
import org.eclipse.rap.e4.apache.jxpath.Function;
import org.eclipse.rap.e4.apache.jxpath.JXPathInvalidAccessException;
import org.eclipse.rap.e4.apache.jxpath.util.TypeUtils;

public class ConstructorFunction
implements Function {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Constructor constructor;

    public ConstructorFunction(Constructor constructor) {
        this.constructor = constructor;
    }

    @Override
    public Object invoke(ExpressionContext context, Object[] parameters) {
        try {
            if (parameters == null) {
                parameters = EMPTY_ARRAY;
            }
            int pi = 0;
            Class<?>[] types = this.constructor.getParameterTypes();
            if (types.length > 0 && ExpressionContext.class.isAssignableFrom(types[0])) {
                pi = 1;
            }
            Object[] args = new Object[parameters.length + pi];
            if (pi == 1) {
                args[0] = context;
            }
            int i = 0;
            while (i < parameters.length) {
                args[i + pi] = TypeUtils.convert(parameters[i], types[i + pi]);
                ++i;
            }
            return this.constructor.newInstance(args);
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            throw new JXPathInvalidAccessException("Cannot invoke constructor " + String.valueOf(this.constructor), ex);
        }
    }
}

