/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Adapters {
    public static <T> T adapt(Object sourceObject, Class<T> adapter, boolean allowActivation) {
        IAdaptable adaptable;
        T result;
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return (T)sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException(adaptable.getClass().getName() + ".getAdapter(" + adapter.getName() + ".class) returned " + result.getClass().getName() + " that is not an instance the requested type");
            }
            return result;
        }
        if (sourceObject instanceof PlatformObject && !allowActivation) {
            return null;
        }
        String adapterId = adapter.getName();
        Object result2 = Adapters.queryAdapterManager(sourceObject, adapterId, allowActivation);
        if (result2 != null) {
            if (!adapter.isInstance(result2)) {
                throw new AssertionFailedException("An adapter factory for " + sourceObject.getClass().getName() + " returned " + result2.getClass().getName() + " that is not an instance of " + adapter.getName());
            }
            return (T)result2;
        }
        return null;
    }

    public static <T> T adapt(Object sourceObject, Class<T> adapter) {
        return Adapters.adapt(sourceObject, adapter, true);
    }

    public static <T> Optional<T> of(Object sourceObject, Class<T> adapter) {
        if (sourceObject == null) {
            return Optional.empty();
        }
        Objects.requireNonNull(adapter);
        try {
            return Optional.ofNullable(Adapters.adapt(sourceObject, adapter));
        }
        catch (AssertionFailedException e) {
            RuntimeLog.log(Status.error(NLS.bind((String)CommonMessages.adapters_internal_error_of, (Object[])new String[]{sourceObject.getClass().getName(), adapter.getClass().getName(), e.getLocalizedMessage()}), e));
            return Optional.empty();
        }
    }

    private static Object queryAdapterManager(Object sourceObject, String adapterId, boolean allowActivation) {
        Object result = allowActivation ? AdapterManager.getDefault().loadAdapter(sourceObject, adapterId) : AdapterManager.getDefault().getAdapter(sourceObject, adapterId);
        return result;
    }
}

