/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.HashMap;
import org.eclipse.rap.demo.controls.BrowserTab;
import org.eclipse.rap.demo.controls.ButtonTab;
import org.eclipse.rap.demo.controls.CBannerTab;
import org.eclipse.rap.demo.controls.CLabelTab;
import org.eclipse.rap.demo.controls.CTabFolderTab;
import org.eclipse.rap.demo.controls.CanvasTab;
import org.eclipse.rap.demo.controls.ClientServicesTab;
import org.eclipse.rap.demo.controls.ClipboardTab;
import org.eclipse.rap.demo.controls.ComboTab;
import org.eclipse.rap.demo.controls.CompositeTab;
import org.eclipse.rap.demo.controls.ContainmentTab;
import org.eclipse.rap.demo.controls.ControlDecorationTab;
import org.eclipse.rap.demo.controls.CoolBarTab;
import org.eclipse.rap.demo.controls.DNDExampleTab;
import org.eclipse.rap.demo.controls.DateTimeTab;
import org.eclipse.rap.demo.controls.DialogsTab;
import org.eclipse.rap.demo.controls.DropDownTab;
import org.eclipse.rap.demo.controls.ErrorHandlingTab;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.ExpandBarTab;
import org.eclipse.rap.demo.controls.FocusTab;
import org.eclipse.rap.demo.controls.GroupTab;
import org.eclipse.rap.demo.controls.LabelTab;
import org.eclipse.rap.demo.controls.LinkTab;
import org.eclipse.rap.demo.controls.ListTab;
import org.eclipse.rap.demo.controls.MnemonicsTab;
import org.eclipse.rap.demo.controls.NLSTab;
import org.eclipse.rap.demo.controls.NebulaGridTab;
import org.eclipse.rap.demo.controls.NebulaRichTextTab;
import org.eclipse.rap.demo.controls.ProgressBarTab;
import org.eclipse.rap.demo.controls.SashFormTab;
import org.eclipse.rap.demo.controls.SashTab;
import org.eclipse.rap.demo.controls.ScaleTab;
import org.eclipse.rap.demo.controls.ScriptingTab;
import org.eclipse.rap.demo.controls.ScrolledCompositeTab;
import org.eclipse.rap.demo.controls.ShellTab;
import org.eclipse.rap.demo.controls.SliderTab;
import org.eclipse.rap.demo.controls.SpinnerTab;
import org.eclipse.rap.demo.controls.TabFolderTab;
import org.eclipse.rap.demo.controls.TableTab;
import org.eclipse.rap.demo.controls.TableViewerTab;
import org.eclipse.rap.demo.controls.TextSizeTab;
import org.eclipse.rap.demo.controls.TextTab;
import org.eclipse.rap.demo.controls.ToolBarTab;
import org.eclipse.rap.demo.controls.ToolTipTab;
import org.eclipse.rap.demo.controls.TreeTab;
import org.eclipse.rap.demo.controls.VariantsTab;
import org.eclipse.rap.demo.controls.ZOrderTab;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.application.AbstractEntryPoint;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.BrowserNavigationEvent;
import org.eclipse.rap.rwt.client.service.BrowserNavigationListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ControlsDemo
extends AbstractEntryPoint {
    private Composite header;
    private Tree tree;
    private Composite exampleParent;
    private Color backgroundColor;

    protected void createContents(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.backgroundColor = new Color((Device)parent.getDisplay(), 49, 97, 156);
        this.header = new Composite(parent, 0);
        this.header.setBackground(this.backgroundColor);
        this.header.setBackgroundMode(1);
        this.header.setLayoutData((Object)this.createLayoutDataForHeader());
        Label label = new Label(this.header, 0);
        label.setText("RAP Controls Demo");
        label.setForeground(parent.getDisplay().getSystemColor(1));
        label.setBounds(40, 30, 250, 30);
        this.tree = new Tree(parent, 65536);
        this.tree.setLayoutData((Object)this.createLayoutDataForTree());
        this.exampleParent = new Composite(parent, 0);
        this.exampleParent.setLayout((Layout)new FillLayout());
        this.exampleParent.setLayoutData((Object)this.createLayoutDataForExampleParent());
        this.fillTree(parent);
    }

    private void fillTree(Composite parent) {
        final HashMap<String, ExampleTab> exampleMap = new HashMap<String, ExampleTab>();
        final BrowserNavigation navigation = (BrowserNavigation)RWT.getClient().getService(BrowserNavigation.class);
        ExampleTab[] exampleTabArray = ControlsDemo.createExampleTabs();
        int n = exampleTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExampleTab tab = exampleTabArray[n2];
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(tab.getName());
            item.setData((Object)tab);
            tab.setData(item);
            exampleMap.put(tab.getId(), tab);
            ++n2;
        }
        this.tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExampleTab tab = (ExampleTab)event.item.getData();
                ControlsDemo.this.selectTab(tab);
                navigation.pushState(tab.getId(), null);
            }
        });
        navigation.addBrowserNavigationListener(new BrowserNavigationListener(){

            public void navigated(BrowserNavigationEvent event) {
                ExampleTab tab = (ExampleTab)exampleMap.get(event.getState());
                if (tab != null) {
                    ControlsDemo.this.tree.select((TreeItem)tab.getData());
                    ControlsDemo.this.tree.showSelection();
                    ControlsDemo.this.selectTab(tab);
                }
            }
        });
        this.selectTab((ExampleTab)this.tree.getItem(0).getData());
    }

    private void selectTab(ExampleTab exampleTab) {
        Control[] children;
        Control[] controlArray = children = this.exampleParent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (exampleTab != null) {
            exampleTab.createContents(this.exampleParent);
        }
        this.exampleParent.layout();
    }

    private FormData createLayoutDataForHeader() {
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.height = 80;
        return layoutData;
    }

    private FormData createLayoutDataForTree() {
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.header, 0);
        layoutData.left = new FormAttachment(0, 0);
        layoutData.bottom = new FormAttachment(100, 0);
        layoutData.width = 190;
        return layoutData;
    }

    private FormData createLayoutDataForExampleParent() {
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.header, 0);
        layoutData.left = new FormAttachment((Control)this.tree, 10);
        layoutData.right = new FormAttachment(100, 0);
        layoutData.bottom = new FormAttachment(100, 0);
        return layoutData;
    }

    private static ExampleTab[] createExampleTabs() {
        return new ExampleTab[]{new ButtonTab(), new BrowserTab(), new CanvasTab(), new CBannerTab(), new CLabelTab(), new ComboTab(), new CompositeTab(), new CoolBarTab(), new CTabFolderTab(), new DateTimeTab(), new DialogsTab(), new DropDownTab(), new ExpandBarTab(), new FocusTab(), new GroupTab(), new LabelTab(), new ListTab(), new LinkTab(), new NebulaGridTab(), new NebulaRichTextTab(), new ProgressBarTab(), new SashTab(), new SashFormTab(), new ScaleTab(), new ScrolledCompositeTab(), new ShellTab(), new SliderTab(), new SpinnerTab(), new TabFolderTab(), new TableTab(), new TableViewerTab(), new TextTab(), new TextSizeTab(), new ToolBarTab(), new ToolTipTab(), new TreeTab(), new ScriptingTab(), new DNDExampleTab(), new ContainmentTab(), new ZOrderTab(), new VariantsTab(), new ControlDecorationTab(), new ClipboardTab(), new ErrorHandlingTab(), new ClientServicesTab(), new NLSTab(), new MnemonicsTab()};
    }
}

