/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ThemingExample
implements IExamplePage {
    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        this.createButtonsArea(parent);
        this.createMenusArea(parent);
    }

    private void createButtonsArea(Composite parent) {
        Group group = ThemingExample.createGroup(parent, "Push Buttons", 3);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        ThemingExample.createButton((Composite)group, "Simple", "simple");
        ThemingExample.createButton((Composite)group, "Pretty", "pretty");
        ThemingExample.createButton((Composite)group, "Fancy", "fancy");
        ThemingExample.createButton((Composite)group, "Simple animated", "simpleAnimated");
        ThemingExample.createButton((Composite)group, "Pretty animated", "prettyAnimated");
        ThemingExample.createButton((Composite)group, "Fancy animated", "fancyAnimated");
    }

    private static Button createButton(Composite parent, String text, String variant) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setToolTipText("Animated ToolTip");
        button.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        GridData layoutData = new GridData(4, 128, true, true);
        layoutData.heightHint = 50;
        button.setLayoutData((Object)layoutData);
        return button;
    }

    private void createMenusArea(Composite parent) {
        Group group = ThemingExample.createGroup(parent, "Menus", 1);
        group.setLayoutData((Object)ExampleUtil.createFillData());
        GridData layoutData = new GridData(4, 128, true, false);
        ToolBar bar = new ToolBar((Composite)group, 2048);
        bar.setData("org.eclipse.rap.rwt.customVariant", (Object)"themingDemo");
        bar.setLayoutData((Object)layoutData);
        ToolItem item = new ToolItem(bar, 4);
        item.setData("org.eclipse.rap.rwt.customVariant", (Object)"themingDemo");
        item.setText("Simple");
        this.addMenu(item, "simple");
        item = new ToolItem(bar, 4);
        item.setData("org.eclipse.rap.rwt.customVariant", (Object)"themingDemo");
        item.setText("Pretty");
        this.addMenu(item, "pretty");
        item = new ToolItem(bar, 4);
        item.setData("org.eclipse.rap.rwt.customVariant", (Object)"themingDemo");
        item.setText("Fancy");
        this.addMenu(item, "fancy");
        bar.pack();
    }

    private void addMenu(final ToolItem toolItem, String variant) {
        final ToolBar toolBar = toolItem.getParent();
        Shell shell = toolBar.getShell();
        final Menu menu = new Menu((Decorations)shell, 8);
        menu.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        int i = 0;
        while (i < 8) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText("Example-Item " + (i + 1));
            item.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
            ++i;
        }
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = toolItem.getBounds();
                Point point = new Point(rect.x, rect.y + rect.height);
                point = toolBar.toDisplay(point);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        });
    }

    private static Group createGroup(Composite parent, String title, int columns) {
        Group group = new Group(parent, 0);
        group.setText(title);
        GridLayout layout = new GridLayout(columns, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 20;
        group.setLayout((Layout)layout);
        return group;
    }
}

