/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.ColorUtil;

public class Color
extends Resource {
    private int colorNr;

    private Color(int colorNr) {
        super(null);
        this.colorNr = colorNr;
    }

    public Color(Device device, RGB rgb) {
        this(device, rgb, 255);
    }

    public Color(Device device, RGB rgb, int alpha) {
        super(Color.checkDevice(device));
        if (rgb == null) {
            SWT.error(4);
        }
        this.colorNr = ColorUtil.computeColorNr(rgb.red, rgb.green, rgb.blue, alpha);
    }

    public Color(Device device, RGBA rgba) {
        super(Color.checkDevice(device));
        if (rgba == null) {
            SWT.error(4);
        }
        this.colorNr = ColorUtil.computeColorNr(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
    }

    public Color(Device device, int red, int green, int blue) {
        this(device, red, green, blue, 255);
    }

    public Color(Device device, int red, int green, int blue, int alpha) {
        super(Color.checkDevice(device));
        this.colorNr = ColorUtil.computeColorNr(red, green, blue, alpha);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.colorNr & 0xFF0000) >> 16;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.colorNr & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.colorNr & 0xFF;
    }

    public int getAlpha() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.colorNr >>> 24;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return (this.colorNr & 0xFFFFFFFF) == (color.colorNr & 0xFFFFFFFF);
    }

    public int hashCode() {
        return this.getRGBA().hashCode();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }
}

