/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.internal.widgets.tabfolderkit.TabFolderThemeAdapter;
import org.eclipse.swt.internal.widgets.tabitemkit.TabItemLCA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    private static final int TABS_SPACING = 1;
    private static final int IMAGE_TEXT_SPACING = 4;
    private final TabFolder parent;
    private Control control;
    private String toolTipText;

    public TabItem(TabFolder parent, int style) {
        super(parent, TabItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, TabItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control._getParent() != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != this.parent.getSelectionIndex()) {
            if (newControl != null) {
                newControl.setVisible(false);
            }
        } else {
            if (newControl != null) {
                newControl.setBounds(this.parent.getClientArea());
                newControl.setVisible(true);
            }
            if (oldControl != null) {
                oldControl.setVisible(false);
            }
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle result = new Rectangle(0, 0, 0, 0);
        int index = this.parent.indexOf(this);
        if (index != -1) {
            Image image;
            String text = this.getText();
            if (text != null) {
                Point extent = TextSizeUtil.stringExtent(this.parent.getFont(), text);
                result.width = extent.x;
                result.height = extent.y;
            }
            if ((image = this.getImage()) != null) {
                Rectangle imageSize = image.getBounds();
                result.width += imageSize.width + 4;
                result.height = Math.max(result.height, imageSize.height);
            }
            TabFolderThemeAdapter themeAdapter = this.parent.getThemeAdapter();
            BoxDimensions padding = themeAdapter.getItemPadding(this);
            BoxDimensions margin = themeAdapter.getItemMargin(this);
            BoxDimensions itemBorder = themeAdapter.getItemBorder(this);
            result.width += itemBorder.left + itemBorder.right + padding.left + padding.right;
            result.height += itemBorder.top + itemBorder.bottom + padding.top + padding.bottom;
            if (this.isBarTop()) {
                result.y = margin.top;
            } else {
                BoxDimensions border = this.parent.getBorder();
                result.y = this.parent.getBounds().height - (border.top + border.bottom) - result.height;
                result.y -= margin.bottom;
            }
            if (index > 0) {
                TabItem prevItem = this.parent.getItem(index - 1);
                Rectangle prevItemBounds = prevItem.getBounds();
                int selectionIndex = this.parent.getSelectionIndex();
                result.x = prevItemBounds.x + prevItemBounds.width + 1;
                if (index == selectionIndex || index - 1 == selectionIndex) {
                    --result.x;
                }
            }
        }
        return result;
    }

    private boolean isBarTop() {
        return (this.parent.getStyle() & 0x400) == 0;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index > -1) {
            super.setImage(image);
        }
    }

    public void setToolTipText(String toolTipText) {
        this.checkWidget();
        if (toolTipText != null && MarkupUtil.isToolTipMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
            MarkupValidator.getInstance().validate(toolTipText);
        }
        this.toolTipText = toolTipText;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    public void setData(String key, Object value) {
        this.handleBadge(key, value);
        if (!"org.eclipse.rap.rwt.tooltipMarkupEnabled".equals(key) || !MarkupUtil.isToolTipMarkupEnabledFor(this)) {
            MarkupUtil.checkMarkupPrecondition(key, MarkupUtil.MarkupTarget.TOOLTIP, () -> this.toolTipText == null);
            super.setData(key, value);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WidgetLCA.class) {
            return (T)TabItemLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    private void handleBadge(String key, Object value) {
        if ("org.eclipse.rap.rwt.badge".equals(key) && value != null && !(value instanceof String)) {
            this.error(5);
        }
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        this.parent.destroyItem(this);
    }

    private static int checkStyle(int style) {
        int result = 0;
        if (style > 0) {
            result = style;
        }
        return result;
    }
}

