/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.osgi.internal;

import org.eclipse.rap.rwt.osgi.ApplicationLauncher;
import org.eclipse.rap.rwt.osgi.internal.ApplicationConfigurationTracker;
import org.eclipse.rap.rwt.osgi.internal.ApplicationLauncherImpl;
import org.eclipse.rap.rwt.osgi.internal.HttpTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ApplicationLauncherImpl applicationLauncher;
    private ServiceRegistration<ApplicationLauncher> applicationLauncherRegistration;
    private HttpTracker httpTracker;
    private ApplicationConfigurationTracker configurationTracker;

    public void start(BundleContext context) {
        this.registerApplicationLauncher(context);
        this.openHttpServiceTracker(context);
        this.openConfiguratorTracker(context);
    }

    public void stop(BundleContext context) {
        this.configurationTracker.close();
        this.httpTracker.close();
        this.applicationLauncherRegistration.unregister();
        this.applicationLauncher.deactivate();
        this.configurationTracker = null;
        this.httpTracker = null;
        this.applicationLauncher = null;
    }

    private void registerApplicationLauncher(BundleContext context) {
        this.applicationLauncher = new ApplicationLauncherImpl(context);
        String name = ApplicationLauncher.class.getName();
        ServiceRegistration<?> registration = this.registerService(context, name);
        this.applicationLauncherRegistration = registration;
    }

    private ServiceRegistration<?> registerService(BundleContext context, String name) {
        return context.registerService(name, (Object)this.applicationLauncher, null);
    }

    private void openConfiguratorTracker(BundleContext context) {
        this.configurationTracker = new ApplicationConfigurationTracker(context, this.applicationLauncher);
        this.configurationTracker.open();
    }

    private void openHttpServiceTracker(BundleContext context) {
        this.httpTracker = new HttpTracker(context, this.applicationLauncher);
        this.httpTracker.open();
    }
}

