/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ConfigurationDictionary
extends Dictionary<String, Object>
implements Serializable {
    private static final long serialVersionUID = -3583299578203095532L;
    private static final Collection<Class<?>> simples = Arrays.asList(String.class, Integer.class, Long.class, Float.class, Double.class, Byte.class, Short.class, Character.class, Boolean.class);
    private static final Collection<Class<?>> simpleArrays = Arrays.asList(String[].class, Integer[].class, Long[].class, Float[].class, Double[].class, Byte[].class, Short[].class, Character[].class, Boolean[].class);
    private static final Collection<Class<?>> primitiveArrays = Arrays.asList(long[].class, int[].class, short[].class, char[].class, byte[].class, double[].class, float[].class, boolean[].class);
    protected final Map<String, Object> configurationProperties = Collections.synchronizedMap(new TreeMap(new CaseInsensitiveStringComparator()));

    private static void validateValue(Object value) {
        Class<?> clazz = value.getClass();
        if (simples.contains(clazz)) {
            return;
        }
        if (simpleArrays.contains(clazz) || primitiveArrays.contains(clazz)) {
            return;
        }
        if (value instanceof Collection) {
            for (Object simple : (Collection)value) {
                Class<?> containedClazz = simple.getClass();
                if (simples.contains(containedClazz)) continue;
                throw new IllegalArgumentException(String.valueOf(containedClazz.getName()) + " in " + clazz.getName());
            }
            return;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    @Override
    public Enumeration<Object> elements() {
        return new Enumeration<Object>(){
            final Iterator<Object> valuesIterator;
            {
                this.valuesIterator = ConfigurationDictionary.this.configurationProperties.values().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.valuesIterator.hasNext();
            }

            @Override
            public Object nextElement() {
                return this.valuesIterator.next();
            }
        };
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.configurationProperties.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.configurationProperties.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return new Enumeration<String>(){
            Iterator<String> keysIterator;
            {
                this.keysIterator = ConfigurationDictionary.this.configurationProperties.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.keysIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return this.keysIterator.next();
            }
        };
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        ConfigurationDictionary.validateValue(value);
        return this.configurationProperties.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.configurationProperties.remove(key);
    }

    @Override
    public int size() {
        return this.configurationProperties.size();
    }

    ConfigurationDictionary copy() {
        ConfigurationDictionary result = new ConfigurationDictionary();
        for (Map.Entry<String, Object> entry : this.configurationProperties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                Object copyOfArray = Array.newInstance(value.getClass().getComponentType(), arrayLength);
                System.arraycopy(value, 0, copyOfArray, 0, arrayLength);
                result.configurationProperties.put(key, copyOfArray);
                continue;
            }
            if (value instanceof Collection) {
                result.configurationProperties.put(key, new ArrayList((Collection)value));
                continue;
            }
            result.configurationProperties.put(key, value);
        }
        return result;
    }

    static class CaseInsensitiveStringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 6501536810492374044L;

        CaseInsensitiveStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareToIgnoreCase(s2);
        }
    }
}

