/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treeitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ITreeItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.internal.widgets.treeitemkit.TreeItemOperationHandler;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeItemLCA
extends WidgetLCA<TreeItem> {
    public static final TreeItemLCA INSTANCE = new TreeItemLCA();
    private static final String TYPE = "rwt.widgets.GridItem";
    static final String PROP_INDEX = "index";
    static final String PROP_ITEM_COUNT = "itemCount";
    static final String PROP_TEXTS = "texts";
    static final String PROP_IMAGES = "images";
    static final String PROP_CELL_BACKGROUNDS = "cellBackgrounds";
    static final String PROP_CELL_FOREGROUNDS = "cellForegrounds";
    static final String PROP_CELL_FONTS = "cellFonts";
    static final String PROP_EXPANDED = "expanded";
    static final String PROP_CHECKED = "checked";
    static final String PROP_GRAYED = "grayed";
    private static final String PROP_CACHED = "cached";
    private static final int DEFAULT_ITEM_COUNT = 0;

    @Override
    public void preserveValues(TreeItem item) {
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_INDEX, TreeItemLCA.getIndex(item));
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_CACHED, TreeItemLCA.isCached(item));
        if (TreeItemLCA.isCached(item)) {
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_ITEM_COUNT, item.getItemCount());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXTS, TreeItemLCA.getTexts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGES, TreeItemLCA.getImages(item));
            WidgetLCAUtil.preserveBackground(item, TreeItemLCA.getUserBackground(item));
            WidgetLCAUtil.preserveForeground(item, TreeItemLCA.getUserForeground(item));
            WidgetLCAUtil.preserveFont(item, TreeItemLCA.getUserFont(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_BACKGROUNDS, TreeItemLCA.getCellBackgrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_FOREGROUNDS, TreeItemLCA.getCellForegrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_FONTS, TreeItemLCA.getCellFonts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_EXPANDED, item.getExpanded());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CHECKED, item.getChecked());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_GRAYED, item.getGrayed());
        }
    }

    @Override
    public void renderInitialization(TreeItem item) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(item, TYPE);
        remoteObject.setHandler(new TreeItemOperationHandler(item));
        Widget parent = item.getParentItem() == null ? item.getParent() : item.getParentItem();
        remoteObject.set("parent", WidgetUtil.getId(parent));
    }

    @Override
    public void renderChanges(final TreeItem item) throws IOException {
        WidgetLCAUtil.renderProperty((Widget)item, PROP_INDEX, TreeItemLCA.getIndex(item), -1);
        if (TreeItemLCA.wasCleared(item)) {
            TreeItemLCA.renderClear(item);
        } else if (TreeItemLCA.isCached(item)) {
            TreeItemLCA.preservingInitialized(item, new Runnable(){

                @Override
                public void run() {
                    if (!TreeItemLCA.wasCached(item)) {
                        TreeItemLCA.setInitialized(item, false);
                    }
                    TreeItemLCA.renderProperties(item);
                }
            });
        }
    }

    private static void renderClear(TreeItem item) {
        RemoteObjectFactory.getRemoteObject(item).call("clear", null);
    }

    private static void renderProperties(TreeItem item) {
        WidgetLCAUtil.renderProperty((Widget)item, PROP_ITEM_COUNT, item.getItemCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_TEXTS, TreeItemLCA.getTexts(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGES, TreeItemLCA.getImages(item), null);
        WidgetLCAUtil.renderBackground(item, TreeItemLCA.getUserBackground(item));
        WidgetLCAUtil.renderForeground(item, TreeItemLCA.getUserForeground(item));
        WidgetLCAUtil.renderFont(item, TreeItemLCA.getUserFont(item));
        WidgetLCAUtil.renderCustomVariant(item);
        WidgetLCAUtil.renderData(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_BACKGROUNDS, TreeItemLCA.getCellBackgrounds(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_FOREGROUNDS, TreeItemLCA.getCellForegrounds(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_FONTS, TreeItemLCA.getCellFonts(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_EXPANDED, item.getExpanded(), false);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CHECKED, item.getChecked(), false);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_GRAYED, item.getGrayed(), false);
    }

    @Override
    public void renderDispose(TreeItem item) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(item);
        if (!TreeItemLCA.getTreeItemAdapter(item).isParentDisposed()) {
            remoteObject.destroy();
        } else {
            ((RemoteObjectImpl)remoteObject).markDestroyed();
        }
    }

    private static int getIndex(TreeItem item) {
        int result = item.getParentItem() == null ? item.getParent().indexOf(item) : item.getParentItem().indexOf(item);
        return result;
    }

    private static boolean wasCleared(TreeItem item) {
        return !TreeItemLCA.isCached(item) && TreeItemLCA.wasCached(item);
    }

    private static boolean isCached(TreeItem item) {
        return item.getParent().getAdapter(ITreeAdapter.class).isCached(item);
    }

    private static boolean wasCached(TreeItem item) {
        RemoteAdapter adapter = WidgetUtil.getAdapter(item);
        if (adapter.isInitialized()) {
            return Boolean.TRUE.equals(adapter.getPreserved(PROP_CACHED));
        }
        return false;
    }

    private static String[] getTexts(TreeItem item) {
        return TreeItemLCA.getTreeItemAdapter(item).getTexts();
    }

    private static Image[] getImages(TreeItem item) {
        return TreeItemLCA.getTreeItemAdapter(item).getImages();
    }

    private static Color getUserBackground(TreeItem item) {
        return item.getAdapter(IWidgetColorAdapter.class).getUserBackground();
    }

    private static Color getUserForeground(TreeItem item) {
        return item.getAdapter(IWidgetColorAdapter.class).getUserForeground();
    }

    private static Font getUserFont(TreeItem item) {
        return item.getAdapter(IWidgetFontAdapter.class).getUserFont();
    }

    private static Color[] getCellBackgrounds(TreeItem item) {
        return TreeItemLCA.getTreeItemAdapter(item).getCellBackgrounds();
    }

    private static Color[] getCellForegrounds(TreeItem item) {
        return TreeItemLCA.getTreeItemAdapter(item).getCellForegrounds();
    }

    private static Font[] getCellFonts(TreeItem item) {
        return TreeItemLCA.getTreeItemAdapter(item).getCellFonts();
    }

    private static ITreeItemAdapter getTreeItemAdapter(TreeItem item) {
        return item.getAdapter(ITreeItemAdapter.class);
    }

    private static void preservingInitialized(TreeItem item, Runnable runnable) {
        boolean initialized = WidgetUtil.getAdapter(item).isInitialized();
        runnable.run();
        TreeItemLCA.setInitialized(item, initialized);
    }

    private static void setInitialized(TreeItem item, boolean initialized) {
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)WidgetUtil.getAdapter(item);
        adapter.setInitialized(initialized);
    }

    private TreeItemLCA() {
    }
}

