/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jmdns.impl.DNSEntry;

public class DNSCache {
    private int size;
    private final HashMap hashtable;

    public DNSCache(int size) {
        this.hashtable = new HashMap(size);
    }

    public synchronized void clear() {
        this.hashtable.clear();
        this.size = 0;
    }

    public synchronized void add(DNSEntry entry) {
        CacheNode newValue = new CacheNode(entry);
        CacheNode node = (CacheNode)this.hashtable.get(entry.getName());
        if (node == null) {
            this.hashtable.put(entry.getName(), newValue);
        } else {
            newValue.next = node.next;
            node.next = newValue;
        }
        ++this.size;
    }

    public synchronized boolean remove(DNSEntry entry) {
        CacheNode node = (CacheNode)this.hashtable.get(entry.getName());
        if (node != null) {
            if (node.value == entry) {
                if (node.next == null) {
                    this.hashtable.remove(entry.getName());
                } else {
                    this.hashtable.put(entry.getName(), node.next);
                }
                --this.size;
                return true;
            }
            CacheNode previous = node;
            node = node.next;
            while (node != null) {
                if (node.value == entry) {
                    previous.next = node.next;
                    --this.size;
                    return true;
                }
                previous = node;
                node = node.next;
            }
        }
        return false;
    }

    public synchronized DNSEntry get(DNSEntry entry) {
        CacheNode node = this.find(entry.getName());
        while (node != null) {
            if (node.value.equals(entry)) {
                return node.value;
            }
            node = node.next;
        }
        return null;
    }

    public synchronized DNSEntry get(String name, int type, int clazz) {
        CacheNode node = this.find(name);
        while (node != null) {
            if (node.value.type == type && node.value.clazz == clazz) {
                return node.value;
            }
            node = node.next;
        }
        return null;
    }

    public synchronized Iterator iterator() {
        return new ArrayList(this.hashtable.values()).iterator();
    }

    public synchronized CacheNode find(String name) {
        return (CacheNode)this.hashtable.get(name);
    }

    public synchronized void print() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            CacheNode n = (CacheNode)i.next();
            while (n != null) {
                System.out.println(n.value);
                n = n.next;
            }
        }
    }

    public synchronized String toString() {
        StringBuffer aLog = new StringBuffer();
        aLog.append("\t---- cache ----");
        Iterator i = this.iterator();
        while (i.hasNext()) {
            CacheNode n = (CacheNode)i.next();
            while (n != null) {
                aLog.append("\n\t\t" + n.value);
                n = n.next;
            }
        }
        return aLog.toString();
    }

    public static class CacheNode {
        private final DNSEntry value;
        private CacheNode next;

        public CacheNode(DNSEntry value) {
            this.value = value;
        }

        public CacheNode next() {
            return this.next;
        }

        public DNSEntry getValue() {
            return this.value;
        }
    }
}

