/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class NULLRecord
extends Record {
    private byte[] data;

    NULLRecord() {
    }

    public NULLRecord(Name name, int dclass, long ttl, byte[] data) {
        super(name, 10, dclass, ttl);
        if (data.length > 65535) {
            throw new IllegalArgumentException("data must be <65536 bytes");
        }
        this.data = data;
    }

    @Override
    protected void rrFromWire(DNSInput in) {
        this.data = in.readByteArray();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no defined text format for NULL records");
    }

    @Override
    protected String rrToString() {
        return NULLRecord.unknownToString(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.data);
    }
}

