/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.hosts;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public final class HostsFileParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HostsFileParser.class);
    private static final int MAX_FULL_CACHE_FILE_SIZE_BYTES = 16384;
    private final Map<String, InetAddress> hostsCache = new HashMap<String, InetAddress>();
    private final Path path;
    private final boolean clearCacheOnChange;
    private Instant lastFileReadTime = Instant.MIN;
    private boolean isEntireFileParsed;

    public HostsFileParser() {
        this(System.getProperty("os.name").contains("Windows") ? Paths.get(System.getenv("SystemRoot"), "\\System32\\drivers\\etc\\hosts") : Paths.get("/etc/hosts", new String[0]), true);
    }

    public HostsFileParser(Path path) {
        this(path, true);
    }

    public HostsFileParser(Path path, boolean clearCacheOnChange) {
        this.path = Objects.requireNonNull(path, "path is required");
        this.clearCacheOnChange = clearCacheOnChange;
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("path must be a file");
        }
    }

    public synchronized Optional<InetAddress> getAddressForHost(Name name, int type) throws IOException {
        Objects.requireNonNull(name, "name is required");
        if (type != 1 && type != 28) {
            throw new IllegalArgumentException("type can only be A or AAAA");
        }
        this.validateCache();
        InetAddress cachedAddress = this.hostsCache.get(this.key(name, type));
        if (cachedAddress != null) {
            return Optional.of(cachedAddress);
        }
        if (this.isEntireFileParsed || !Files.exists(this.path, new LinkOption[0])) {
            return Optional.empty();
        }
        if (Files.size(this.path) <= 16384L) {
            this.parseEntireHostsFile();
        } else {
            this.searchHostsFileForEntry(name, type);
        }
        return Optional.ofNullable(this.hostsCache.get(this.key(name, type)));
    }

    private void parseEntireHostsFile() throws IOException {
        int lineNumber = 0;
        try (BufferedReader hostsReader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
            String line;
            while ((line = hostsReader.readLine()) != null) {
                LineData lineData;
                if ((lineData = this.parseLine(++lineNumber, line)) == null) continue;
                for (Name name : lineData.names) {
                    InetAddress lineAddress = InetAddress.getByAddress(name.toString(true), lineData.address);
                    this.hostsCache.putIfAbsent(this.key(name, lineData.type), lineAddress);
                }
            }
        }
        this.isEntireFileParsed = true;
    }

    /*
     * Unable to fully structure code
     */
    private void searchHostsFileForEntry(Name name, int type) throws IOException {
        block10: {
            lineNumber = 0;
            hostsReader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);
            block6: while (true) {
                line = hostsReader.readLine();
                if (line != null) {
                    if ((lineData = this.parseLine(++lineNumber, line)) == null) continue;
                    var7_8 = lineData.names.iterator();
                    while (true) {
                        if (var7_8.hasNext()) ** break;
                        continue block6;
                        lineName = var7_8.next();
                        isSearchedEntry = lineName.equals(name);
                        if (!isSearchedEntry || type != lineData.type) continue;
                        lineAddress = InetAddress.getByAddress(lineName.toString(true), lineData.address);
                        this.hostsCache.putIfAbsent(this.key(lineName, lineData.type), lineAddress);
                        return;
                    }
                }
                break block10;
                break;
            }
            finally {
                if (hostsReader != null) {
                    hostsReader.close();
                }
            }
        }
    }

    private LineData parseLine(int lineNumber, String line) {
        String[] lineTokens = this.getLineTokens(line);
        if (lineTokens.length < 2) {
            return null;
        }
        int lineAddressType = 1;
        byte[] lineAddressBytes = Address.toByteArray(lineTokens[0], 1);
        if (lineAddressBytes == null) {
            lineAddressBytes = Address.toByteArray(lineTokens[0], 2);
            lineAddressType = 28;
        }
        if (lineAddressBytes == null) {
            log.warn("Could not decode address {}, {}#L{}", new Object[]{lineTokens[0], this.path, lineNumber});
            return null;
        }
        Iterable lineNames = Arrays.stream(lineTokens).skip(1L).map(lineTokenName -> this.safeName((String)lineTokenName, lineNumber)).filter(Objects::nonNull)::iterator;
        return new LineData(lineAddressType, lineAddressBytes, lineNames);
    }

    private Name safeName(String name, int lineNumber) {
        try {
            return Name.fromString(name, Name.root);
        }
        catch (TextParseException e) {
            log.warn("Could not decode name {}, {}#L{}, skipping", new Object[]{name, this.path, lineNumber});
            return null;
        }
    }

    private String[] getLineTokens(String line) {
        int commentStart = line.indexOf(35);
        if (commentStart == -1) {
            commentStart = line.length();
        }
        return line.substring(0, commentStart).trim().split("\\s+");
    }

    private void validateCache() throws IOException {
        if (this.clearCacheOnChange) {
            Instant fileTime;
            Instant instant = fileTime = Files.exists(this.path, new LinkOption[0]) ? Files.getLastModifiedTime(this.path, new LinkOption[0]).toInstant() : Instant.MAX;
            if (fileTime.isAfter(this.lastFileReadTime)) {
                if (!this.hostsCache.isEmpty()) {
                    log.info("Local hosts database has changed at {}, clearing cache", (Object)fileTime);
                    this.hostsCache.clear();
                }
                this.isEntireFileParsed = false;
                this.lastFileReadTime = fileTime;
            }
        }
    }

    private String key(Name name, int type) {
        return name.toString() + '\t' + type;
    }

    int cacheSize() {
        return this.hostsCache.size();
    }

    private static final class LineData {
        final int type;
        final byte[] address;
        final Iterable<? extends Name> names;

        @Generated
        public LineData(int type, byte[] address, Iterable<? extends Name> names) {
            this.type = type;
            this.address = address;
            this.names = names;
        }
    }
}

