/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceTypeID;
import org.eclipse.ecf.provider.dnssd.DnsSdNamespace;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public class DnsSdServiceTypeID
extends ServiceTypeID
implements IServiceTypeID {
    private static final long serialVersionUID = 1247933069737880365L;

    DnsSdServiceTypeID() {
        super((Namespace)new DnsSdNamespace());
        this.scopes = DEFAULT_SCOPE;
        this.protocols = DEFAULT_PROTO;
        this.namingAuthority = "iana";
        this.services = new String[]{""};
    }

    public DnsSdServiceTypeID(Namespace ns, IServiceTypeID id) {
        super(ns, id);
    }

    public DnsSdServiceTypeID(Namespace namespace, String aType) throws IDCreateException {
        super(namespace, aType);
    }

    DnsSdServiceTypeID(Namespace namespace, Name aName) {
        super(namespace, aName.toString());
    }

    Lookup[] getInternalQueries() {
        String[] protos = this.protocols;
        int type = 33;
        String service = null;
        if (this.services == null || this.services.length == 0 || this.services.length == 1 && this.services[0].equals("")) {
            service = "_services._dns-sd._";
            protos = new String[]{"udp"};
            type = 12;
        } else {
            service = "_";
            int i = 0;
            while (i < this.services.length) {
                service = String.valueOf(service) + this.services[i];
                service = String.valueOf(service) + "._";
                ++i;
            }
        }
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        int i = 0;
        while (i < this.scopes.length) {
            String scope = this.scopes[i];
            if (scope.endsWith(".")) {
                scope = scope.substring(0, scope.length() - 1);
            }
            int j = 0;
            while (j < protos.length) {
                block8: {
                    Lookup query;
                    try {
                        query = new Lookup(String.valueOf(service) + protos[j] + "." + scope + ".", type);
                    }
                    catch (TextParseException e) {
                        break block8;
                    }
                    result.add(query);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new Lookup[result.size()]);
    }

    void setSearchPath(Name[] searchPaths) {
        String[] s = new String[searchPaths.length];
        int i = 0;
        while (i < searchPaths.length) {
            s[i] = searchPaths[i].toString();
            ++i;
        }
        this.setSearchPath(s);
    }

    void setSearchPath(String[] searchPaths) {
        this.scopes = searchPaths;
    }

    String[] getSearchPath() {
        return this.scopes;
    }

    void addSearchPath(String[] additionalSearchPaths) {
        List<String> coll1 = Arrays.asList(this.scopes);
        List<String> coll2 = Arrays.asList(additionalSearchPaths);
        HashSet<String> s = new HashSet<String>();
        s.addAll(coll1);
        s.addAll(coll2);
        this.scopes = s.toArray(new String[s.size()]);
    }
}

