/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery;

import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.internal.discovery.DiscoveryNamespace;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class DiscoveryPlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.discovery";
    private static DiscoveryPlugin plugin;
    private BundleContext context;
    private AdapterManagerTracker adapterManagerTracker;
    private ServiceTracker logServiceTracker = null;

    public DiscoveryPlugin() {
        plugin = this;
    }

    public IAdapterManager getAdapterManager() {
        if (this.adapterManagerTracker == null) {
            this.adapterManagerTracker = new AdapterManagerTracker(this.context);
            this.adapterManagerTracker.open();
        }
        return this.adapterManagerTracker.getAdapterManager();
    }

    public LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void start(final BundleContext ctxt) throws Exception {
        this.context = ctxt;
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(this.context){

            protected void runWithoutRegistry() throws Exception {
                ctxt.registerService(Namespace.class, (Object)new DiscoveryNamespace("Discovery Namespace"), null);
            }
        });
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        plugin = null;
        this.context = null;
    }

    public static synchronized DiscoveryPlugin getDefault() {
        if (plugin == null) {
            plugin = new DiscoveryPlugin();
        }
        return plugin;
    }

    public static boolean isStopped() {
        return plugin == null;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }
}

