/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.AbstractContainer;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.BaseContainerInstantiator;
import org.eclipse.ecf.core.security.IConnectContext;

public class BaseContainer
extends AbstractContainer {
    private ID id = null;

    protected BaseContainer(long idl) throws ContainerCreateException {
        try {
            this.id = IDFactory.getDefault().createLongID(idl);
        }
        catch (IDCreateException e) {
            throw new ContainerCreateException("Could not create ID for basecontainer", e);
        }
    }

    protected BaseContainer(ID id) {
        Assert.isNotNull((Object)id);
        this.id = id;
    }

    @Override
    public void connect(ID targetID, IConnectContext connectContext) throws ContainerConnectException {
        throw new ContainerConnectException("Connect not supported");
    }

    @Override
    public void disconnect() {
    }

    @Override
    public Namespace getConnectNamespace() {
        return null;
    }

    @Override
    public ID getConnectedID() {
        return null;
    }

    public ID getID() {
        return this.id;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BaseContainer[");
        sb.append("id=").append(this.getID()).append("]");
        return sb.toString();
    }

    public static class Instantiator
    extends BaseContainerInstantiator {
        public static final String NAME = "ecf.base";
        private static long nextBaseContainerID = 0L;

        @Override
        public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
            try {
                if (parameters != null && parameters.length > 0) {
                    if (parameters[0] instanceof ID) {
                        return new BaseContainer((ID)parameters[0]);
                    }
                    if (parameters[0] instanceof String) {
                        return new BaseContainer(IDFactory.getDefault().createStringID((String)parameters[0]));
                    }
                }
            }
            catch (IDCreateException e) {
                throw new ContainerCreateException("Could not create ID for basecontainer");
            }
            return new BaseContainer(nextBaseContainerID++);
        }

        @Override
        public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
            return this.getInterfacesAndAdaptersForClass(BaseContainer.class);
        }

        @Override
        public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
            return new Class[][]{new Class[0], {ID.class}, {String.class}};
        }
    }
}

