/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.node.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.provider.zookeeper.core.DiscoverdService;
import org.eclipse.ecf.provider.zookeeper.core.internal.Localizer;
import org.eclipse.ecf.provider.zookeeper.core.internal.Notification;
import org.eclipse.ecf.provider.zookeeper.node.internal.ReadRoot;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.eclipse.ecf.provider.zookeeper.util.PrettyPrinter;

public class NodeReader
implements Watcher,
AsyncCallback.DataCallback {
    private String path;
    private DiscoverdService discovered;
    private ZooKeeper zookeeper;
    private String ip;
    boolean isNodePublished;
    private boolean isDisposed;
    private ReadRoot readRoot;

    public NodeReader(String path, ReadRoot readRoot) {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)readRoot);
        this.readRoot = readRoot;
        this.path = path;
        this.zookeeper = readRoot.getReadKeeper();
        this.ip = readRoot.getIp();
        this.zookeeper.getData(this.getAbsolutePath(), (Watcher)this, (AsyncCallback.DataCallback)this, null);
        this.zookeeper.exists(this.getAbsolutePath(), (Watcher)this, null, null);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        return "/zoodiscovery_root/" + this.getPath();
    }

    public synchronized void processResult(int rc, String p, Object ctx, byte[] data, Stat stat) {
        if (p == null || !p.equals(this.getAbsolutePath()) || data == null) {
            return;
        }
        ObjectInputStream objin = null;
        ByteArrayInputStream bain = null;
        Map serviceData = null;
        try {
            bain = new ByteArrayInputStream(data);
            objin = new ObjectInputStream(bain);
            try {
                serviceData = (Map)objin.readObject();
            }
            catch (ClassNotFoundException e) {
                Logger.log(1, "NodeReader.processResult: " + e.getMessage(), e);
            }
            if (serviceData == null || serviceData.isEmpty()) {
                return;
            }
            try {
                this.discovered = new DiscoverdService(this.getPath(), serviceData);
                this.readRoot.getDiscoverdServices().put(this.discovered.getServiceID().getServiceTypeID().getName(), this.discovered);
                Logger.log(4, PrettyPrinter.prompt(5, this.discovered), null);
                Localizer.getSingleton().localize(new Notification(this.discovered, 1));
            }
            catch (IOException e) {
                Logger.log(4, e.getMessage(), e);
            }
        }
        finally {
            if (objin != null) {
                try {
                    objin.close();
                }
                catch (IOException iOException) {}
            }
            if (bain != null) {
                try {
                    bain.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void process(WatchedEvent event) {
        if (this.isDisposed) {
            return;
        }
        if (event.getState() == Watcher.Event.KeeperState.Disconnected || event.getState() == Watcher.Event.KeeperState.Expired || event.getType() == Watcher.Event.EventType.NodeDeleted) {
            this.dispose();
        }
    }

    public synchronized void dispose() {
        if (this.isDisposed || this.discovered == null) {
            return;
        }
        if (this.readRoot.getDiscoverdServices().remove(this.discovered.getServiceID().getServiceTypeID().getName()) != null) {
            this.discovered.dispose();
            this.isDisposed = true;
        }
    }
}

