/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RouterHelper;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class BorderItemObliqueRouter
extends ObliqueRouter {
    private static int OFFSET = 15;

    private int reversePosition(int position) {
        int newPosition = position;
        if (position == 4) {
            newPosition = 1;
        } else if (position == 1) {
            newPosition = 4;
        } else if (position == 8) {
            newPosition = 16;
        } else if (position == 16) {
            newPosition = 8;
        }
        return newPosition;
    }

    protected int getBorderFigurePosition(IFigure borderFigure) {
        LayoutManager layoutManager;
        Object layoutConstraint;
        IFigure child = borderFigure;
        IFigure parent = borderFigure.getParent();
        if (parent != null && parent.getLayoutManager() != null && (layoutConstraint = (layoutManager = parent.getLayoutManager()).getConstraint(child)) instanceof IBorderItemLocator) {
            return ((IBorderItemLocator)layoutConstraint).getCurrentSideOfParent();
        }
        return 0;
    }

    protected Rectangle getObstacle(IFigure figure, Connection conn, boolean isBorderItem) {
        IFigure parent = null;
        parent = isBorderItem ? this.getBorderItemParent(figure) : figure;
        Rectangle rect = parent.getBounds().getCopy();
        parent.translateToAbsolute((Translatable)rect);
        conn.translateToRelative((Translatable)rect);
        return rect;
    }

    protected IFigure getBorderItemParent(IFigure figure) {
        return figure.getParent().getParent();
    }

    private Point getPointOffsetFromRectangle(Rectangle rectangle, int position, int offset) {
        Point p = this.getMiddlePointFromPosition(rectangle, position);
        this.offsetPointBasedOnPosition(p, position, offset);
        return p;
    }

    private Point getMiddlePointFromPosition(Rectangle rectangle, int position) {
        if (position == 4) {
            return rectangle.getBottom();
        }
        if (position == 1) {
            return rectangle.getTop();
        }
        if (position == 8) {
            return rectangle.getLeft();
        }
        if (position == 16) {
            return rectangle.getRight();
        }
        return rectangle.getCenter();
    }

    private void offsetPointBasedOnPosition(Point point, int direction, int offset) {
        if (direction == 4) {
            point.y += offset;
        } else if (direction == 1) {
            point.y -= offset;
        } else if (direction == 8) {
            point.x -= offset;
        } else if (direction == 16) {
            point.x += offset;
        }
    }

    private void avoidOverlappingWithParent(Point startPoint, Point endPoint, Rectangle sourceParentRect, Rectangle targetParentRect, PointList line, Connection conn, int offset) {
        ShortestPathRouter router = new ShortestPathRouter();
        Path path = new Path(startPoint, endPoint);
        router.addPath(path);
        if (sourceParentRect.contains(targetParentRect)) {
            router.addObstacle(targetParentRect);
        } else if (targetParentRect.contains(sourceParentRect)) {
            router.addObstacle(sourceParentRect);
        } else {
            router.addObstacle(sourceParentRect);
            router.addObstacle(targetParentRect);
        }
        router.setSpacing(offset);
        router.solve();
        line.removeAllPoints();
        line.addAll(path.getPoints());
    }

    private void getVerticesForBorderItemConnection(Rectangle sourceRect, Rectangle targetRect, int sourcePosition, int targetPosition, Rectangle sourceParentRect, Rectangle targetParentRect, Connection conn, PointList newLine, int offset) {
        if (sourcePosition != 0) {
            newLine.setPoint(this.getPointOffsetFromRectangle(sourceRect, sourcePosition, offset), 0);
        }
        if (targetPosition != 0) {
            newLine.setPoint(this.getPointOffsetFromRectangle(targetRect, targetPosition, offset), newLine.size() - 1);
        }
        this.avoidOverlappingWithParent(newLine.getFirstPoint(), newLine.getLastPoint(), sourceParentRect, targetParentRect, newLine, conn, offset);
        if (sourcePosition != 0) {
            newLine.insertPoint(this.getMiddlePointFromPosition(sourceRect, sourcePosition), 0);
        }
        if (targetPosition != 0) {
            newLine.addPoint(this.getMiddlePointFromPosition(targetRect, targetPosition));
        }
    }

    private boolean checkBorderItemConnection(Connection conn, PointList newLine) {
        Rectangle targetParentRect;
        IFigure source = conn.getSourceAnchor().getOwner();
        IFigure target = conn.getTargetAnchor().getOwner();
        int sourcePosition = this.getBorderFigurePosition(source);
        int targetPosition = this.getBorderFigurePosition(target);
        if (sourcePosition == 0 && targetPosition == 0) {
            return false;
        }
        Rectangle sourceParentRect = this.getObstacle(source, conn, sourcePosition != 0);
        if (!sourceParentRect.equals((Object)(targetParentRect = this.getObstacle(target, conn, targetPosition != 0)))) {
            if (sourceParentRect.contains(targetParentRect)) {
                sourcePosition = this.reversePosition(sourcePosition);
            } else if (targetParentRect.contains(sourceParentRect)) {
                targetPosition = this.reversePosition(targetPosition);
            }
        }
        if (newLine == null) {
            return false;
        }
        PrecisionRectangle sourceRect = new PrecisionRectangle(source.getBounds());
        source.translateToAbsolute((Translatable)sourceRect);
        conn.translateToRelative((Translatable)sourceRect);
        PrecisionRectangle targetRect = new PrecisionRectangle(target.getBounds());
        target.translateToAbsolute((Translatable)targetRect);
        conn.translateToRelative((Translatable)targetRect);
        if (sourceRect.intersects((Rectangle)targetRect) && !sourceRect.contains((Rectangle)targetRect) && !targetRect.contains((Rectangle)sourceRect)) {
            return false;
        }
        if (newLine.size() < 3) {
            PrecisionPoint sourceAnchorPoint = new PrecisionPoint(conn.getSourceAnchor().getLocation(conn.getTargetAnchor().getReferencePoint()));
            PrecisionPoint targetAnchorPoint = new PrecisionPoint(conn.getTargetAnchor().getLocation(conn.getSourceAnchor().getReferencePoint()));
            conn.translateToRelative((Translatable)sourceAnchorPoint);
            conn.translateToRelative((Translatable)targetAnchorPoint);
            PointList connLine = new PointList();
            connLine.addPoint((Point)sourceAnchorPoint);
            connLine.addPoint((Point)targetAnchorPoint);
            boolean sourceOk = false;
            boolean targetOk = false;
            targetOk = !sourceParentRect.equals((Object)targetParentRect);
            sourceOk = targetOk;
            if (!sourceOk || !(targetOk &= !(sourceOk &= sourcePosition == 0 || sourceParentRect.contains(targetParentRect) || !sourceParentRect.contains(connLine.getFirstPoint()) && !PointListUtilities.findIntersections(connLine, PointListUtilities.createPointsFromRect(sourceParentRect), new PointList(), new PointList())) || targetPosition == 0 || targetParentRect.contains(sourceParentRect) || !targetParentRect.contains(connLine.getLastPoint()) && !PointListUtilities.findIntersections(connLine, PointListUtilities.createPointsFromRect(targetParentRect), new PointList(), new PointList()))) {
                PrecisionPoint offsetPt = new PrecisionPoint();
                offsetPt.setPreciseX((double)OFFSET);
                if (!RouterHelper.getInstance().isFeedback(conn)) {
                    offsetPt = (PrecisionPoint)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)offsetPt);
                }
                int offset = offsetPt.x;
                this.getVerticesForBorderItemConnection((Rectangle)sourceRect, (Rectangle)targetRect, sourcePosition, targetPosition, sourceParentRect, targetParentRect, conn, newLine, offset);
                return true;
            }
        }
        return false;
    }

    @Override
    protected PointList calculateBendPoints(Connection conn) {
        IFigure source = conn.getSourceAnchor().getOwner();
        IFigure target = conn.getTargetAnchor().getOwner();
        if (source == null || target == null || this.isAvoidingObstructions(conn) || this.isClosestDistance(conn)) {
            return super.calculateBendPoints(conn);
        }
        PointList newLine = RouterHelper.getInstance().routeFromConstraint(conn);
        if (this.checkBorderItemConnection(conn, newLine)) {
            return newLine;
        }
        return super.calculateBendPoints(conn);
    }
}

