/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

public final class EMFCompareJavaPredicates {
    public static Predicate<Diff> possiblyConflictingWith(Diff diff) {
        return new ConflictCandidateFilter(diff);
    }

    public static Predicate<? super Diff> ofKind(final DifferenceKind ... kind) {
        return new Predicate<Diff>(){

            @Override
            public boolean test(Diff input) {
                if (input != null) {
                    return Arrays.asList(kind).contains((Object)input.getKind());
                }
                return false;
            }
        };
    }

    public static Predicate<Diff> onFeature(EStructuralFeature feature) {
        return new OnFeature(feature);
    }

    public static Predicate<Diff> valueMatches(final IEqualityHelper helper, final Object value) {
        return new Predicate<Diff>(){

            @Override
            public boolean test(Diff input) {
                if (input instanceof ReferenceChange) {
                    return helper.matchingValues(value, ((ReferenceChange)input).getValue());
                }
                if (input instanceof AttributeChange) {
                    return helper.matchingValues(value, ((AttributeChange)input).getValue());
                }
                if (input instanceof FeatureMapChange) {
                    return helper.matchingValues(value, ((FeatureMap.Entry)((FeatureMapChange)input).getValue()).getValue());
                }
                return false;
            }
        };
    }

    private static final class ConflictCandidateFilter
    implements Predicate<Diff> {
        private final Diff diff;

        ConflictCandidateFilter(Diff diff) {
            this.diff = Objects.requireNonNull(diff);
        }

        @Override
        public boolean test(Diff input) {
            return !(input instanceof ResourceLocationChange) && this.canConflictWith(input);
        }

        private boolean canConflictWith(Diff other) {
            if (this.diff == other || this.diff.getSource() == other.getSource()) {
                return false;
            }
            Conflict conflict = this.diff.getConflict();
            boolean canConflict = false;
            if (conflict == null || !conflict.getDifferences().contains((Object)other)) {
                canConflict = this.diff.getMatch() != other.getMatch() && other instanceof ReferenceChange && ((ReferenceChange)other).getReference().isContainment() ? !ComparisonUtil.isDeleteOrUnsetDiff(other) : true;
            }
            return canConflict;
        }
    }

    private static class OnFeature
    implements Predicate<Diff> {
        private final EStructuralFeature feature;

        OnFeature(EStructuralFeature feature) {
            this.feature = (EStructuralFeature)Preconditions.checkNotNull((Object)feature);
        }

        @Override
        public boolean test(Diff input) {
            if (input == null) {
                return false;
            }
            boolean apply = false;
            if (input instanceof ReferenceChange) {
                apply = ((ReferenceChange)input).getReference() == this.feature;
            } else if (input instanceof AttributeChange) {
                apply = ((AttributeChange)input).getAttribute() == this.feature;
            } else if (input instanceof FeatureMapChange) {
                apply = ((FeatureMapChange)input).getAttribute() == this.feature;
            }
            return apply;
        }
    }
}

