/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.CharSequenceInputStream;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.IResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class ResourceWriteOperation
implements IResourceWriteOperation {
    private final IFile m_file;
    private final CharSequence m_content;

    protected ResourceWriteOperation(IFile file, CharSequence content) {
        this.m_file = (IFile)Ensure.notNull((Object)file, (CharSequence)"File cannot be null", (Object[])new Object[0]);
        this.m_content = (CharSequence)Ensure.notNull((Object)content, (CharSequence)"File content cannot be null", (Object[])new Object[0]);
    }

    @Override
    public IFile getFile() {
        return this.m_file;
    }

    @Override
    public void accept(EclipseProgress progress) {
        progress.init(3, "Write {}", this.m_file.getProjectRelativePath());
        try {
            if (ResourceWriteOperation.areContentsEqual(this.m_file, this.m_content)) {
                return;
            }
            progress.setWorkRemaining(2);
            this.writeFile(progress.newChild(2));
        }
        catch (IOException | CoreException e) {
            SdkLog.error((CharSequence)"could not store '{}'.", (Object[])new Object[]{this.m_file.getProjectRelativePath(), e});
        }
    }

    protected void writeFile(EclipseProgress progress) throws IOException, CoreException {
        String charsetName = this.m_file.getCharset();
        try (CharSequenceInputStream stream = new CharSequenceInputStream(this.m_content, charsetName);){
            if (!this.m_file.exists()) {
                ResourceWriteOperation.mkdirs((IResource)this.m_file.getParent(), (IProgressMonitor)progress.newChild(1).monitor());
                this.m_file.create((InputStream)stream, true, (IProgressMonitor)progress.newChild(1).monitor());
            } else {
                IStatus result = S2eUtils.makeCommittable(Collections.singletonList(this.m_file));
                if (result.isOK()) {
                    this.m_file.setContents((InputStream)stream, true, true, (IProgressMonitor)progress.newChild(2).monitor());
                } else {
                    SdkLog.warning((CharSequence)"Unable to make all resources committable. Save will be skipped.", (Object[])new Object[]{new CoreException(result)});
                }
            }
        }
    }

    public static boolean areContentsEqual(IFile file, CharSequence newContent) {
        boolean bl;
        block9: {
            if (file == null || !file.exists()) {
                return false;
            }
            InputStream in = file.getContents();
            try {
                StringBuilder fileContent = Strings.fromInputStream((InputStream)in, (String)file.getCharset());
                bl = Strings.equals((CharSequence)fileContent, (CharSequence)newContent);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CoreException e) {
                    SdkLog.warning((CharSequence)"Unable to read contents of file '{}'.", (Object[])new Object[]{file, e});
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    public static void mkdirs(IResource dir, IProgressMonitor monitor) throws CoreException {
        if (dir.getType() != 2) {
            return;
        }
        if (!dir.getParent().exists()) {
            ResourceWriteOperation.mkdirs((IResource)dir.getParent(), monitor);
        }
        if (!dir.exists()) {
            ((IFolder)dir).create(true, false, monitor);
        }
    }

    @Override
    public IResource getAffectedResource() {
        IFile curResource;
        for (curResource = this.m_file; curResource != null && !curResource.exists(); curResource = curResource.getParent()) {
        }
        return curResource;
    }

    public String toString() {
        return "Write " + String.valueOf(this.m_file.getProjectRelativePath());
    }
}

