/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.RootXMLContentHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.ecore.EcoreASResourceFactory;
import org.eclipse.ocl.pivot.internal.library.RegisteredContribution;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.ResourceSetAwareASResourceFactory;

public class OCLASResourceFactory
extends ResourceSetAwareASResourceFactory {
    private static @Nullable OCLASResourceFactory CONTENT_TYPE_INSTANCE = null;
    public static @NonNull ASRegistry<@NonNull StandardLibraryContribution> REGISTRY = new ASRegistry();
    private static final @NonNull ContentHandler PIVOT_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.ocl.oclas", new String[]{"oclas"}, "xmi", "http://www.eclipse.org/ocl/2015/Pivot", null);

    static {
        OCLASResourceFactory.installContentHandler(0, PIVOT_CONTENT_HANDLER);
    }

    public static synchronized @NonNull OCLASResourceFactory getInstance() {
        if (CONTENT_TYPE_INSTANCE == null) {
            CONTENT_TYPE_INSTANCE = OCLASResourceFactory.getInstances("org.eclipse.ocl.oclas", "oclas", null, OCLASResourceFactory.class);
        }
        assert (CONTENT_TYPE_INSTANCE != null);
        return CONTENT_TYPE_INSTANCE;
    }

    public OCLASResourceFactory() {
        this((ResourceSet)null);
    }

    protected OCLASResourceFactory(@Nullable ResourceSet resourceSet) {
        super("org.eclipse.ocl.oclas", "oclas", resourceSet);
    }

    @Override
    public Resource createResource(URI uri) {
        assert (uri != null);
        StandardLibraryContribution standardLibraryContribution = REGISTRY.get(uri);
        if (standardLibraryContribution != null) {
            return standardLibraryContribution.getResource();
        }
        return super.createResource(uri);
    }

    @Override
    protected @Nullable ASResourceFactory createResourceSetAwareASResourceFactory(@NonNull ResourceSet csResourceSet) {
        return new ResourceSetAware(csResourceSet);
    }

    @Override
    public @NonNull ASResourceFactory getASResourceFactory() {
        return OCLASResourceFactory.getInstance();
    }

    @Override
    protected @NonNull URI getCSuri(@NonNull URI uri) {
        return uri.trimFileExtension();
    }

    public static class ASRegistry<@NonNull C extends RegisteredContribution<C>> {
        private final @NonNull Map<@NonNull URI, C> map = new HashMap<URI, C>();

        public @Nullable C get(@NonNull URI key) {
            @Nullable RegisteredContribution contribution = (RegisteredContribution)this.map.get(key);
            return contribution != null ? (C)contribution.getContribution() : null;
        }

        public @Nullable C put(@NonNull URI key, @NonNull C contribution) {
            return (C)((RegisteredContribution)this.map.put(key, contribution));
        }

        public @Nullable C remove(@NonNull URI key) {
            return (C)((RegisteredContribution)this.map.remove(key));
        }

        public int size() {
            return this.map.size();
        }
    }

    public static class ResourceSetAware
    extends OCLASResourceFactory {
        public ResourceSetAware(@NonNull ResourceSet csResourceSet) {
            super(csResourceSet);
        }

        @Override
        public Resource createResource(URI uri) {
            URI nonASuri;
            String nonASextension;
            ASResourceFactory asResourceFactory;
            assert (uri != null);
            StandardLibraryContribution standardLibraryContribution = (StandardLibraryContribution)REGISTRY.get(uri);
            if (standardLibraryContribution != null) {
                return standardLibraryContribution.getResource();
            }
            if (uri.isPlatform() || uri.isFile() || uri.isArchive()) {
                assert (this.resourceSet != null);
                if (this.resourceSet.getURIConverter().exists(uri, null)) {
                    return super.createResource(uri);
                }
            }
            ASResourceFactory aSResourceFactory = asResourceFactory = (nonASextension = (nonASuri = uri.trimFileExtension()).fileExtension()) != null ? ASResourceFactoryRegistry.INSTANCE.getASResourceFactoryForExtension(nonASextension) : null;
            if (asResourceFactory == null) {
                asResourceFactory = EcoreASResourceFactory.getInstance();
            }
            assert (!(asResourceFactory instanceof OCLASResourceFactory));
            return asResourceFactory.createResource(uri);
        }
    }
}

