/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.pagedesigner.PDPlugin;

public final class PageDesignerTraceOptions {
    public static final boolean ENABLED;
    public static final boolean TRACE_CONVERTERLOAD;
    public static final boolean TRACE_CONVERTERSELECT;
    public static final boolean TRACE_ELEMENTEDITLOAD;
    public static final boolean TRACE_ELEMENTEDITSELECTION;
    private static final String KEY_DEBUG_ENABLED = "/debug";
    private static final String KEY_CONVERTER = "/debug/converter";
    private static final String KEY_CONVERTER_LOAD = "/debug/converter/load";
    private static final String KEY_CONVERTER_SELECTION = "/debug/converter/selection";
    private static final String KEY_ELEMENTEDIT = "/debug/elementedit";
    private static final String KEY_ELEMENTEDIT_LOAD = "/debug/elementedit/load";
    private static final String KEY_ELEMENTEDIT_SELECTION = "/debug/elementedit/selection";

    static {
        String pluginId = PDPlugin.getPluginId();
        ENABLED = PageDesignerTraceOptions.getBooleanOption(pluginId + KEY_DEBUG_ENABLED);
        if (ENABLED) {
            TRACE_CONVERTERLOAD = PageDesignerTraceOptions.getBooleanOption(pluginId + KEY_CONVERTER_LOAD);
            TRACE_CONVERTERSELECT = PageDesignerTraceOptions.getBooleanOption(pluginId + KEY_CONVERTER_SELECTION);
            TRACE_ELEMENTEDITLOAD = PageDesignerTraceOptions.getBooleanOption(pluginId + KEY_ELEMENTEDIT_LOAD);
            TRACE_ELEMENTEDITSELECTION = PageDesignerTraceOptions.getBooleanOption(pluginId + KEY_ELEMENTEDIT_SELECTION);
        } else {
            TRACE_CONVERTERLOAD = false;
            TRACE_CONVERTERSELECT = false;
            TRACE_ELEMENTEDITLOAD = false;
            TRACE_ELEMENTEDITSELECTION = false;
        }
    }

    private static boolean getBooleanOption(String key) {
        Boolean enabled = Boolean.valueOf(Platform.getDebugOption((String)key));
        return enabled != null ? enabled : false;
    }

    public static void log(String message) {
        System.out.println(message);
    }

    public static void log(String msg, Throwable t) {
        System.out.printf("%s: Exception Trace:\n\n", msg);
        t.printStackTrace(System.out);
        System.out.print("\n\n\n");
    }

    private PageDesignerTraceOptions() {
    }
}

