/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.node;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.node.PluggableValidator;
import org.eclipse.jpt.common.utility.model.Model;

public interface Node
extends Model {
    public static final String DIRTY_BRANCH_PROPERTY = "dirtyBranch";
    public static final String BRANCH_PROBLEMS_LIST = "branchProblems";
    public static final String HAS_BRANCH_PROBLEMS_PROPERTY = "hasBranchProblems";
    public static final String COMMENT_PROPERTY = "comment";
    public static final Validator NULL_VALIDATOR = new PluggableValidator(PluggableValidator.Delegate.Null.instance());

    public Node getParent();

    public Iterator<Node> children();

    public Node root();

    public boolean isDescendantOf(Node var1);

    public void addBranchReferencesTo(Collection<Reference> var1);

    public void addAllNodesTo(Collection<Node> var1);

    public void nodeRemoved(Node var1);

    public void nodeRenamed(Node var1);

    public boolean isDirtyBranch();

    public void markBranchDirty();

    public void markEntireBranchDirty();

    public void markBranchCleanIfPossible();

    public void cascadeMarkEntireBranchClean();

    public Validator getValidator();

    public void setValidator(Validator var1);

    public void validateBranch();

    public boolean validateBranchInternal();

    public ListIterator<Problem> branchProblems();

    public int branchProblemsSize();

    public boolean hasBranchProblems();

    public boolean containsBranchProblem(Problem var1);

    public void rebuildBranchProblems();

    public void addBranchProblemsTo(List<Problem> var1);

    public void clearAllBranchProblems();

    public boolean clearAllBranchProblemsInternal();

    public String comment();

    public void setComment(String var1);

    public String displayString();

    public static interface Problem {
        public Node source();

        public String messageKey();

        public Object[] messageArguments();

        public int messageType();

        public boolean equals(Object var1);

        public int hashCode();
    }

    public static interface Reference {
        public Node source();

        public Node target();
    }

    public static interface Validator {
        public void validate();

        public void pause();

        public void resume();
    }
}

