/*
 * Copyright 2015-2025 the original author or authors.
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v2.0 which
 * accompanies this distribution and is available at
 *
 * https://www.eclipse.org/legal/epl-v20.html
 */

package org.junit.platform.engine.support.hierarchical;

import static org.apiguardian.api.API.Status.MAINTAINED;

import org.apiguardian.api.API;
import org.opentest4j.TestAbortedException;

/**
 * Specialization of {@link ThrowableCollector} that treats instances of
 * {@link TestAbortedException} as <em>aborting</em>.
 *
 * @since 1.3
 * @see ThrowableCollector
 */
@API(status = MAINTAINED, since = "1.3")
public class OpenTest4JAwareThrowableCollector extends ThrowableCollector {

	public OpenTest4JAwareThrowableCollector() {
		super(TestAbortedException.class::isInstance);
	}

}
