/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public class PredefinedAnchorsActions<C extends IControlInfo> {
    private static final String IMAGE_PREFIX = "info/layout/FormLayout/assistant/";
    private final IFormLayoutInfo<C> m_layout;

    public PredefinedAnchorsActions(IFormLayoutInfo<C> layout) {
        this.m_layout = layout;
    }

    public void contributeActions(C widget, IContributionManager manager) {
        List<IControlInfo> selection = Arrays.asList(widget);
        this.contributeActions(selection, manager);
    }

    public void contributeActions(List<C> selection, IContributionManager manager) {
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topLeft, "top_left.gif", 9));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topRight, "top_right.gif", 12));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_bottomLeft, "bottom_left.gif", 33));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_bottomRight, "bottom_right.gif", 36));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_leftRightTop, "top_left_right.gif", 13));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_leftRightBottom, "bottom_left_right.gif", 37));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topBottomLeft, "top_bottom_left.gif", 41));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topBottomRight, "top_bottom_right.gif", 44));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_TopBottomLeftRight, "top_bottom_left_right.gif", 45));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topLeftRelative, "top_left_relative.gif", 9, true));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topRightRelative, "top_right_relative.gif", 12, true));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_bottomLeftRelative, "bottom_left_relative.gif", 33, true));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_bottomRightRelative, "bottom_right_relative.gif", 36, true));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topLeftRightRelative, "top_left_right_relative.gif", 13, true));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_bottomLeftRightRelative, "bottom_left_right_relative.gif", 37, true));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topBottomRightRelative, "top_bottom_right_relative.gif", 44, true));
        manager.add(new SetCornerAnchorsAction(selection, ModelMessages.PredefinedAnchorsActions_topBottomLeftRelative, "top_bottom_left_relative.gif", 41, true));
    }

    private final class SetCornerAnchorsAction<C1 extends IControlInfo>
    extends ObjectInfoAction {
        private final int m_alignment;
        private final List<C> m_widgets;
        private final boolean m_relative;

        private SetCornerAnchorsAction(List<C> selection, String text, String imageName, int alignment) {
            this(selection, text, imageName, alignment, false);
        }

        private SetCornerAnchorsAction(List<C> selection, String text, String imageName, int alignment, boolean relative) {
            super(PredefinedAnchorsActions.this.m_layout.getUnderlyingModel(), text, Activator.getImageDescriptor(PredefinedAnchorsActions.IMAGE_PREFIX + imageName));
            this.m_widgets = selection;
            this.m_alignment = alignment;
            this.m_relative = relative;
        }

        protected void runEx() throws Exception {
            for (IControlInfo widget : this.m_widgets) {
                PredefinedAnchorsActions.this.m_layout.setQuickAnchors(widget, this.m_alignment, this.m_relative);
            }
        }
    }
}

