/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.layout;

import java.text.MessageFormat;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.AbstractHeaderLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.gef.FormLayoutEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.edit.RowHeaderEditPart;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.selection.RowSelectionEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;

public final class RowsLayoutEditPolicy
extends AbstractHeaderLayoutEditPolicy {
    private final FormLayoutEditPolicy m_mainPolicy;
    private final FormLayoutInfo m_layout;
    private final IFigure m_insertFeedback = AbstractGridLayoutEditPolicy.createInsertFigure();
    private TextFeedback m_feedback;
    private Command m_moveCommand;

    public RowsLayoutEditPolicy(FormLayoutEditPolicy mainPolicy, FormLayoutInfo layout) {
        super((LayoutEditPolicy)mainPolicy);
        this.m_mainPolicy = mainPolicy;
        this.m_layout = layout;
    }

    protected void decorateChild(EditPart child) {
        child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new RowSelectionEditPolicy((LayoutEditPolicy)this.m_mainPolicy));
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        if (!this.m_layout.canChangeDimensions()) {
            return null;
        }
        return this.m_moveCommand;
    }

    protected void showLayoutTargetFeedback(Request request) {
        FormRowInfo row;
        int y;
        int index;
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        RowHeaderEditPart headerEditPart = (RowHeaderEditPart)((Object)changeBoundsRequest.getEditParts().get(0));
        DropRequest dropRequest = (DropRequest)request;
        Point location = dropRequest.getLocation().getCopy();
        RowHeaderEditPart target = null;
        for (EditPart editPart : this.getHost().getChildren()) {
            RowHeaderEditPart rowEditPart = (RowHeaderEditPart)editPart;
            Rectangle bounds = rowEditPart.getFigure().getBounds();
            if (location.y >= bounds.getCenter().y) continue;
            target = rowEditPart;
            break;
        }
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        int x1 = columnIntervals[0].begin() - 5;
        int x2 = columnIntervals[columnIntervals.length - 1].end() + 5;
        int size = 5;
        if (target != null) {
            FormRowInfo prevRow;
            index = target.getIndex();
            y = rowIntervals[index].begin() - size / 2;
            row = this.m_layout.getRows().get(index);
            if (row.isGap()) {
                y = rowIntervals[index].begin();
                size = rowIntervals[index].length() + 1;
            } else if (index != 0 && (prevRow = this.m_layout.getRows().get(index - 1)).isGap()) {
                y = rowIntervals[index - 1].begin();
                size = rowIntervals[index - 1].length() + 1;
                --index;
            }
        } else {
            index = this.m_layout.getRows().size();
            this.m_mainPolicy.showInsertFeedbacks(null, null);
            y = rowIntervals[rowIntervals.length - 1].end() - size / 2;
        }
        this.m_mainPolicy.showInsertFeedbacks(new Rectangle(x1, y, x2 - x1, size), null);
        if (this.m_insertFeedback.getParent() == null) {
            this.addFeedback(this.m_insertFeedback);
        }
        Point offset = headerEditPart.getOffset();
        Rectangle bounds = new Rectangle(0, y + offset.y, this.getHostFigure().getSize().width, size);
        this.m_insertFeedback.setBounds(bounds);
        Layer feedbackLayer = this.getMainLayer("Feedback Layer");
        if (this.m_feedback == null) {
            this.m_feedback = new TextFeedback(feedbackLayer);
            this.m_feedback.add();
        }
        Point feedbackLocation = new Point(10, location.y + 10);
        FigureUtils.translateAbsoluteToFigure((IFigure)feedbackLayer, (Translatable)feedbackLocation);
        this.m_feedback.setLocation(feedbackLocation);
        this.m_feedback.setText(MessageFormat.format(GefMessages.RowsLayoutEditPolicy_feedbackPattern, 1 + index));
        row = (FormRowInfo)headerEditPart.getDimension();
        final int targetIndex = index;
        this.m_moveCommand = new EditCommand((ObjectInfo)this.m_layout){

            protected void executeEdit() throws Exception {
                RowsLayoutEditPolicy.this.m_layout.command_MOVE_ROW(RowsLayoutEditPolicy.this.m_layout.getRows().indexOf(row), targetIndex);
            }
        };
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.m_mainPolicy.eraseInsertFeedbacks();
        FigureUtils.removeFigure((IFigure)this.m_insertFeedback);
        if (this.m_feedback != null) {
            this.m_feedback.remove();
            this.m_feedback = null;
        }
    }
}

