/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Field;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.ReflectClass;
import org.eclipse.swt.tools.internal.ReflectItem;
import org.eclipse.swt.tools.internal.ReflectType;

public class ReflectField
extends ReflectItem
implements JNIField {
    Field field;
    ReflectType type;
    ReflectClass declaringClass;

    public ReflectField(ReflectClass declaringClass, Field field) {
        this.declaringClass = declaringClass;
        this.field = field;
        Class<?> clazz = field.getType();
        this.type = new ReflectType(clazz);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReflectField)) {
            return false;
        }
        return ((ReflectField)obj).field.equals(this.field);
    }

    @Override
    public JNIClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public int getModifiers() {
        return this.field.getModifiers();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public JNIType getType() {
        return this.type;
    }

    @Override
    public String getAccessor() {
        return (String)this.getParam("accessor");
    }

    @Override
    public String getCast() {
        Object cast = ((String)this.getParam("cast")).trim();
        if (((String)cast).length() > 0) {
            if (!((String)cast).startsWith("(")) {
                cast = "(" + (String)cast;
            }
            if (!((String)cast).endsWith(")")) {
                cast = (String)cast + ")";
            }
        }
        return cast;
    }

    @Override
    public String getExclude() {
        return (String)this.getParam("exclude");
    }

    @Override
    public String getMetaData() {
        String className = this.getDeclaringClass().getSimpleName();
        String key = className + "_" + this.field.getName();
        return this.declaringClass.metaData.getMetaData(key, "");
    }

    @Override
    public void setAccessor(String str) {
        this.setParam("accessor", str);
    }

    @Override
    public void setCast(String str) {
        this.setParam("cast", str);
    }

    @Override
    public void setExclude(String str) {
        this.setParam("exclude", str);
    }

    @Override
    public void setMetaData(String value) {
        String className = this.declaringClass.getSimpleName();
        String key = className + "_" + this.field.getName();
        this.declaringClass.metaData.setMetaData(key, value);
    }

    public String toString() {
        return this.field.toString();
    }
}

